/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.recipe.DummyCraftingContainer;
import com.simibubi.create.foundation.utility.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BasinRecipe
extends ProcessingRecipe<SmartInventory> {
    public static boolean match(BasinTileEntity basin, Recipe<?> recipe) {
        BasinRecipe basinRecipe;
        FilteringBehaviour filter = basin.getFilter();
        if (filter == null) {
            return false;
        }
        boolean filterTest = filter.test(recipe.m_8043_());
        if (recipe instanceof BasinRecipe && (basinRecipe = (BasinRecipe)recipe).getRollableResults().isEmpty() && !basinRecipe.getFluidResults().isEmpty()) {
            filterTest = filter.test((FluidStack)basinRecipe.getFluidResults().get(0));
        }
        if (!filterTest) {
            return false;
        }
        return BasinRecipe.apply(basin, recipe, true);
    }

    public static boolean apply(BasinTileEntity basin, Recipe<?> recipe) {
        return BasinRecipe.apply(basin, recipe, false);
    }

    private static boolean apply(BasinTileEntity basin, Recipe<?> recipe, boolean test) {
        boolean isBasinRecipe = recipe instanceof BasinRecipe;
        IItemHandler availableItems = (IItemHandler)basin.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        IFluidHandler availableFluids = (IFluidHandler)basin.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        if (availableItems == null || availableFluids == null) {
            return false;
        }
        BlazeBurnerBlock.HeatLevel heat = BasinTileEntity.getHeatLevelOf(basin.m_58904_().m_8055_(basin.m_58899_().m_6625_(1)));
        if (isBasinRecipe && !((BasinRecipe)recipe).getRequiredHeat().testBlazeBurner(heat)) {
            return false;
        }
        ArrayList<ItemStack> recipeOutputItems = new ArrayList<ItemStack>();
        ArrayList<FluidStack> recipeOutputFluids = new ArrayList<FluidStack>();
        LinkedList ingredients = new LinkedList(recipe.m_7527_());
        List fluidIngredients = isBasinRecipe ? ((BasinRecipe)recipe).getFluidIngredients() : Collections.emptyList();
        for (boolean simulate : Iterate.trueAndFalse) {
            if (!simulate && test) {
                return true;
            }
            int[] extractedItemsFromSlot = new int[availableItems.getSlots()];
            int[] extractedFluidsFromTank = new int[availableFluids.getTanks()];
            block1: for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                for (int slot = 0; slot < availableItems.getSlots(); ++slot) {
                    ItemStack extracted;
                    if (simulate && availableItems.getStackInSlot(slot).m_41613_() <= extractedItemsFromSlot[slot] || !ingredient.test(extracted = availableItems.extractItem(slot, 1, true))) continue;
                    if (extracted.hasCraftingRemainingItem() && extracted.getCraftingRemainingItem().m_41656_(extracted)) continue block1;
                    if (!simulate) {
                        availableItems.extractItem(slot, 1, false);
                    } else if (extracted.hasCraftingRemainingItem()) {
                        recipeOutputItems.add(extracted.getCraftingRemainingItem().m_41777_());
                    }
                    int n = slot;
                    extractedItemsFromSlot[n] = extractedItemsFromSlot[n] + 1;
                    continue block1;
                }
                return false;
            }
            boolean fluidsAffected = false;
            for (int i = 0; i < fluidIngredients.size(); ++i) {
                int drainedAmount;
                int tank;
                block18: {
                    FluidIngredient fluidIngredient = (FluidIngredient)fluidIngredients.get(i);
                    int amountRequired = fluidIngredient.getRequiredAmount();
                    for (tank = 0; tank < availableFluids.getTanks(); ++tank) {
                        FluidStack fluidStack = availableFluids.getFluidInTank(tank);
                        if (simulate && fluidStack.getAmount() <= extractedFluidsFromTank[tank] || !fluidIngredient.test(fluidStack)) continue;
                        drainedAmount = Math.min(amountRequired, fluidStack.getAmount());
                        if (!simulate) {
                            fluidStack.shrink(drainedAmount);
                            fluidsAffected = true;
                        }
                        if ((amountRequired -= drainedAmount) != 0) {
                            continue;
                        }
                        break block18;
                    }
                    return false;
                }
                int n = tank;
                extractedFluidsFromTank[n] = extractedFluidsFromTank[n] + drainedAmount;
            }
            if (fluidsAffected) {
                basin.getBehaviour(SmartFluidTankBehaviour.INPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
                basin.getBehaviour(SmartFluidTankBehaviour.OUTPUT).forEach(SmartFluidTankBehaviour.TankSegment::onFluidStackChanged);
            }
            if (simulate) {
                if (recipe instanceof BasinRecipe) {
                    BasinRecipe basinRecipe = (BasinRecipe)recipe;
                    recipeOutputItems.addAll(basinRecipe.rollResults());
                    recipeOutputFluids.addAll((Collection<FluidStack>)basinRecipe.getFluidResults());
                    recipeOutputItems.addAll((Collection<ItemStack>)basinRecipe.m_7457_((Container)basin.getInputInventory()));
                } else {
                    recipeOutputItems.add(recipe.m_8043_());
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        recipeOutputItems.addAll((Collection<ItemStack>)craftingRecipe.m_7457_((Container)new DummyCraftingContainer(availableItems, extractedItemsFromSlot)));
                    }
                }
            }
            if (basin.acceptOutputs(recipeOutputItems, recipeOutputFluids, simulate)) continue;
            return false;
        }
        return true;
    }

    public static BasinRecipe convertShapeless(Recipe<?> recipe) {
        BasinRecipe basinRecipe = new ProcessingRecipeBuilder<BasinRecipe>(BasinRecipe::new, recipe.m_6423_()).withItemIngredients((NonNullList<Ingredient>)recipe.m_7527_()).withSingleItemOutput(recipe.m_8043_()).build();
        return basinRecipe;
    }

    protected BasinRecipe(IRecipeTypeInfo type, ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(type, params);
    }

    public BasinRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        this(AllRecipeTypes.BASIN, params);
    }

    @Override
    protected int getMaxInputCount() {
        return 9;
    }

    @Override
    protected int getMaxOutputCount() {
        return 4;
    }

    @Override
    protected int getMaxFluidInputCount() {
        return 2;
    }

    @Override
    protected int getMaxFluidOutputCount() {
        return 2;
    }

    @Override
    protected boolean canRequireHeat() {
        return true;
    }

    public boolean matches(SmartInventory inv, @Nonnull Level worldIn) {
        return false;
    }
}

