/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.curiosities.toolbox.ToolboxBlock;
import com.simibubi.create.content.curiosities.toolbox.ToolboxContainer;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.ResetableLazy;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ToolboxTileEntity
extends SmartTileEntity
implements MenuProvider,
Nameable {
    public LerpedFloat lid = LerpedFloat.linear().startWithValue(0.0);
    public LerpedFloat drawers = LerpedFloat.linear().startWithValue(0.0);
    UUID uniqueId;
    ToolboxInventory inventory;
    LazyOptional<IItemHandler> inventoryProvider;
    ResetableLazy<DyeColor> colorProvider;
    protected int openCount;
    Map<Integer, WeakHashMap<Player, Integer>> connectedPlayers = new HashMap<Integer, WeakHashMap<Player, Integer>>();
    private Component customName;

    public ToolboxTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ToolboxInventory(this);
        this.inventoryProvider = LazyOptional.of(() -> this.inventory);
        this.colorProvider = ResetableLazy.of(() -> {
            BlockState blockState = this.m_58900_();
            if (blockState != null && blockState.m_60734_() instanceof ToolboxBlock) {
                return ((ToolboxBlock)blockState.m_60734_()).getColor();
            }
            return DyeColor.BROWN;
        });
        this.setLazyTickRate(10);
    }

    public DyeColor getColor() {
        return this.colorProvider.get();
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void initialize() {
        super.initialize();
        ToolboxHandler.onLoad(this);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        ToolboxHandler.onUnload(this);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.tickAudio();
        }
        if (!this.f_58857_.f_46443_) {
            this.tickPlayers();
        }
        this.lid.chase(this.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.LINEAR);
        this.drawers.chase(this.openCount > 0 ? 1.0 : 0.0, 0.2f, LerpedFloat.Chaser.EXP);
        this.lid.tickChaser();
        this.drawers.tickChaser();
    }

    private void tickPlayers() {
        boolean update = false;
        Iterator<Map.Entry<Integer, WeakHashMap<Player, Integer>>> toolboxSlots = this.connectedPlayers.entrySet().iterator();
        while (toolboxSlots.hasNext()) {
            Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry = toolboxSlots.next();
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            int slot = toolboxSlotEntry.getKey();
            ItemStack referenceItem = this.inventory.filters.get(slot);
            boolean clear = referenceItem.m_41619_();
            Iterator<Map.Entry<Player, Integer>> playerEntries = set.entrySet().iterator();
            while (playerEntries.hasNext()) {
                int deposited;
                int targetAmount;
                Map.Entry<Player, Integer> playerEntry = playerEntries.next();
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                if (!clear && !ToolboxHandler.withinRange(player, this)) continue;
                Inventory playerInv = player.m_150109_();
                ItemStack playerStack = playerInv.m_8020_(hotbarSlot);
                if (clear || !playerStack.m_41619_() && !ToolboxInventory.canItemsShareCompartment(playerStack, referenceItem)) {
                    player.getPersistentData().m_128469_("CreateToolboxData").m_128473_(String.valueOf(hotbarSlot));
                    playerEntries.remove();
                    if (!(player instanceof ServerPlayer)) continue;
                    ToolboxHandler.syncData(player);
                    continue;
                }
                int count = playerStack.m_41613_();
                if (count < (targetAmount = (referenceItem.m_41741_() + 1) / 2)) {
                    ItemStack extracted;
                    int amountToReplenish = targetAmount - count;
                    if (this.isOpenInContainer(player) && !(extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, true)).m_41619_()) {
                        ToolboxHandler.unequip(player, hotbarSlot, false);
                        ToolboxHandler.syncData(player);
                        continue;
                    }
                    extracted = this.inventory.takeFromCompartment(amountToReplenish, slot, false);
                    if (!extracted.m_41619_()) {
                        update = true;
                        ItemStack template = playerStack.m_41619_() ? extracted : playerStack;
                        playerInv.m_6836_(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)template, (int)(count + extracted.m_41613_())));
                    }
                }
                if (count <= targetAmount) continue;
                int amountToDeposit = count - targetAmount;
                ItemStack toDistribute = ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)amountToDeposit);
                if (this.isOpenInContainer(player) && (deposited = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, true).m_41613_()) > 0) {
                    ToolboxHandler.unequip(player, hotbarSlot, true);
                    ToolboxHandler.syncData(player);
                    continue;
                }
                int deposited2 = amountToDeposit - this.inventory.distributeToCompartment(toDistribute, slot, false).m_41613_();
                if (deposited2 <= 0) continue;
                update = true;
                playerInv.m_6836_(hotbarSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)playerStack, (int)(count - deposited2)));
            }
            if (!clear) continue;
            toolboxSlots.remove();
        }
        if (update) {
            this.sendData();
        }
    }

    private boolean isOpenInContainer(Player player) {
        return player.f_36096_ instanceof ToolboxContainer && ((ToolboxContainer)player.f_36096_).contentHolder == this;
    }

    public void unequipTracked() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        HashSet<ServerPlayer> affected = new HashSet<ServerPlayer>();
        for (Map.Entry<Integer, WeakHashMap<Player, Integer>> toolboxSlotEntry : this.connectedPlayers.entrySet()) {
            WeakHashMap<Player, Integer> set = toolboxSlotEntry.getValue();
            for (Map.Entry<Player, Integer> playerEntry : set.entrySet()) {
                Player player = playerEntry.getKey();
                int hotbarSlot = playerEntry.getValue();
                ToolboxHandler.unequip(player, hotbarSlot, false);
                if (!(player instanceof ServerPlayer)) continue;
                affected.add((ServerPlayer)player);
            }
        }
        for (ServerPlayer player : affected) {
            ToolboxHandler.syncData((Player)player);
        }
        this.connectedPlayers.clear();
    }

    public void unequip(int slot, Player player, int hotbarSlot, boolean keepItems) {
        if (!this.connectedPlayers.containsKey(slot)) {
            return;
        }
        this.connectedPlayers.get(slot).remove(player);
        if (keepItems) {
            return;
        }
        Inventory playerInv = player.m_150109_();
        ItemStack playerStack = playerInv.m_8020_(hotbarSlot);
        ItemStack toInsert = ToolboxInventory.cleanItemNBT(playerStack.m_41777_());
        ItemStack remainder = this.inventory.distributeToCompartment(toInsert, slot, false);
        if (remainder.m_41613_() != toInsert.m_41613_()) {
            playerInv.m_6836_(hotbarSlot, remainder);
        }
    }

    private void tickAudio() {
        Vec3 vec = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        if (this.lid.settled()) {
            if (this.openCount > 0 && this.lid.getChaseTarget() == 0.0f) {
                this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_12056_, SoundSource.BLOCKS, 0.25f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.2f, true);
                this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.1f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.1f, true);
            }
            if (this.openCount == 0 && this.lid.getChaseTarget() == 1.0f) {
                this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.1f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.1f, true);
            }
        } else if (this.openCount == 0 && this.lid.getChaseTarget() == 0.0f && this.lid.getValue(0.0f) > 0.0625f && this.lid.getValue(1.0f) < 0.0625f) {
            this.f_58857_.m_7785_(vec.f_82479_, vec.f_82480_, vec.f_82481_, SoundEvents.f_12055_, SoundSource.BLOCKS, 0.25f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 1.2f, true);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.inventoryProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
        super.read(compound, clientPacket);
        if (compound.m_128425_("UniqueId", 11)) {
            this.uniqueId = compound.m_128342_("UniqueId");
        }
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        if (clientPacket) {
            this.openCount = compound.m_128451_("OpenCount");
        }
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.uniqueId == null) {
            this.uniqueId = UUID.randomUUID();
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128362_("UniqueId", this.uniqueId);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128405_("OpenCount", this.openCount);
        }
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return ToolboxContainer.create(id, inv, this);
    }

    @Override
    public void lazyTick() {
        this.updateOpenCount();
        ToolboxHandler.onLoad(this);
        super.lazyTick();
    }

    void updateOpenCount() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.openCount == 0) {
            return;
        }
        int prevOpenCount = this.openCount;
        this.openCount = 0;
        for (Player playerentity : this.f_58857_.m_45976_(Player.class, new AABB(this.f_58858_).m_82400_(8.0))) {
            if (!(playerentity.f_36096_ instanceof ToolboxContainer) || ((ToolboxContainer)playerentity.f_36096_).contentHolder != this) continue;
            ++this.openCount;
        }
        if (prevOpenCount != this.openCount) {
            this.sendData();
        }
    }

    public void startOpen(Player player) {
        if (player.m_5833_()) {
            return;
        }
        if (this.openCount < 0) {
            this.openCount = 0;
        }
        ++this.openCount;
        this.sendData();
    }

    public void stopOpen(Player player) {
        if (player.m_5833_()) {
            return;
        }
        --this.openCount;
        this.sendData();
    }

    public void connectPlayer(int slot, Player player, int hotbarSlot) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        WeakHashMap map = this.connectedPlayers.computeIfAbsent(slot, WeakHashMap::new);
        Integer previous = (Integer)map.get(player);
        if (previous != null) {
            if (previous == hotbarSlot) {
                return;
            }
            ToolboxHandler.unequip(player, previous, false);
        }
        map.put(player, hotbarSlot);
    }

    public void readInventory(CompoundTag compound) {
        this.inventory.deserializeNBT(compound);
    }

    public void setUniqueId(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public boolean isFullyInitialized() {
        return this.uniqueId != null;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
    }

    public Component m_5446_() {
        return this.customName != null ? this.customName : ((ToolboxBlock)AllBlocks.TOOLBOXES.get(this.getColor()).get()).m_49954_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_7755_() {
        return this.customName;
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.colorProvider.reset();
    }
}

