/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.zapper.terrainzapper;

import com.simibubi.create.content.curiosities.zapper.terrainzapper.TerrainTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class FlattenTool {
    static float[][] kernel = new float[][]{{0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.023792f, 0.094907f, 0.150342f, 0.094907f, 0.023792f}, {0.015019f, 0.059912f, 0.094907f, 0.059912f, 0.015019f}, {0.003765f, 0.015019f, 0.023792f, 0.015019f, 0.003765f}};

    private static int[][] applyKernel(int[][] values) {
        int[][] result = new int[values.length][values[0].length];
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values[i].length; ++j) {
                int value = values[i][j];
                float newValue = 0.0f;
                for (int iOffset = -2; iOffset <= 2; ++iOffset) {
                    for (int jOffset = -2; jOffset <= 2; ++jOffset) {
                        int iTarget = i + iOffset;
                        int jTarget = j + jOffset;
                        int ref = 0;
                        ref = iTarget < 0 || iTarget >= values.length || jTarget < 0 || jTarget >= values[0].length ? value : values[iTarget][jTarget];
                        if (ref == Integer.MIN_VALUE) {
                            ref = value;
                        }
                        newValue += kernel[iOffset + 2][jOffset + 2] * (float)ref;
                    }
                }
                result[i][j] = Mth.m_14143_((float)(newValue + 0.5f));
            }
        }
        return result;
    }

    public static void apply(Level world, List<BlockPos> targetPositions, Direction facing) {
        ArrayList<BlockPos> surfaces = new ArrayList<BlockPos>();
        HashMap<Pair<Integer, Integer>, Integer> heightMap = new HashMap<Pair<Integer, Integer>, Integer>();
        int offset = facing.m_122421_().m_122540_();
        int minEntry = Integer.MAX_VALUE;
        int minCoord1 = Integer.MAX_VALUE;
        int minCoord2 = Integer.MAX_VALUE;
        int maxEntry = Integer.MIN_VALUE;
        int maxCoord1 = Integer.MIN_VALUE;
        int maxCoord2 = Integer.MIN_VALUE;
        for (BlockPos p : targetPositions) {
            Pair<Integer, Integer> coords = FlattenTool.getCoords(p, facing);
            BlockState belowSurface = world.m_8055_(p);
            minCoord1 = Math.min(minCoord1, (Integer)coords.getKey());
            minCoord2 = Math.min(minCoord2, (Integer)coords.getValue());
            maxCoord1 = Math.max(maxCoord1, (Integer)coords.getKey());
            maxCoord2 = Math.max(maxCoord2, (Integer)coords.getValue());
            if (TerrainTools.isReplaceable(belowSurface)) {
                if (heightMap.containsKey(coords)) continue;
                heightMap.put(coords, Integer.MIN_VALUE);
                continue;
            }
            BlockState surface = world.m_8055_(p = p.m_121945_(facing));
            if (!TerrainTools.isReplaceable(surface)) {
                if (heightMap.containsKey(coords) && !((Integer)heightMap.get(coords)).equals(Integer.MIN_VALUE)) continue;
                heightMap.put(coords, Integer.MAX_VALUE);
                continue;
            }
            surfaces.add(p);
            int coordinate = facing.m_122434_().m_7863_(p.m_123341_(), p.m_123342_(), p.m_123343_());
            if (heightMap.containsKey(coords) && !((Integer)heightMap.get(coords)).equals(Integer.MAX_VALUE) && !((Integer)heightMap.get(coords)).equals(Integer.MIN_VALUE) && (Integer)heightMap.get(coords) * offset >= coordinate * offset) continue;
            heightMap.put(coords, coordinate);
            maxEntry = Math.max(maxEntry, coordinate);
            minEntry = Math.min(minEntry, coordinate);
        }
        if (surfaces.isEmpty()) {
            return;
        }
        int[][] heightMapArray = new int[maxCoord1 - minCoord1 + 1][maxCoord2 - minCoord2 + 1];
        for (int i = 0; i < heightMapArray.length; ++i) {
            for (int j = 0; j < heightMapArray[i].length; ++j) {
                Integer height;
                Pair pair = Pair.of((Object)(minCoord1 + i), (Object)(minCoord2 + j));
                heightMapArray[i][j] = !heightMap.containsKey(pair) ? Integer.MIN_VALUE : ((height = (Integer)heightMap.get(pair)).equals(Integer.MAX_VALUE) ? (offset == 1 ? maxEntry + 2 : minEntry - 2) : (height.equals(Integer.MIN_VALUE) ? (offset == 1 ? minEntry - 2 : maxEntry + 2) : height));
            }
        }
        heightMapArray = FlattenTool.applyKernel(heightMapArray);
        block3: for (BlockPos p : surfaces) {
            int targetCoord;
            Pair<Integer, Integer> coords = FlattenTool.getCoords(p, facing);
            int surfaceCoord = facing.m_122434_().m_7863_(p.m_123341_(), p.m_123342_(), p.m_123343_()) * offset;
            if (surfaceCoord == (targetCoord = heightMapArray[(Integer)coords.getKey() - minCoord1][(Integer)coords.getValue() - minCoord2] * offset)) continue;
            BlockState blockState = world.m_8055_(p);
            int timeOut = 1000;
            while (surfaceCoord > targetCoord) {
                BlockPos below = p.m_121945_(facing.m_122424_());
                world.m_46597_(below, blockState);
                world.m_46597_(p, blockState.m_60819_().m_76188_());
                p = p.m_121945_(facing.m_122424_());
                --surfaceCoord;
                if (timeOut-- > 0) continue;
                break;
            }
            while (surfaceCoord < targetCoord) {
                BlockPos above = p.m_121945_(facing);
                if (!(blockState.m_60734_() instanceof LiquidBlock)) {
                    world.m_46597_(above, blockState);
                }
                world.m_46597_(p, world.m_8055_(p.m_121945_(facing.m_122424_())));
                p = p.m_121945_(facing);
                ++surfaceCoord;
                if (timeOut-- > 0) continue;
                continue block3;
            }
        }
    }

    private static Pair<Integer, Integer> getCoords(BlockPos pos, Direction facing) {
        switch (facing.m_122434_()) {
            case X: {
                return Pair.of((Object)pos.m_123343_(), (Object)pos.m_123342_());
            }
            case Y: {
                return Pair.of((Object)pos.m_123341_(), (Object)pos.m_123343_());
            }
            case Z: {
                return Pair.of((Object)pos.m_123341_(), (Object)pos.m_123342_());
            }
        }
        return null;
    }
}

