/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute;

import com.simibubi.create.content.logistics.item.filter.ItemAttribute;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.ItemStack;

public class ColorAttribute
implements ItemAttribute {
    public static final ColorAttribute EMPTY = new ColorAttribute(DyeColor.PURPLE);
    public final DyeColor color;

    public ColorAttribute(DyeColor color) {
        this.color = color;
    }

    @Override
    public boolean appliesTo(ItemStack itemStack) {
        return this.findMatchingDyeColors(itemStack).stream().anyMatch(arg_0 -> this.color.equals(arg_0));
    }

    @Override
    public List<ItemAttribute> listAttributesOf(ItemStack itemStack) {
        return this.findMatchingDyeColors(itemStack).stream().map(ColorAttribute::new).collect(Collectors.toList());
    }

    private Collection<DyeColor> findMatchingDyeColors(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        DyeColor color = DyeColor.getColor((ItemStack)stack);
        if (color != null) {
            return Collections.singletonList(color);
        }
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        if (stack.m_41720_() instanceof FireworkRocketItem && nbt != null) {
            ListTag listnbt = nbt.m_128469_("Fireworks").m_128437_("Explosions", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                colors.addAll(this.getFireworkStarColors(listnbt.m_128728_(i)));
            }
        }
        if (stack.m_41720_() instanceof FireworkStarItem && nbt != null) {
            colors.addAll(this.getFireworkStarColors(nbt.m_128469_("Explosion")));
        }
        Arrays.stream(DyeColor.values()).filter(c -> RegisteredObjects.getKeyOrThrow(stack.m_41720_()).m_135815_().startsWith(c.m_41065_() + "_")).forEach(colors::add);
        return colors;
    }

    private Collection<DyeColor> getFireworkStarColors(CompoundTag compound) {
        HashSet<DyeColor> colors = new HashSet<DyeColor>();
        Arrays.stream(compound.m_128465_("Colors")).mapToObj(DyeColor::m_41061_).forEach(colors::add);
        Arrays.stream(compound.m_128465_("FadeColors")).mapToObj(DyeColor::m_41061_).forEach(colors::add);
        return colors;
    }

    @Override
    public String getTranslationKey() {
        return "color";
    }

    @Override
    public Object[] getTranslationParameters() {
        return new Object[]{I18n.m_118938_((String)("color.minecraft." + this.color.m_41065_()), (Object[])new Object[0])};
    }

    @Override
    public void writeNBT(CompoundTag nbt) {
        nbt.m_128405_("id", this.color.m_41060_());
    }

    @Override
    public ItemAttribute readNBT(CompoundTag nbt) {
        return nbt.m_128441_("id") ? new ColorAttribute(DyeColor.m_41053_((int)nbt.m_128451_("id"))) : EMPTY;
    }
}

