/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.gui.widget.AbstractSimiWidget;
import com.simibubi.create.foundation.utility.Components;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class Label
extends AbstractSimiWidget {
    public Component text;
    public String suffix;
    protected boolean hasShadow;
    protected int color;
    protected Font font;

    public Label(int x, int y, Component text) {
        super(x, y, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text), 10);
        this.font = Minecraft.m_91087_().f_91062_;
        this.text = Components.literal("Label");
        this.color = 0xFFFFFF;
        this.hasShadow = false;
        this.suffix = "";
    }

    public Label colored(int color) {
        this.color = color;
        return this;
    }

    public Label withShadow() {
        this.hasShadow = true;
        return this;
    }

    public Label withSuffix(String s) {
        this.suffix = s;
        return this;
    }

    public void setTextAndTrim(Component newText, boolean trimFront, int maxWidthPx) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        if (fontRenderer.m_92852_((FormattedText)newText) <= maxWidthPx) {
            this.text = newText;
            return;
        }
        String trim = "...";
        int trimWidth = fontRenderer.m_92895_(trim);
        String raw = newText.getString();
        StringBuilder builder = new StringBuilder(raw);
        int startIndex = trimFront ? 0 : raw.length() - 1;
        int endIndex = !trimFront ? 0 : raw.length() - 1;
        int step = (int)Math.signum(endIndex - startIndex);
        for (int i = startIndex; i != endIndex; i += step) {
            String sub = builder.substring(trimFront ? i : startIndex, trimFront ? endIndex + 1 : i + 1);
            if (fontRenderer.m_92852_((FormattedText)Components.literal(sub).m_6270_(newText.m_7383_())) + trimWidth > maxWidthPx) continue;
            this.text = Components.literal(trimFront ? trim + sub : sub + trim).m_6270_(newText.m_7383_());
            return;
        }
    }

    @Override
    public void m_6303_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.text == null || this.text.getString().isEmpty()) {
            return;
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MutableComponent copy = this.text.m_6879_();
        if (this.suffix != null && !this.suffix.isEmpty()) {
            copy.m_130946_(this.suffix);
        }
        if (this.hasShadow) {
            this.font.m_92763_(matrixStack, (Component)copy, (float)this.f_93620_, (float)this.f_93621_, this.color);
        } else {
            this.font.m_92889_(matrixStack, (Component)copy, (float)this.f_93620_, (float)this.f_93621_, this.color);
        }
    }
}

