/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.api;

import com.minecolonies.api.inventory.api.IWorldNameableModifiable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedItemHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag>,
IWorldNameableModifiable {
    private static final String NBT_KEY_HANDLERS = "Handlers";
    private static final String NBT_KEY_HANDLERS_INDEXLIST = "Index";
    private static final String NBT_KEY_NAME = "Name";
    private final IItemHandlerModifiable[] handlers;
    @NotNull
    private String defaultName = "";
    @NotNull
    private String customName = "";
    private int totalSlots = 0;

    public CombinedItemHandler(@NotNull String defaultName, IItemHandlerModifiable ... handlers) {
        this.handlers = handlers;
        this.defaultName = defaultName;
        for (IItemHandlerModifiable handler : handlers) {
            if (handler == null) continue;
            this.totalSlots += handler.getSlots();
        }
    }

    public CombinedItemHandler(@NotNull String defaultName, @NotNull String customName, IItemHandlerModifiable ... handlers) {
        this(defaultName, handlers);
        this.customName = customName;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        int index = 0;
        ListTag handlerList = new ListTag();
        ListTag indexList = new ListTag();
        for (IItemHandlerModifiable handlerModifiable : this.handlers) {
            if (handlerModifiable instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)handlerModifiable;
                handlerList.add((Object)serializable.serializeNBT());
                indexList.add((Object)IntTag.m_128679_((int)index));
            }
            ++index;
        }
        compound.m_128365_(NBT_KEY_HANDLERS, (Tag)handlerList);
        compound.m_128365_(NBT_KEY_HANDLERS_INDEXLIST, (Tag)indexList);
        if (this.customName != null) {
            compound.m_128359_(NBT_KEY_NAME, this.customName);
        }
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag handlerList = nbt.m_128437_(NBT_KEY_HANDLERS, 10);
        ListTag indexList = nbt.m_128437_(NBT_KEY_HANDLERS_INDEXLIST, 3);
        if (handlerList.size() == this.handlers.length) {
            for (int i = 0; i < handlerList.size(); ++i) {
                CompoundTag handlerCompound = handlerList.m_128728_(i);
                IItemHandlerModifiable modifiable = this.handlers[indexList.m_128763_(i)];
                if (!(modifiable instanceof INBTSerializable)) continue;
                INBTSerializable serializable = (INBTSerializable)modifiable;
                serializable.deserializeNBT((Tag)handlerCompound);
            }
        }
        this.setName(nbt.m_128431_().contains(NBT_KEY_NAME) ? nbt.m_128461_(NBT_KEY_NAME) : null);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                modifiable.setStackInSlot(activeSlot, stack);
                return;
            }
            activeSlot -= modifiable.getSlots();
        }
    }

    public int getLastIndex(int slot) {
        int slots = 0;
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getSlots() + slots;
            }
            slots += modifiable.getSlots();
            activeSlot -= modifiable.getSlots();
        }
        return 0;
    }

    public int getSlots() {
        return this.totalSlots;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getStackInSlot(activeSlot);
            }
            activeSlot -= modifiable.getSlots();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.insertItem(activeSlot, stack, simulate);
            }
            activeSlot -= modifiable.getSlots();
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int checkedSlots = 0;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (modifiable.getSlots() + checkedSlots <= slot) {
                checkedSlots += modifiable.getSlots();
                continue;
            }
            int activeSlot = slot - checkedSlots;
            if (activeSlot >= modifiable.getSlots()) continue;
            return modifiable.extractItem(activeSlot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int slotIndex = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (slotIndex >= modifiable.getSlots()) {
                slotIndex -= modifiable.getSlots();
                continue;
            }
            return modifiable.getSlotLimit(slotIndex);
        }
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        int slotIndex = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (slotIndex >= modifiable.getSlots()) {
                slotIndex -= modifiable.getSlots();
                continue;
            }
            return modifiable.isItemValid(slotIndex, stack);
        }
        return false;
    }

    protected IItemHandlerModifiable[] getHandlers() {
        return (IItemHandlerModifiable[])this.handlers.clone();
    }

    @Override
    public void setName(@Nullable String name) {
        this.customName = name == null ? "" : name;
    }

    @NotNull
    public Component m_7755_() {
        return Component.m_237113_((String)(this.customName.isEmpty() ? this.defaultName : this.customName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedItemHandler that = (CombinedItemHandler)o;
        if (this.handlers.length != that.handlers.length) {
            return false;
        }
        int length = this.handlers.length;
        for (int i = 0; i < length; ++i) {
            if (this.handlers[i] == that.handlers[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.handlers);
    }
}

