/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonHandler;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WindowAssignCitizen
extends AbstractWindowSkeleton
implements ButtonHandler {
    private static final double FAR_DISTANCE_THRESHOLD = 250.0;
    private final LivingBuildingView building;
    private final ScrollingList citizenList;
    private final IColonyView colony;
    private List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();

    public WindowAssignCitizen(IColonyView c, LivingBuildingView building) {
        super("minecolonies:gui/windowassigncitizen.xml");
        this.colony = c;
        this.building = building;
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unassigned", ScrollingList.class);
        super.registerButton("cancel", this::cancelClicked);
        super.registerButton("mode", this::modeClicked);
        super.registerButton("done", this::hireClicked);
        this.updateCitizens();
        this.setupSettings((Button)this.findPaneOfTypeByID("mode", Button.class));
    }

    private void hireClicked(@NotNull Button button) {
        int row = this.citizenList.getListElementIndexByPane((Pane)button);
        ICitizenDataView data = this.citizens.get(row);
        boolean isAssign = button.getText().getString().equals(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonassign").getString());
        if (isAssign) {
            if (this.building.getResidents().size() >= this.building.getMax()) {
                return;
            }
            this.building.addResident(data.getId());
            data.setHomeBuilding(this.building.getPosition());
        } else {
            this.building.removeResident(data.getId());
            data.setHomeBuilding(null);
        }
        Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, isAssign, data.getId(), null));
        this.updateCitizens();
        this.citizenList.refreshElementPanes();
    }

    private void modeClicked(@NotNull Button button) {
        this.switchHiringMode(button);
    }

    private void switchHiringMode(Button settingsButton) {
        int index = this.building.getHiringMode().ordinal() + 1;
        if (index >= HiringMode.values().length) {
            index = 0;
        }
        this.building.setHiringMode(HiringMode.values()[index]);
        this.setupSettings(settingsButton);
    }

    private void cancelClicked(@NotNull Button button) {
        if (button.getID().equals("cancel") && this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }

    private void setupSettings(Button settingsButton) {
        settingsButton.setText(Component.m_237115_((String)("com.minecolonies.coremod.gui.hiringmode." + this.building.getHiringMode().name().toLowerCase(Locale.ENGLISH))));
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(cit -> !(this.colony.getBuilding(cit.getHomeBuilding()) instanceof AbstractBuildingGuards.View)).sorted(Comparator.comparing(cit -> cit.getHomeBuilding() != null && cit.getHomeBuilding().equals((Object)this.building.getPosition()) ? 0 : 1).thenComparing(cit -> cit.getHomeBuilding() == null ? 0 : 1).thenComparingLong(cit -> {
            if (cit.getWorkBuilding() == null) {
                return 0L;
            }
            return BlockPosUtil.getDistance2D(cit.getWorkBuilding(), this.building.getPosition());
        })).collect(Collectors.toList());
    }

    public void onOpened() {
        super.onOpened();
        this.updateCitizens();
        this.citizenList.enable();
        this.citizenList.show();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowAssignCitizen.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = WindowAssignCitizen.this.citizens.get(index);
                Button done = (Button)rowPane.findPaneOfTypeByID("done", Button.class);
                BlockPos home = citizen.getHomeBuilding();
                BlockPos work = citizen.getWorkBuilding();
                boolean assign = false;
                if (home != null && home.equals((Object)WindowAssignCitizen.this.building.getPosition())) {
                    done.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonunassign"));
                } else {
                    assign = true;
                    done.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.hiring.buttonassign"));
                }
                Text citizenLabel = (Text)rowPane.findPaneOfTypeByID("citizen", Text.class);
                citizenLabel.setText(Component.m_237113_((String)citizen.getName()));
                if (assign) {
                    citizenLabel.setColors(AbstractWindowTownHall.YELLOW);
                } else {
                    citizenLabel.setColors(AbstractWindowTownHall.DARKGREEN);
                }
                Object workString = "";
                double newDistance = 0.0;
                if (work != null) {
                    newDistance = BlockPosUtil.getDistance2D(work, WindowAssignCitizen.this.building.getPosition());
                    workString = " " + Component.m_237110_((String)"com.minecolonies.coremod.gui.home.new", (Object[])new Object[]{newDistance}).getString();
                }
                String homeString = Component.m_237115_((String)"com.minecolonies.coremod.gui.home.homeless").getString();
                boolean better = false;
                boolean badCurrentLiving = true;
                if (home != null) {
                    if (work != null) {
                        double oldDistance = BlockPosUtil.getDistance2D(work, home);
                        homeString = Component.m_237110_((String)"com.minecolonies.coremod.gui.home.currently", (Object[])new Object[]{oldDistance}).getString();
                        boolean bl = better = newDistance < oldDistance;
                        if (oldDistance < 250.0) {
                            badCurrentLiving = false;
                        }
                    } else {
                        homeString = Component.m_237110_((String)"com.minecolonies.coremod.gui.home.currently", (Object[])new Object[]{home.m_123341_(), home.m_123342_(), home.m_123343_()}).getString();
                    }
                }
                Text newLivingLabel = (Text)rowPane.findPaneOfTypeByID("job", Text.class);
                if (citizen.getJobView() != null) {
                    newLivingLabel.setText(Component.m_237113_((String)(Component.m_237115_((String)citizen.getJobView().getEntry().getTranslationKey()).getString() + ":" + (String)workString)));
                    if (better) {
                        newLivingLabel.setColors(AbstractWindowTownHall.DARKGREEN);
                    }
                }
                Text currentLivingLabel = (Text)rowPane.findPaneOfTypeByID("living", Text.class);
                if (assign) {
                    currentLivingLabel.setText(Component.m_237113_((String)homeString));
                    if (badCurrentLiving) {
                        currentLivingLabel.setColors(AbstractWindowTownHall.RED);
                    }
                } else {
                    currentLivingLabel.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.home.liveshere"));
                }
                if (!(!WindowAssignCitizen.this.colony.isManualHousing() && WindowAssignCitizen.this.building.getHiringMode() == HiringMode.DEFAULT || WindowAssignCitizen.this.building.getHiringMode() == HiringMode.AUTO || assign && WindowAssignCitizen.this.building.getResidents().size() >= WindowAssignCitizen.this.building.getMax())) {
                    done.enable();
                } else {
                    done.disable();
                }
            }
        });
    }
}

