/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.DynamicTreesSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> REPLANT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "replant"));
    public static final ISettingKey<BoolSetting> RESTRICT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "restrict"));
    public static final ISettingKey<BoolSetting> DEFOLIATE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "defoliate"));
    public static final ISettingKey<DynamicTreesSetting> DYNAMIC_TREES_SIZE = new SettingKey<DynamicTreesSetting>(DynamicTreesSetting.class, new ResourceLocation("minecolonies", "dynamictreeharvestsize"));
    private static final String TAG_RESTRICT_START = "startRestrictionPosition";
    private static final String TAG_RESTRICT_END = "endRestrictionPosition";
    private BlockPos startRestriction = null;
    private BlockPos endRestriction = null;
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "lumberjack";
    private final Set<BlockPos> netherTrees = new HashSet<BlockPos>();
    private static final int FUNGI_MODIFIER = 10;

    public BuildingLumberjack(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHEARS, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        IItemListModule saplingList = this.getModuleMatching(ItemListModule.class, m -> m.getId().equals("saplings"));
        for (ItemStorage sapling : IColonyManager.getInstance().getCompatibilityManager().getCopyOfSaplings()) {
            if (saplingList.isItemInList(sapling)) continue;
            toKeep.put(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(sapling.getItemStack(), stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
        }
        return toKeep;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.startRestriction = compound.m_128431_().contains(TAG_RESTRICT_START) ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_(TAG_RESTRICT_START)) : null;
        this.endRestriction = compound.m_128431_().contains(TAG_RESTRICT_END) ? NbtUtils.m_129239_((CompoundTag)compound.m_128469_(TAG_RESTRICT_END)) : null;
        ListTag netherTreeBinTagList = compound.m_128437_("netherTrees", 10);
        for (int i = 0; i < netherTreeBinTagList.size(); ++i) {
            this.netherTrees.add(BlockPosUtil.readFromListNBT(netherTreeBinTagList, i));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        if (this.startRestriction != null) {
            compound.m_128365_(TAG_RESTRICT_START, (Tag)NbtUtils.m_129224_((BlockPos)this.startRestriction));
        }
        if (this.endRestriction != null) {
            compound.m_128365_(TAG_RESTRICT_END, (Tag)NbtUtils.m_129224_((BlockPos)this.endRestriction));
        }
        @NotNull ListTag netherTreeBinCompoundList = new ListTag();
        for (BlockPos pos : this.netherTrees) {
            BlockPosUtil.writeToListNBT(netherTreeBinCompoundList, pos);
        }
        compound.m_128365_("netherTrees", (Tag)netherTreeBinCompoundList);
        return compound;
    }

    public boolean shouldReplant() {
        return this.getSetting(REPLANT).getValue();
    }

    public boolean shouldDefoliate() {
        return this.getSetting(DEFOLIATE).getValue();
    }

    public boolean shouldRestrict() {
        if (this.getSetting(RESTRICT).getValue() && (this.startRestriction == null || this.endRestriction == null)) {
            this.getSetting(RESTRICT).trigger();
            this.markDirty();
        }
        return this.getSetting(RESTRICT).getValue();
    }

    public void setRestrictedArea(BlockPos startPosition, BlockPos endPosition) {
        this.startRestriction = startPosition;
        this.endRestriction = endPosition;
    }

    public BlockPos getStartRestriction() {
        return this.startRestriction;
    }

    public BlockPos getEndRestriction() {
        return this.endRestriction;
    }

    private void bonemealFungi() {
        WorkerBuildingModule module = this.getFirstModuleOccurance(WorkerBuildingModule.class);
        ICitizenData data = this.getFirstModuleOccurance(WorkerBuildingModule.class).getFirstCitizen();
        if (data == null) {
            return;
        }
        int modifier = Math.max(0, Math.min(10, 100));
        Iterator<BlockPos> iterator = this.netherTrees.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            Level world = this.colony.getWorld();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockState blockState = world.m_8055_(pos);
            Block block = blockState.m_60734_();
            if (block == Blocks.f_50700_ || block == Blocks.f_50691_) {
                BonemealableBlock growable;
                int threshold = modifier + (int)Math.ceil((float)data.getCitizenSkillHandler().getLevel(module.getPrimarySkill()) * (1.0f - (float)modifier / 100.0f));
                int rand = world.m_213780_().m_188503_(100);
                if (rand >= threshold || !(growable = (BonemealableBlock)block).m_7370_((BlockGetter)world, pos, blockState, world.f_46443_) || world.f_46443_ || !growable.m_214167_(world, world.f_46441_, pos, blockState)) continue;
                growable.m_214148_((ServerLevel)world, world.f_46441_, pos, blockState);
                return;
            }
            iterator.remove();
        }
    }

    public Set<BlockPos> getNetherTrees() {
        return new HashSet<BlockPos>(this.netherTrees);
    }

    public void removeNetherTree(BlockPos pos) {
        this.netherTrees.remove(pos);
    }

    public void addNetherTree(BlockPos pos) {
        this.netherTrees.add(pos);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        this.bonemealFungi();
    }

    @Override
    public void serializeToView(@NotNull FriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.shouldRestrict());
        if (this.startRestriction != null && this.endRestriction != null) {
            buf.m_130064_(this.startRestriction);
            buf.m_130064_(this.endRestriction);
        } else {
            buf.m_130064_(BlockPos.f_121853_);
            buf.m_130064_(BlockPos.f_121853_);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }

    public static class View
    extends AbstractBuildingView {
        private boolean restrict;
        private BlockPos startRestriction;
        private BlockPos endRestriction;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull FriendlyByteBuf buf) {
            super.deserialize(buf);
            this.restrict = buf.readBoolean();
            this.startRestriction = buf.m_130135_();
            this.endRestriction = buf.m_130135_();
        }

        public boolean shouldRestrict() {
            return this.restrict;
        }

        public BlockPos getStartRestriction() {
            return this.startRestriction;
        }

        public BlockPos getEndRestriction() {
            return this.endRestriction;
        }
    }
}

