/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.commands.generalcommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.commands.commandTypes.IMCCommand;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CommandRTP
implements IMCCommand {
    private static final int STARTING_Y = 250;
    private static final double SAFETY_DROP = 6.0;
    private static final int FALL_DISTANCE = 5;

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        this.rtp((Player)((CommandSourceStack)context.getSource()).m_81373_());
        return 1;
    }

    private int executeOtherPlayerRTP(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!this.checkPreCondition(context) || !IMCCommand.isPlayerOped((Player)sender)) {
            return 0;
        }
        GameProfile profile = GameProfileArgument.m_94590_(context, (String)"playername").stream().findFirst().orElse(null);
        if (profile == null || ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(profile.getId()) == null) {
            MessageUtils.format("com.minecolonies.command.playernotfound", profile != null ? profile.getName() : "null").sendTo((Player)sender);
            return 0;
        }
        this.rtp((Player)((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11259_(profile.getId()));
        return 1;
    }

    @Override
    public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (!(sender instanceof Player)) {
            return false;
        }
        if (!((Boolean)MineColonies.getConfig().getServer().canPlayerUseRTPCommand.get()).booleanValue()) {
            MessageUtils.format("com.minecolonies.command.rtp.notallowed", new Object[0]).sendTo((Player)sender);
            return false;
        }
        if (!((Boolean)MineColonies.getConfig().getServer().allowOtherDimColonies.get()).booleanValue() && ((CommandSourceStack)context.getSource()).m_81372_().m_46472_() != Level.f_46428_) {
            MessageUtils.format("com.minecolonies.command.rtp.wrongdim", new Object[0]).sendTo((Player)sender);
            return false;
        }
        return true;
    }

    private void rtp(Player player) {
        for (int attCounter = 0; attCounter <= (Integer)MineColonies.getConfig().getServer().numberOfAttemptsForSafeTP.get(); ++attCounter) {
            BlockPos groundPosition;
            int x = CommandRTP.getRandCoordinate();
            int z = CommandRTP.getRandCoordinate();
            BlockPos spawnPoint = ((ServerLevel)player.m_20193_()).m_220360_();
            if ((long)player.m_20193_().m_6857_().m_61963_() < BlockPosUtil.getDistance2D(spawnPoint, spawnPoint.m_7918_(x, 0, z))) continue;
            BlockPos tpPos = new BlockPos(x, 250, z);
            IColony colony = IColonyManager.getInstance().getClosestColony(player.m_20193_(), tpPos);
            if (colony != null && BlockPosUtil.getDistance2D(colony.getCenter(), tpPos) < (long)((Integer)MineColonies.getConfig().getServer().maxColonySize.get() * 32) || (groundPosition = BlockPosUtil.findLand(tpPos, player.m_20193_())) == null || !BlockPosUtil.isPositionSafe(player.m_20193_(), groundPosition.m_7495_())) continue;
            player.m_21153_(player.m_21233_());
            player.m_6021_((double)groundPosition.m_123341_(), (double)groundPosition.m_123342_() + 6.0, (double)groundPosition.m_123343_());
            player.m_21153_(player.m_21233_());
            MessageUtils.format("com.minecolonies.command.rtp.success", new Object[0]).sendTo(player);
            player.f_19789_ = -5.0f;
            return;
        }
        MessageUtils.format("com.minecolonies.command.rtp.nopositionfound", new Object[0]).sendTo(player);
    }

    private static int getRandCoordinate() {
        Random rnd = new Random();
        int x = 0;
        while (x > -((Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()).intValue() && x < (Integer)MineColonies.getConfig().getServer().minDistanceFromWorldSpawn.get()) {
            x = rnd.nextInt((Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get() * 2) - (Integer)MineColonies.getConfig().getServer().maxDistanceFromWorldSpawn.get();
        }
        return x;
    }

    @Override
    public String getName() {
        return "rtp";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("playername", GameProfileArgument.m_94584_()).executes(this::executeOtherPlayerRTP))).executes(this::checkPreConditionAndExecute);
    }
}

