/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.journeymap;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IGraveData;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.coremod.compatibility.journeymap.Journeymap;
import com.minecolonies.coremod.compatibility.journeymap.JourneymapOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.model.MapImage;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyDeathpoints {
    private static final Map<ResourceKey<Level>, Map<Integer, Map<BlockPos, Waypoint>>> overlays = new HashMap<ResourceKey<Level>, Map<Integer, Map<BlockPos, Waypoint>>>();
    private static final Lazy<MapImage> deathIcon = Lazy.of(ColonyDeathpoints::loadIcon);

    private ColonyDeathpoints() {
    }

    public static void clear() {
        overlays.clear();
    }

    public static void unload(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension) {
        for (Map waypoints : overlays.getOrDefault(dimension, Collections.emptyMap()).values()) {
            for (Map.Entry waypointEntry : waypoints.entrySet()) {
                if (waypointEntry.getValue() == null) continue;
                jmap.getApi().remove((Displayable)waypointEntry.getValue());
                waypointEntry.setValue(null);
            }
        }
    }

    public static void updateGraves(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull Set<BlockPos> graves) {
        Map waypoints = overlays.computeIfAbsent(colony.getDimension(), k -> new HashMap()).computeIfAbsent(colony.getID(), k -> new HashMap());
        boolean permitted = colony.getPermissions().hasPermission((Player)Minecraft.m_91087_().f_91074_, Action.MAP_DEATHS) && JourneymapOptions.getDeathpoints(jmap.getOptions());
        Iterator iterator = waypoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry waypointEntry = iterator.next();
            if (permitted && graves.contains(waypointEntry.getKey())) continue;
            if (waypointEntry.getValue() != null) {
                jmap.getApi().remove((Displayable)waypointEntry.getValue());
            }
            iterator.remove();
        }
        if (permitted) {
            for (BlockPos grave : graves) {
                waypoints.computeIfAbsent(grave, k -> ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, k));
            }
        }
    }

    public static void updateChunk(@NotNull Journeymap jmap, @NotNull ResourceKey<Level> dimension, @NotNull ChunkAccess chunk) {
        IColonyManager colonyManager = MinecoloniesAPIProxy.getInstance().getColonyManager();
        for (Map.Entry colonyEntry : overlays.getOrDefault(dimension, Collections.emptyMap()).entrySet()) {
            IColonyView colony = colonyManager.getColonyView((Integer)colonyEntry.getKey(), dimension);
            if (colony == null) {
                for (Waypoint waypoint : ((Map)colonyEntry.getValue()).values()) {
                    if (waypoint == null) continue;
                    jmap.getApi().remove((Displayable)waypoint);
                }
                ((Map)colonyEntry.getValue()).clear();
                continue;
            }
            for (Map.Entry entry : ((Map)colonyEntry.getValue()).entrySet()) {
                if (entry.getValue() != null || !chunk.m_7697_().equals((Object)new ChunkPos((BlockPos)entry.getKey()))) continue;
                entry.setValue(ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, chunk, (BlockPos)entry.getKey()));
            }
        }
    }

    @Nullable
    private static Waypoint tryCreatingWaypoint(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkAccess chunk = colony.getWorld().m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        return chunk == null ? null : ColonyDeathpoints.tryCreatingWaypoint(jmap, colony, chunk, pos);
    }

    @Nullable
    private static Waypoint tryCreatingWaypoint(@NotNull Journeymap jmap, @NotNull IColonyView colony, @NotNull ChunkAccess chunk, @NotNull BlockPos pos) {
        IGraveData grave;
        if (!jmap.getApi().playerAccepts("minecolonies", DisplayType.Waypoint)) {
            return null;
        }
        BlockEntity blockEntity = chunk.m_7702_(pos);
        if (blockEntity instanceof AbstractTileEntityGrave && (grave = ((AbstractTileEntityGrave)blockEntity).getGraveData()) != null) {
            MutableComponent text = grave.getCitizenJobName() == null ? Component.m_237110_((String)"com.minecolonies.coremod.journeymap.deathpoint_name", (Object[])new Object[]{grave.getCitizenName()}) : Component.m_237110_((String)"com.minecolonies.coremod.journeymap.deathpoint_namejob", (Object[])new Object[]{grave.getCitizenName(), grave.getCitizenJobName()});
            Waypoint waypoint = new Waypoint("minecolonies", text.getString(), colony.getDimension(), pos);
            ((Waypoint)waypoint.setEditable(true).setPersistent(false).setIcon((MapImage)deathIcon.get())).setColor(0x888888);
            jmap.show((Displayable)waypoint);
            return waypoint;
        }
        return null;
    }

    @NotNull
    private static MapImage loadIcon() {
        return new MapImage(new ResourceLocation("minecolonies", "textures/icons/grave_icon.png"), 16, 16);
    }
}

