/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.basic;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.RequestTag;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.ai.statemachine.AIEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIBlockingEventType;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryFunctions;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.interactionhandling.PosBasedInteraction;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJob;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.StationRequestResolver;
import com.minecolonies.coremod.entity.ai.basic.AbstractAISkeleton;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAIBasic<J extends AbstractJob<?, J>, B extends AbstractBuilding>
extends AbstractAISkeleton<J> {
    protected static final int STANDARD_DELAY = 5;
    protected static final int REQUEST_DELAY = 60;
    private static final int PICKUP_ATTEMPTS = 10;
    @Nullable
    protected BlockPos currentWorkingLocation = null;
    private int delay = 0;
    private boolean hasDelayed = false;
    private IWalkToProxy proxy;
    private int exceptionTimer = 1;
    private int slotAt = 0;
    private boolean hasDumpedItems = false;
    protected static final int WALK_DELAY = 20;
    protected Tuple<Predicate<ItemStack>, Integer> needsCurrently = null;
    protected BlockPos walkTo = null;
    private final List<ItemStorage> alreadyKept = new ArrayList<ItemStorage>();
    private int pickUpCounter = 0;
    public final B building;

    protected AbstractEntityAIBasic(@NotNull J job) {
        super(job);
        if (!this.getExpectedBuildingClass().isInstance(this.worker.getCitizenData().getWorkBuilding())) {
            this.building = null;
            this.worker.getCitizenData().setJob(null);
            Log.getLogger().error("Citizen: " + this.worker.getCitizenData().getId() + " got the wrong job for this building. Abort", (Throwable)new Exception());
            return;
        }
        this.building = (AbstractBuilding)this.worker.getCitizenData().getWorkBuilding();
        super.registerTargets(new AIEventTarget<Object>(AIBlockingEventType.AI_BLOCKING, this::initSafetyChecks, 1), new AITarget((IAIState)AIWorkerState.INIT, this::getState, 1), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.AI_BLOCKING, () -> true, this::updateVisualState, 20), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.AI_BLOCKING, this::waitingForSomething, this::getState, 1), new AIEventTarget<AIWorkerState>(AIBlockingEventType.STATE_BLOCKING, this::inventoryNeedsDump, AIWorkerState.INVENTORY_FULL, 100), new AITarget((IAIState)AIWorkerState.INVENTORY_FULL, this::dumpInventory, 10), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, () -> this.getState() != AIWorkerState.INVENTORY_FULL && ((AbstractBuilding)this.building).hasOpenSyncRequest(this.worker.getCitizenData()) || ((AbstractBuilding)this.building).hasCitizenCompletedRequestsToPickup(this.worker.getCitizenData()), AIWorkerState.NEEDS_ITEM, 20), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, () -> ((AbstractBuilding)this.building).hasCitizenCompletedRequests(this.worker.getCitizenData()) && this.cleanAsync(), AIWorkerState.NEEDS_ITEM, 200), new AITarget((IAIState)AIWorkerState.NEEDS_ITEM, this::waitForRequests, 40), new AITarget((IAIState)AIWorkerState.GATHERING_REQUIRED_MATERIALS, this::getNeededItem, 20), new AIEventTarget<Supplier<Object>>(AIBlockingEventType.STATE_BLOCKING, this::shouldRestart, this::restart, 20), new AITarget(AIWorkerState.PAUSED, () -> !this.isPaused(), () -> AIWorkerState.IDLE, 20), new AITarget((IAIState)AIWorkerState.PAUSED, this::bePaused, 10), new AITarget((IAIState)AIWorkerState.WALK_TO, this::walkToState, 10), new AIEventTarget<AIWorkerState>(AIBlockingEventType.AI_BLOCKING, this::isStartingPaused, AIWorkerState.INVENTORY_FULL, 20));
    }

    public void setWalkTo(BlockPos walkto) {
        this.walkTo = walkto;
    }

    private IAIState walkToState() {
        if (this.walkToBlock(this.walkTo, 4)) {
            return this.getState();
        }
        return AIWorkerState.IDLE;
    }

    private IAIState getNeededItem() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.gathering")});
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        if (this.needsCurrently == null) {
            return this.getStateAfterPickUp();
        }
        if (this.walkTo == null) {
            BlockPos pos = ((AbstractBuilding)this.building).getTileEntity().getPositionOfChestWithItemStack(this.needsCurrently.getA());
            if (pos == null) {
                return this.getStateAfterPickUp();
            }
            this.walkTo = pos;
        }
        if (this.walkToBlock(this.walkTo) && this.pickUpCounter++ < 10) {
            return this.getState();
        }
        this.pickUpCounter = 0;
        if (!this.tryTransferFromPosToWorkerIfNeeded(this.walkTo, this.needsCurrently)) {
            this.walkTo = null;
            return this.getState();
        }
        this.walkTo = null;
        return this.getStateAfterPickUp();
    }

    public IAIState getStateAfterPickUp() {
        return AIWorkerState.START_WORKING;
    }

    public abstract Class<B> getExpectedBuildingClass();

    @NotNull
    private B getOwnBuilding(@NotNull Class<B> type) {
        if (type.isInstance(this.worker.getCitizenColonyHandler().getWorkBuilding())) {
            return (B)((AbstractBuilding)this.worker.getCitizenColonyHandler().getWorkBuilding());
        }
        throw new IllegalStateException("Citizen " + this.worker.getCitizenData().getName() + " has lost its building unexpectedly, type does not match");
    }

    @Override
    protected void onException(RuntimeException e) {
        this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.worker.ai.exception"), ChatPriority.BLOCKING));
        try {
            int timeout = 100 * this.exceptionTimer;
            this.setDelay(FMLEnvironment.production ? timeout : 100);
            this.exceptionTimer *= 2;
            if (this.worker != null) {
                String name = this.worker.m_7755_().getString();
                BlockPos workerPosition = this.worker.m_20183_();
                IJob<?> colonyJob = this.worker.getCitizenJobHandler().getColonyJob();
                String jobName = colonyJob == null ? "null" : colonyJob.getJobRegistryEntry().getTranslationKey();
                Log.getLogger().error("Pausing Entity " + name + " (" + jobName + ") at " + workerPosition + " for " + timeout + " Seconds because of error:");
            } else {
                Log.getLogger().error("Pausing Entity that is null for " + timeout + " Seconds because of error:");
            }
            e.printStackTrace();
        }
        catch (RuntimeException exp) {
            Log.getLogger().error("Welp reporting crashed:");
            exp.printStackTrace();
            Log.getLogger().error("Caused by ai exception:");
            e.printStackTrace();
        }
    }

    public final void setDelay(int timeout) {
        this.delay = timeout;
    }

    protected boolean inventoryNeedsDump() {
        return this.getState() != AIWorkerState.INVENTORY_FULL && this.canBeInterrupted() && (this.worker.getCitizenInventoryHandler().isInventoryFull() || ((AbstractJob)this.job).getActionsDone() >= this.getActionsDoneUntilDumping() || this.wantInventoryDumped()) && !(this.job instanceof JobDeliveryman);
    }

    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    protected boolean wantInventoryDumped() {
        return false;
    }

    @Nullable
    private IAIState initSafetyChecks() {
        if (null == this.job || this.worker.getCitizenData() == null || this.building == null) {
            return AIWorkerState.INIT;
        }
        if (this.worker.getCitizenData().getJob() != this.job || this.building != this.worker.getCitizenData().getWorkBuilding()) {
            this.worker.getCitizenData().setJob(null);
            return AIWorkerState.INIT;
        }
        if (this.getState() == AIWorkerState.INIT) {
            return AIWorkerState.IDLE;
        }
        return null;
    }

    private IAIState updateVisualState() {
        ((AbstractJob)this.job).setNameTag(this.getState().toString());
        this.updateRenderMetaData();
        return null;
    }

    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.IDLE ? "" : "working");
    }

    private boolean waitingForSomething() {
        if (this.delay > 0) {
            if (this.delay % 5 == 0 && this.currentWorkingLocation != null && EntityUtils.isLivingAtSite((LivingEntity)this.worker, this.currentWorkingLocation.m_123341_(), this.currentWorkingLocation.m_123342_(), this.currentWorkingLocation.m_123343_(), 4)) {
                this.worker.getCitizenItemHandler().hitBlockWithToolInHand(this.currentWorkingLocation);
            }
            this.delay -= this.getTickRate();
            if (this.delay <= 0) {
                this.clearWorkTarget();
            }
            return true;
        }
        return false;
    }

    private void clearWorkTarget() {
        this.currentWorkingLocation = null;
        this.delay = 0;
    }

    @NotNull
    protected IAIState waitForRequests() {
        this.delay = 10;
        this.updateWorkerStatusFromRequests();
        return this.lookForRequests();
    }

    private void updateWorkerStatusFromRequests() {
        if (!((AbstractBuilding)this.building).hasWorkerOpenRequests(this.worker.getCitizenData().getId()) && !((AbstractBuilding)this.building).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[0]);
            return;
        }
        Collection<IRequest<?>> requests = ((AbstractBuilding)this.building).getCompletedRequests(this.worker.getCitizenData());
        if (requests.isEmpty()) {
            requests = ((AbstractBuilding)this.building).getOpenRequests(this.worker.getCitizenData().getId());
        }
        if (!requests.isEmpty()) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.waiting"), requests.iterator().next().getShortDisplayString()});
        }
    }

    @NotNull
    private IAIState lookForRequests() {
        if (!((AbstractBuilding)this.building).hasOpenSyncRequest(this.worker.getCitizenData()) && !((AbstractBuilding)this.building).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            return this.afterRequestPickUp();
        }
        if (((AbstractBuilding)this.building).hasCitizenCompletedRequests(this.worker.getCitizenData())) {
            Collection<IRequest<?>> completedRequests = ((AbstractBuilding)this.building).getCompletedRequests(this.worker.getCitizenData());
            ArrayList deliverableRequests = new ArrayList();
            for (IRequest<?> req : completedRequests) {
                if (!req.canBeDelivered()) {
                    ((AbstractBuilding)this.building).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)req.getId());
                    continue;
                }
                deliverableRequests.add(req);
            }
            if (!deliverableRequests.isEmpty()) {
                ILocation pickupLocation;
                IRequest firstDeliverableRequest = (IRequest)deliverableRequests.get(0);
                IRequestResolver<?> resolver = null;
                try {
                    resolver = ((AbstractSchematicProvider)this.building).getColony().getRequestManager().getResolverForRequest((IToken<?>)firstDeliverableRequest.getId());
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Resolver died for finished request. Oopsy. " + this.worker.getCitizenData().getName() + " witnessed it.");
                }
                ILocation iLocation = pickupLocation = resolver instanceof StationRequestResolver ? resolver.getLocation() : ((AbstractBuilding)this.building).getLocation();
                if (this.walkToBlock(pickupLocation.getInDimensionLocation()) || !WorldUtil.isBlockLoaded((LevelAccessor)this.world, pickupLocation.getInDimensionLocation())) {
                    return AIWorkerState.NEEDS_ITEM;
                }
                BlockEntity blockEntity = this.world.m_7702_(pickupLocation.getInDimensionLocation());
                if (blockEntity == null) {
                    return AIWorkerState.NEEDS_ITEM;
                }
                boolean async = false;
                if (this.worker.getCitizenData().isRequestAsync((IToken<?>)firstDeliverableRequest.getId())) {
                    async = true;
                    ((AbstractJob)this.job).getAsyncRequests().remove(firstDeliverableRequest.getId());
                }
                ((AbstractBuilding)this.building).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)firstDeliverableRequest.getId());
                ArrayList validHandlers = Lists.newArrayList();
                validHandlers.add(this.worker.getItemHandlerCitizen());
                validHandlers.addAll(InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)blockEntity));
                if (InventoryUtils.areAllItemsInItemHandlerList(firstDeliverableRequest.getDeliveries(), validHandlers)) {
                    List<ItemStack> niceToHave = this.itemsNiceToHave();
                    List<ItemStack> contained = InventoryUtils.getContainedFromItemHandler(firstDeliverableRequest.getDeliveries(), this.worker.getItemHandlerCitizen());
                    InventoryUtils.moveItemStacksWithPossibleSwap(this.worker.getItemHandlerCitizen(), InventoryUtils.getItemHandlersFromProvider((ICapabilityProvider)blockEntity), firstDeliverableRequest.getDeliveries(), itemStack -> contained.stream().anyMatch(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack)) || niceToHave.stream().anyMatch(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack)));
                    return AIWorkerState.NEEDS_ITEM;
                }
                if (async) {
                    this.worker.getCitizenData().createRequestAsync(firstDeliverableRequest.getRequest());
                } else {
                    this.worker.getCitizenData().createRequest(firstDeliverableRequest.getRequest());
                }
            }
        } else {
            this.walkToBuilding();
        }
        return AIWorkerState.NEEDS_ITEM;
    }

    protected int getPrimarySkillLevel() {
        return this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getPrimarySkill());
    }

    protected int getSecondarySkillLevel() {
        return this.worker.getCitizenData().getCitizenSkillHandler().getLevel(this.getModuleForJob().getSecondarySkill());
    }

    protected WorkerBuildingModule getModuleForJob() {
        return ((AbstractBuilding)this.building).getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == ((AbstractJob)this.job).getJobRegistryEntry());
    }

    protected int getEffectiveSkillLevel(int rawSkillLevel) {
        return (int)((double)((rawSkillLevel + 1) * 2) - Math.pow((double)(rawSkillLevel + 1) / 10.0, 2.0));
    }

    private boolean cleanAsync() {
        Collection<IRequest<?>> completedRequests = ((AbstractBuilding)this.building).getCompletedRequests(this.worker.getCitizenData());
        for (IRequest<?> request : completedRequests) {
            if (!this.worker.getCitizenData().isRequestAsync((IToken<?>)request.getId())) continue;
            ((AbstractBuilding)this.building).markRequestAsAccepted(this.worker.getCitizenData(), (IToken<?>)request.getId());
        }
        return false;
    }

    public boolean isAfterDumpPickupAllowed() {
        return true;
    }

    public IAIState afterRequestPickUp() {
        return AIWorkerState.IDLE;
    }

    public int getTotalRequiredAmount(ItemStack deliveredItemStack) {
        return deliveredItemStack.m_41613_();
    }

    protected final boolean walkToBuilding() {
        @Nullable B ownBuilding = this.building;
        return ownBuilding == null || this.walkToBlock(ownBuilding.getPosition());
    }

    public boolean checkAndTransferFromHut(@Nullable ItemStack is) {
        for (BlockPos pos : ((AbstractBuildingContainer)this.building).getContainers()) {
            BlockEntity entity = this.world.m_7702_(pos);
            if (!(entity instanceof TileEntityRack) || !((TileEntityRack)entity).hasItemStack(is, 1, false)) continue;
            entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(handler, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(is, stack), (IItemHandler)this.getInventory()));
            return true;
        }
        return false;
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand) {
        return this.walkToBlock(stand, 4);
    }

    protected final boolean walkToBlock(@NotNull BlockPos stand, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this.worker);
        }
        if (!this.proxy.walkToBlock(stand, range)) {
            this.workOnBlock(null, 10);
            return true;
        }
        return false;
    }

    private void workOnBlock(@Nullable BlockPos target, int timeout) {
        this.currentWorkingLocation = target;
    }

    public boolean retrieveToolInTileEntity(BlockEntity entity, IToolType toolType, int minLevel, int maxLevel) {
        if (ToolType.NONE.equals(toolType)) {
            return false;
        }
        return InventoryFunctions.matchFirstInProviderWithAction((ICapabilityProvider)entity, stack -> ItemStackUtils.hasToolLevel(stack, toolType, minLevel, maxLevel), this::takeItemStackFromProvider);
    }

    public void takeItemStackFromProvider(@NotNull ICapabilityProvider provider, int slotIndex) {
        InventoryUtils.transferItemStackIntoNextBestSlotFromProvider(provider, slotIndex, (IItemHandler)this.worker.getInventoryCitizen());
    }

    public boolean checkForToolOrWeapon(@NotNull IToolType toolType) {
        boolean needTool = this.checkForToolOrWeapon(toolType, 0);
        this.worker.getCitizenData().setIdleAtJob(needTool);
        return needTool;
    }

    protected boolean checkForToolOrWeapon(@NotNull IToolType toolType, int minimalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (this.checkForNeededTool(toolType, minimalLevel)) {
            if (openToolRequests.isEmpty() && completedToolRequests.isEmpty()) {
                Tool request = new Tool(toolType, minimalLevel, this.building.getMaxToolLevel() < minimalLevel ? minimalLevel : this.building.getMaxToolLevel());
                this.worker.getCitizenData().createRequest(request);
            }
            this.delay = 0;
            return true;
        }
        return false;
    }

    protected void checkForToolorWeaponASync(@NotNull IToolType toolType, int minimalLevel, int maximalLevel) {
        ImmutableList openToolRequests = ((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        ImmutableList completedToolRequests = ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeToken.of(Tool.class), r -> ((Tool)r.getRequest()).getToolClass().equals(toolType) && ((Tool)r.getRequest()).getMinLevel() >= minimalLevel);
        if (openToolRequests.isEmpty() && completedToolRequests.isEmpty() && !this.hasOpenToolRequest(toolType)) {
            Tool request = new Tool(toolType, minimalLevel, maximalLevel);
            this.worker.getCitizenData().createRequestAsync(request);
        }
    }

    protected void cancelAsynchRequestForArmor(IToolType armorType) {
        ImmutableList openRequests = ((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TOOL, iRequest -> ((Tool)iRequest.getRequest()).getToolClass() == armorType);
        for (IRequest token : openRequests) {
            this.worker.getCitizenColonyHandler().getColony().getRequestManager().updateRequestState((IToken<?>)token.getId(), RequestState.CANCELLED);
        }
    }

    private boolean hasOpenToolRequest(IToolType key) {
        return ((AbstractBuilding)this.building).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData().getId(), iRequest -> iRequest.getRequest() instanceof Tool && ((Tool)iRequest.getRequest()).getToolClass() == key);
    }

    private boolean checkForNeededTool(@NotNull IToolType toolType, int minimalLevel) {
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        InventoryCitizen inventory = this.worker.getInventoryCitizen();
        if (InventoryUtils.isToolInItemHandler((IItemHandler)inventory, toolType, minimalLevel, maxToolLevel)) {
            return false;
        }
        this.delay += 10;
        return this.walkToBuilding() || !this.retrieveToolInHut(toolType, minimalLevel);
    }

    public boolean retrieveToolInHut(IToolType toolType, int minimalLevel) {
        if (this.building != null) {
            Predicate<ItemStack> toolPredicate = stack -> ItemStackUtils.hasToolLevel(stack, toolType, minimalLevel, this.building.getMaxToolLevel());
            for (BlockPos pos : ((AbstractBuildingContainer)this.building).getContainers()) {
                BlockEntity entity = this.world.m_7702_(pos);
                if (entity instanceof TileEntityRack) {
                    if (ToolType.NONE.equals(toolType)) {
                        return false;
                    }
                    if (!((TileEntityRack)entity).hasItemStack(toolPredicate) || !InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler((IItemHandler)entity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null), toolPredicate, (IItemHandler)this.worker.getInventoryCitizen())) continue;
                    return true;
                }
                if (!(entity instanceof ChestBlockEntity) || !this.retrieveToolInTileEntity(((AbstractBuilding)this.building).getTileEntity(), toolType, minimalLevel, this.building.getMaxToolLevel())) continue;
                return true;
            }
        }
        return false;
    }

    protected IBuilding getBuildingToDump() {
        return this.building;
    }

    @NotNull
    private IAIState dumpInventory() {
        IBuilding building = this.getBuildingToDump();
        if (building == null) {
            return this.afterDump();
        }
        if (!this.worker.isWorkerAtSiteWithMove(building.getPosition(), 4)) {
            this.setDelay(20);
            return AIWorkerState.INVENTORY_FULL;
        }
        if (InventoryUtils.isProviderFull(building)) {
            ICitizenData citizenData = this.worker.getCitizenData();
            if (citizenData != null) {
                citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"entity.worker.inventoryfullchestfull"), ChatPriority.IMPORTANT));
            }
            if (building.getPickUpPriority() > 0) {
                building.createPickupRequest(AbstractDeliverymanRequestable.getMaxBuildingPriority(true));
                this.hasDumpedItems = false;
            }
            this.alreadyKept.clear();
            this.slotAt = 0;
            this.clearActionsDone();
            return this.afterDump();
        }
        if (this.dumpOneMoreSlot()) {
            return AIWorkerState.INVENTORY_FULL;
        }
        this.alreadyKept.clear();
        this.slotAt = 0;
        this.clearActionsDone();
        if (this.isAfterDumpPickupAllowed() && building.getPickUpPriority() > 0 && this.hasDumpedItems) {
            building.createPickupRequest(AbstractDeliverymanRequestable.scaledPriority(building.getPickUpPriority()));
            this.hasDumpedItems = false;
        }
        return this.afterDump();
    }

    public IAIState afterDump() {
        if (this.isPaused()) {
            ((AbstractBuilding)this.building).onCleanUp(this.worker.getCitizenData());
            return AIWorkerState.PAUSED;
        }
        return AIWorkerState.IDLE;
    }

    private boolean dumpOneMoreSlot() {
        long openSlots;
        if (this.walkToBlock(this.getBuildingToDump().getPosition())) {
            return true;
        }
        @Nullable B buildingWorker = this.building;
        ItemStack stackToDump = this.worker.getInventoryCitizen().getStackInSlot(this.slotAt);
        int totalSize = this.worker.getInventoryCitizen().getSlots();
        while (stackToDump.m_41619_()) {
            if (this.slotAt >= totalSize) {
                return false;
            }
            ++this.slotAt;
            stackToDump = this.worker.getInventoryCitizen().getStackInSlot(this.slotAt);
        }
        boolean dumpAnyway = false;
        if ((long)this.slotAt + 10L >= (long)totalSize && (openSlots = InventoryUtils.openSlotCount((IItemHandler)this.worker.getInventoryCitizen())) < 10L) {
            if (stackToDump.m_41613_() < 16) {
                dumpAnyway = this.worker.m_217043_().m_188499_();
            } else {
                boolean bl = dumpAnyway = this.worker.m_217043_().m_188503_(stackToDump.m_41613_()) < 8;
            }
        }
        if (buildingWorker != null && !ItemStackUtils.isEmpty(stackToDump).booleanValue()) {
            int amount;
            int n = amount = dumpAnyway ? stackToDump.m_41613_() : buildingWorker.buildingRequiresCertainAmountOfItem(stackToDump, this.alreadyKept, true, ((AbstractJob)this.job).getJobRegistryEntry());
            if (amount > 0) {
                ItemStack activeStack = this.getInventory().extractItem(this.slotAt, amount, false);
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(activeStack, (IItemHandler)this.getBuildingToDump().getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseGet(null));
                this.hasDumpedItems = true;
            }
        }
        ++this.slotAt;
        return this.slotAt < totalSize;
    }

    @NotNull
    protected List<ItemStack> itemsNiceToHave() {
        return new ArrayList<ItemStack>();
    }

    private void clearActionsDone() {
        ((AbstractJob)this.job).clearActionsDone();
    }

    @NotNull
    protected InventoryCitizen getInventory() {
        return this.worker.getInventoryCitizen();
    }

    public final boolean holdEfficientTool(@NotNull BlockState target, BlockPos pos) {
        int bestSlot = this.getMostEfficientTool(target, pos);
        if (bestSlot >= 0) {
            this.worker.getCitizenData().setIdleAtJob(false);
            this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, bestSlot);
            return true;
        }
        this.requestTool(target, pos);
        return false;
    }

    private void requestTool(@NotNull BlockState target, BlockPos pos) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target, target.m_60800_((BlockGetter)this.world, pos), this.building);
        int required = WorkerUtil.getCorrectHarvestLevelForBlock(target);
        if (this.building.getMaxToolLevel() < required && this.worker.getCitizenData() != null) {
            this.worker.getCitizenData().triggerInteraction(new PosBasedInteraction((Component)Component.m_237110_((String)"com.minecolonies.coremod.request.toolow", (Object[])new Object[]{new ItemStack((ItemLike)target.m_60734_()).m_41786_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}), ChatPriority.IMPORTANT, (Component)Component.m_237115_((String)"com.minecolonies.coremod.request.toolow"), pos));
        }
        this.updateToolFlag(toolType, required);
    }

    private void updateToolFlag(@NotNull IToolType toolType, int required) {
        if (ToolType.PICKAXE.equals(toolType)) {
            this.checkForToolOrWeapon(toolType, required);
        } else {
            this.checkForToolOrWeapon(toolType);
        }
    }

    protected int getMostEfficientTool(@NotNull BlockState target, BlockPos pos) {
        IToolType toolType = WorkerUtil.getBestToolForBlock(target, target.m_60800_((BlockGetter)this.world, pos), this.building);
        int required = WorkerUtil.getCorrectHarvestLevelForBlock(target);
        if (toolType == ToolType.NONE) {
            int heldSlot = this.worker.getInventoryCitizen().getHeldItemSlot(InteractionHand.MAIN_HAND);
            return heldSlot >= 0 ? heldSlot : 0;
        }
        int bestSlot = -1;
        int bestLevel = Integer.MAX_VALUE;
        @NotNull InventoryCitizen inventory = this.worker.getInventoryCitizen();
        int maxToolLevel = this.worker.getCitizenColonyHandler().getWorkBuilding().getMaxToolLevel();
        for (int i = 0; i < this.worker.getInventoryCitizen().getSlots(); ++i) {
            ItemStack item = inventory.getStackInSlot(i);
            int level = ItemStackUtils.getMiningLevel(item, toolType);
            if (level <= -1 || level < required || level >= bestLevel || !ItemStackUtils.verifyToolLevel(item, level, required, maxToolLevel)) continue;
            bestSlot = i;
            bestLevel = level;
        }
        return bestSlot;
    }

    protected final boolean hasNotDelayed(int time) {
        if (!this.hasDelayed) {
            this.setDelay(time);
            this.hasDelayed = true;
            return true;
        }
        this.hasDelayed = false;
        return false;
    }

    public final void incrementActionsDoneAndDecSaturation() {
        this.worker.decreaseSaturationForAction();
        this.incrementActionsDone();
    }

    protected final void incrementActionsDone() {
        ((AbstractJob)this.job).incrementActionsDone();
    }

    protected final void resetActionsDone() {
        ((AbstractJob)this.job).clearActionsDone();
    }

    protected final void incrementActionsDone(int numberOfActions) {
        ((AbstractJob)this.job).incrementActionsDone(numberOfActions);
    }

    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return targetPosition;
    }

    public BlockPos getWorkingPosition(int distance, BlockPos targetPos, int offset) {
        Direction[] directions;
        if (offset > 25) {
            return targetPos;
        }
        for (Direction direction : directions = new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}) {
            @NotNull BlockPos positionInDirection = this.getPositionInDirection(direction, distance + offset, targetPos);
            if (!EntityUtils.checkForFreeSpace(this.world, positionInDirection) || !this.world.m_8055_(positionInDirection.m_7494_()).m_204336_(BlockTags.f_13104_)) continue;
            return positionInDirection;
        }
        return this.getWorkingPosition(distance, targetPos, offset + 1);
    }

    @NotNull
    private BlockPos getPositionInDirection(Direction facing, int distance, BlockPos targetPos) {
        return BlockPosUtil.getFloor(targetPos.m_5484_(facing, distance), this.world);
    }

    public boolean checkIfRequestForItemExistOrCreate(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreate(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreate);
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack) {
        return this.checkIfRequestForItemExistOrCreate(stack, stack.m_41613_(), stack.m_41613_());
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull ItemStack stack, int count, int minCount) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack))) {
            return true;
        }
        if (((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty() && ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack, count, minCount);
            this.worker.getCitizenData().createRequest(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForItemExistOrCreateAsync(ItemStack ... stacks) {
        return this.checkIfRequestForItemExistOrCreateAsync(Lists.newArrayList((Object[])stacks));
    }

    public boolean checkIfRequestForItemExistOrCreateAsync(@NotNull Collection<ItemStack> stacks) {
        return stacks.stream().allMatch(this::checkIfRequestForItemExistOrCreateAsync);
    }

    public boolean checkIfRequestForItemExistOrCreateAsync(@NotNull ItemStack stack) {
        return this.checkIfRequestForItemExistOrCreateAsync(stack, stack.m_41613_(), stack.m_41613_());
    }

    public boolean checkIfRequestForItemExistOrCreateAsync(@NotNull ItemStack stack, int count, int minCount) {
        return this.checkIfRequestForItemExistOrCreateAsync(stack, count, minCount, true);
    }

    public boolean checkIfRequestForItemExistOrCreateAsync(@NotNull ItemStack stack, int count, int minCount, boolean matchNBT) {
        if (stack.m_41619_()) {
            return true;
        }
        int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), s -> ItemStackUtils.compareItemStacksIgnoreStackSize(s, stack));
        if (invCount >= count) {
            return true;
        }
        int updatedCount = count - invCount;
        int updatedMinCount = Math.min(updatedCount, minCount);
        if (InventoryUtils.hasBuildingEnoughElseCount(this.building, new ItemStorage(stack, true, matchNBT), updatedMinCount) >= updatedMinCount && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, matchNBT), updatedCount, (IItemHandler)this.worker.getInventoryCitizen())) {
            return true;
        }
        if (((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty() && ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).matches(stack)).isEmpty()) {
            Stack stackRequest = new Stack(stack, updatedCount, updatedMinCount, matchNBT);
            this.worker.getCitizenData().createRequestAsync(stackRequest);
        }
        return false;
    }

    public boolean checkIfRequestForItemExistOrCreate(@NotNull IDeliverable deliverable) {
        int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), deliverable::matches);
        if (invCount >= deliverable.getCount()) {
            return true;
        }
        int updatedCount = deliverable.getCount() - invCount;
        int updatedMinCount = Math.min(updatedCount, deliverable.getMinimumCount());
        if (InventoryUtils.hasBuildingEnoughElseCount(this.building, deliverable::matches, updatedMinCount) >= updatedMinCount) {
            if (InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, deliverable::matches, updatedCount, (IItemHandler)this.worker.getInventoryCitizen())) {
                return true;
            }
        }
        if (((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).getClass().equals(deliverable.getClass())).isEmpty() && ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.DELIVERABLE, r -> ((IDeliverable)r.getRequest()).getClass().equals(deliverable.getClass())).isEmpty()) {
            this.worker.getCitizenData().createRequestAsync(deliverable);
        }
        return false;
    }

    public boolean checkIfRequestForTagExistOrCreateAsync(@NotNull TagKey<Item> tag, int count) {
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack.m_204117_(tag) && stack.m_41613_() >= count)) {
            return true;
        }
        if (InventoryUtils.hasBuildingEnoughElseCount(this.building, itemStack -> itemStack.m_204117_(tag), count) >= count && InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandler(this.building, itemStack -> itemStack.m_204117_(tag), count, (IItemHandler)this.worker.getInventoryCitizen())) {
            return true;
        }
        if (((AbstractBuilding)this.building).getOpenRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TAG_REQUEST, r -> ((RequestTag)r.getRequest()).getTag().equals((Object)tag)).isEmpty() && ((AbstractBuilding)this.building).getCompletedRequestsOfTypeFiltered(this.worker.getCitizenData(), TypeConstants.TAG_REQUEST, r -> ((RequestTag)r.getRequest()).getTag().equals((Object)tag)).isEmpty()) {
            RequestTag tagRequest = new RequestTag(tag, count);
            this.worker.getCitizenData().createRequestAsync(tagRequest);
        }
        return false;
    }

    private boolean tryTransferFromPosToWorkerIfNeeded(BlockPos pos, @NotNull Tuple<Predicate<ItemStack>, Integer> predicate) {
        BlockEntity entity = this.world.m_7702_(pos);
        if (entity == null) {
            return true;
        }
        int existingAmount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate.getA());
        if (predicate.getB() <= existingAmount) {
            return true;
        }
        int amount = predicate.getB() - existingAmount;
        InventoryUtils.transferXOfFirstSlotInProviderWithIntoNextFreeSlotInItemHandlerWithResult((ICapabilityProvider)entity, predicate.getA(), amount, (IItemHandler)this.worker.getInventoryCitizen());
        existingAmount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate.getA());
        return existingAmount >= predicate.getB();
    }

    private boolean isPaused() {
        return this.worker.getCitizenData().isPaused();
    }

    private boolean isStartingPaused() {
        return this.isPaused() && this.getState() != AIWorkerState.PAUSED && this.getState() != AIWorkerState.INVENTORY_FULL;
    }

    private IAIState bePaused() {
        if (!this.worker.getNavigation().m_26571_()) {
            return null;
        }
        int percent = this.worker.m_217043_().m_188503_(100);
        if (percent < 8) {
            this.worker.getNavigation().tryMoveToBlockPos(((AbstractSchematicProvider)this.building).getPosition(), this.worker.m_217043_().m_188499_() ? 0.8999999999999999 : 1.32);
        } else if (percent < 35) {
            this.worker.getNavigation().moveToRandomPos(10.0, 0.6);
        }
        return null;
    }

    private boolean shouldRestart() {
        return this.worker.getCitizenData().shouldRestart() && this.isPaused();
    }

    private IAIState restart() {
        ((AbstractBuilding)this.building).onCleanUp(this.worker.getCitizenData());
        ((AbstractBuilding)this.building).onRestart(this.worker.getCitizenData());
        this.setDelay(20);
        this.worker.getCitizenData().restartDone();
        return AIWorkerState.INIT;
    }

    public int getExceptionTimer() {
        return this.exceptionTimer;
    }
}

