/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.combat.CombatAIStates;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.EntityListModule;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.ai.citizen.miner.MinerLevel;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.client.SleepingParticleMessage;
import com.minecolonies.coremod.util.NamedDamageSource;
import com.minecolonies.coremod.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIFight<J, B> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 80;
    public static final int PATROL_DEVIATION_RAID_POINT = 1600;
    private static final int MAX_FOLLOW_DERIVATION = 30;
    private static final int MAX_GUARD_DERIVATION = 10;
    protected static final int COMBAT_TIME = 600;
    protected LivingEntity target = null;
    private BlockPos currentPatrolPoint = null;
    protected final IGuardBuilding buildingGuards;
    private static final int PARTICLE_INTERVAL = 30;
    private static final int SHOULD_SLEEP_INTERVAL = 200;
    private static final int GUARD_TASK_INTERVAL = 100;
    private static final int GUARD_REGEN_INTERVAL = 40;
    private static final int ACTION_INCREASE_INTERVAL = 10;
    private int sleepTimer = 0;
    protected int wakeTimer = 0;
    protected int fighttimer = 0;
    protected WeakReference<EntityCitizen> sleepingGuard = new WeakReference<Object>(null);
    private Random randomGenerator = new Random();
    private int regularActionTimer = 0;
    private BlockPos lastGuardActionPos;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, CombatAIStates.NO_TARGET, 1), new AITarget(CombatAIStates.NO_TARGET, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleep, 1), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleepParticles, 30), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen, 40), new AITarget(CombatAIStates.ATTACKING, this::shouldFlee, () -> AIWorkerState.GUARD_REGEN, 40), new AITarget((IAIState)CombatAIStates.NO_TARGET, this::decide, 100), new AITarget((IAIState)AIWorkerState.GUARD_WAKE, this::wakeUpGuard, 20), new AITarget((IAIState)CombatAIStates.ATTACKING, this::inCombat, 8));
        this.buildingGuards = (IGuardBuilding)((Object)this.building);
        this.lastGuardActionPos = this.buildingGuards.getPosition();
    }

    private IAIState inCombat() {
        if (this.fighttimer <= 0) {
            this.onCombatEnter();
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        this.fighttimer = 600;
        return null;
    }

    private void onCombatEnter() {
        this.worker.setCanBeStuck(false);
        this.worker.getNavigation().getPathingOptions().setCanUseRails(false);
    }

    private void onCombatLeave() {
        this.worker.getNavigation().getPathingOptions().setCanUseRails(((EntityCitizen)this.worker).canPathOnRails());
        this.worker.setCanBeStuck(true);
    }

    private IAIState wakeUpGuard() {
        if (this.sleepingGuard.get() == null || !(((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) || !((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return CombatAIStates.NO_TARGET;
        }
        ++this.wakeTimer;
        if (this.wakeTimer == 1) {
            return this.getState();
        }
        if (BlockPosUtil.getDistanceSquared(((EntityCitizen)this.sleepingGuard.get()).m_20183_(), this.worker.m_20183_()) <= 4L || this.wakeTimer > 10) {
            this.worker.m_6674_(InteractionHand.OFF_HAND);
            ((EntityCitizen)this.sleepingGuard.get()).m_6469_(new NamedDamageSource("wakeywakey", (Entity)this.worker).m_19380_(), 1.0f);
            ((EntityCitizen)this.sleepingGuard.get()).m_6703_((LivingEntity)this.worker);
            return CombatAIStates.NO_TARGET;
        }
        this.worker.getNavigation().moveToLivingEntity((Entity)this.sleepingGuard.get(), 1.0);
        return this.getState();
    }

    private boolean shouldSleep() {
        if (this.worker.m_21188_() != null || this.target != null || this.fighttimer > 0) {
            return false;
        }
        double chance = 1.0 - this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SLEEP_LESS);
        if (this.worker.m_217043_().m_188503_((int)((double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.5) + 20) == 1 && this.worker.m_217043_().m_188500_() < chance) {
            this.sleepTimer = this.worker.m_217043_().m_188503_(500) + 2500;
            SittingEntity.sitDown(this.worker.m_20183_(), (Mob)this.worker, this.sleepTimer);
            return true;
        }
        return false;
    }

    private IAIState sleepParticles() {
        Network.getNetwork().sendToTrackingEntity(new SleepingParticleMessage(this.worker.m_20185_(), this.worker.m_20186_() + 2.0, this.worker.m_20189_()), (Entity)this.worker);
        if (this.worker.m_21223_() < this.worker.m_21233_()) {
            this.worker.m_21153_(this.worker.m_21223_() + 0.5f);
        }
        return null;
    }

    private IAIState sleep() {
        if (this.worker.m_21188_() != null || (this.sleepTimer -= this.getTickRate()) < 0) {
            this.stopSleeping();
            ((EntityCitizen)this.worker).getThreatTable().removeCurrentTarget();
            this.worker.m_6703_(null);
            return CombatAIStates.NO_TARGET;
        }
        this.worker.m_21563_().m_24950_(this.worker.m_20185_() + (double)this.worker.m_6350_().m_122429_(), this.worker.m_20186_() + (double)this.worker.m_6350_().m_122430_(), this.worker.m_20189_() + (double)this.worker.m_6350_().m_122431_(), 0.0f, 30.0f);
        return null;
    }

    private void stopSleeping() {
        if (this.getState() == AIWorkerState.GUARD_SLEEP) {
            this.worker.m_8127_();
            this.worker.m_6034_(this.worker.m_20185_(), this.worker.m_20186_() + 1.0, this.worker.m_20189_());
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        }
    }

    private boolean shouldFlee() {
        if (this.buildingGuards.shallRetrieveOnLowHealth() && (double)this.worker.m_21223_() < (double)((int)this.worker.m_21233_()) * 0.2) {
            return this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RETREAT) > 0.0;
        }
        return false;
    }

    private IAIState regen() {
        double effect;
        if (!this.worker.m_21023_(MobEffects.f_19596_) && (effect = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_SPEED)) > 0.0) {
            this.worker.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, (int)(0.0 + effect)));
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.GUARD_REGEN;
        }
        if ((double)this.worker.m_21223_() < (double)((int)this.worker.m_21233_()) * 0.75 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            if (!this.worker.m_21023_(MobEffects.f_19605_)) {
                this.worker.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200));
            }
            return AIWorkerState.GUARD_REGEN;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState guard() {
        this.guardMovement();
        return this.getState();
    }

    public void guardMovement() {
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
    }

    private IAIState follow() {
        if (BlockPosUtil.getDistance2D(this.worker.m_20183_(), this.buildingGuards.getPositionToFollow()) > 30L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.m_20193_(), this.buildingGuards.getPositionToFollow());
            return null;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 6);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPositionToFollow(), 15);
        }
        return null;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5 * ((AbstractBuildingGuards)this.building).getBuildingLevel();
    }

    private IAIState rally(ILocation location) {
        ICitizenData citizenData = this.worker.getCitizenData();
        if (!this.worker.isWorkerAtSiteWithMove(location.getInDimensionLocation().m_7918_(this.randomGenerator.nextInt(6) - 3, 0, this.randomGenerator.nextInt(6) - 3), 6) && citizenData != null && !this.worker.m_21023_(MobEffects.f_19596_)) {
            this.worker.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, Mth.m_14045_((int)(citizenData.getCitizenSkillHandler().getLevel(Skill.Adaptability) / 20), (int)2, (int)5), false, false));
        }
        return null;
    }

    @Override
    protected IAIState startWorkingAtOwnBuilding() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation()) || !this.canBeInterrupted() || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.patrol_mine") && this.buildingGuards.getMinePos() != null) {
            return AIWorkerState.PREPARING;
        }
        return super.startWorkingAtOwnBuilding();
    }

    public IAIState patrol() {
        if (this.buildingGuards.requiresManualTarget()) {
            if (this.currentPatrolPoint == null || this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.currentPatrolPoint = this.worker.m_217043_().m_188503_(5) <= 1 ? this.buildingGuards.getColony().getBuildingManager().getRandomBuilding(b -> true) : this.findRandomPositionToWalkTo(20);
                if (this.currentPatrolPoint != null) {
                    this.setNextPatrolTarget(this.currentPatrolPoint);
                }
            }
        } else {
            if (this.currentPatrolPoint == null) {
                this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(false);
            }
            if (this.currentPatrolPoint != null && this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 3)) {
                this.buildingGuards.arrivedAtPatrolPoint(this.worker);
            }
        }
        return null;
    }

    public IAIState patrolMine() {
        if (this.buildingGuards.getMinePos() == null) {
            return AIWorkerState.PREPARING;
        }
        if (this.currentPatrolPoint == null || this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2)) {
            IBuilding building = this.buildingGuards.getColony().getBuildingManager().getBuilding(this.buildingGuards.getMinePos());
            if (building != null) {
                if (building instanceof BuildingMiner) {
                    BuildingMiner buildingMiner = (BuildingMiner)building;
                    MinerLevel level = buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class).getCurrentLevel();
                    if (level == null) {
                        this.setNextPatrolTarget(buildingMiner.getPosition());
                    } else {
                        this.setNextPatrolTarget(level.getRandomCompletedNode(buildingMiner));
                    }
                } else {
                    this.buildingGuards.getFirstModuleOccurance(ISettingsModule.class).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                }
            } else {
                this.buildingGuards.getFirstModuleOccurance(ISettingsModule.class).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
            }
        }
        return null;
    }

    public void setNextPatrolTarget(BlockPos target) {
        this.currentPatrolPoint = target;
        if (this.getState() == CombatAIStates.NO_TARGET) {
            this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2);
        }
    }

    public boolean hasTool() {
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)this.getInventory(), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            return false;
        }
        return true;
    }

    public void startHelpCitizen(LivingEntity attacker) {
        if (this.canHelp()) {
            ((IThreatTableEntity)((Object)this.worker)).getThreatTable().addThreat(attacker, 20);
            this.registerTarget(new AIOneTimeEventTarget(CombatAIStates.ATTACKING));
        }
    }

    public boolean canHelp() {
        if ((this.getState() == CombatAIStates.NO_TARGET || this.getState() == AIWorkerState.GUARD_SLEEP) && this.canBeInterrupted()) {
            this.stopSleeping();
            return true;
        }
        return false;
    }

    protected IAIState decide() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (this.regularActionTimer++ > 10) {
            this.incrementActionsDone();
            this.regularActionTimer = 0;
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        if (this.fighttimer > 0) {
            this.fighttimer -= 100;
            if (this.fighttimer <= 0) {
                this.onCombatLeave();
            }
        } else {
            this.worker.m_5810_();
            this.lastGuardActionPos = this.worker.m_20183_();
        }
        if (rallyLocation != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            this.worker.m_7292_(new MobEffectInstance(Constants.GLOW_EFFECT, 600, 20, false, false));
        } else {
            this.worker.m_21195_(Constants.GLOW_EFFECT);
        }
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation())) {
            return this.rally(rallyLocation);
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": {
                return this.patrol();
            }
            case "com.minecolonies.core.guard.setting.guard": {
                return this.guard();
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return this.follow();
            }
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return this.patrolMine();
            }
        }
        return AIWorkerState.PREPARING;
    }

    public boolean isWithinPersecutionDistance(BlockPos entityPos, double attackRange) {
        return (double)BlockPosUtil.getDistanceSquared(this.getTaskReferencePoint(), entityPos) <= Math.pow((double)this.getPersecutionDistance() + attackRange, 2.0);
    }

    private BlockPos getTaskReferencePoint() {
        ILocation location = this.buildingGuards.getRallyLocation();
        if (location != null) {
            return this.buildingGuards.getRallyLocation().getInDimensionLocation();
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return this.lastGuardActionPos;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return this.buildingGuards.getPositionToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        if (this.buildingGuards.getRallyLocation() != null) {
            return 30;
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return 80;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return 30;
            }
        }
        return 10 + (this.getModuleForJob().getJobEntry() == ModJobs.knight.get() ? 20 : 0);
    }

    @Override
    public boolean canBeInterrupted() {
        if (this.fighttimer > 0 || this.getState() == CombatAIStates.ATTACKING || this.buildingGuards.getRallyLocation() != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            return false;
        }
        return super.canBeInterrupted();
    }

    public void setWakeCitizen(EntityCitizen citizen) {
        this.sleepingGuard = new WeakReference<EntityCitizen>(citizen);
        this.wakeTimer = 0;
        this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.GUARD_WAKE));
    }

    @Override
    public Class<B> getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    public static boolean isAttackableTarget(AbstractEntityCitizen user, LivingEntity entity) {
        if (IColonyManager.getInstance().getCompatibilityManager().getAllMonsters().contains((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())) && !user.getCitizenData().getWorkBuilding().getModuleMatching(EntityListModule.class, m -> m.getId().equals("hostiles")).isEntityInList(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()))) {
            return true;
        }
        IColony colony = user.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return false;
        }
        if (entity instanceof Player && (colony.getPermissions().hasPermission((Player)entity, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((Player)entity))) {
            return true;
        }
        return entity instanceof EntityCitizen && colony.isValidAttackingGuard((AbstractEntityCitizen)entity);
    }
}

