/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.lumberjack;

import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.entity.pathfinding.TreePathResult;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.colony.jobs.JobLumberjack;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.entity.ai.citizen.lumberjack.Tree;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobMoveToWithPassable;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkLumberjack
extends AbstractEntityAICrafting<JobLumberjack, BuildingLumberjack> {
    public static final String RENDER_META_LOGS = "logs";
    public static final int SEARCH_RANGE = 50;
    private static final int SEARCH_INCREMENT = 5;
    private static final int SEARCH_LIMIT = 150;
    public static final String SAPLINGS_LIST = "saplings";
    public static final float RANGE_VERTICAL_PICKUP = 2.0f;
    public static final float RANGE_HORIZONTAL_PICKUP = 5.0f;
    private static final int MIN_WORKING_RANGE = 2;
    private static final int WAIT_BEFORE_SAPLING = 50;
    private static final int MAX_WAITING_TIME = 50;
    private static final int TIMEOUT_DELAY = 10;
    private static final int WAIT_BEFORE_SEARCH = 400;
    private static final int WAIT_BEFORE_INCREMENT = 20;
    private static final int MAX_BLOCKS_MINED = 32;
    private static final int GATHERING_DELAY = 3;
    private static final VisibleCitizenStatus SEARCH = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/lumberjack_search.png"), "com.minecolonies.gui.visiblestatus.lumberjack_search");
    private static final double XP_PER_TREE = 1.0;
    private BlockPos workFrom;
    private int timeWaited = 0;
    private boolean checkedInHut = false;
    @Nullable
    private TreePathResult pathResult;
    private int searchIncrement = 0;
    private PathResult<?> pathToTree;

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return this.getActionsDoneUntilDumping();
    }

    public EntityAIWorkLumberjack(@NotNull JobLumberjack job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.LUMBERJACK_START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForWoodcutting, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_SEARCHING_TREE, this::findTrees, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_CHOP_TREE, this::chopWood, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_GATHERING, this::gathering, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_NO_TREES_FOUND, this::waitBeforeCheckingAgain, 20), new AITarget((IAIState)AIWorkerState.LUMBERJACK_GATHERING_2, this::gathering2, 20));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingLumberjack> getExpectedBuildingClass() {
        return BuildingLumberjack.class;
    }

    @Override
    protected IAIState decide() {
        if (this.checkIfStuck()) {
            this.tryUnstuck();
            return this.getState();
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobLumberjack)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        if (((JobLumberjack)this.job).getTaskQueue().isEmpty()) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        if (((JobLumberjack)this.job).getCurrentTask() == null) {
            return AIWorkerState.LUMBERJACK_START_WORKING;
        }
        return this.getNextCraftingState();
    }

    private boolean isStackLog(@Nullable ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.m_41720_() instanceof BlockItem && ((BlockItem)stack.m_41720_()).m_40614_().m_49966_().m_204336_(BlockTags.f_13106_);
    }

    private IAIState startWorkingAtOwnBuilding() {
        if (this.walkToBuilding()) {
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState prepareForWoodcutting() {
        if (this.checkForToolOrWeapon(ToolType.AXE) || this.checkForToolOrWeapon(((BuildingLumberjack)this.building).getOptionalSetting(AbstractBuilding.USE_SHEARS).orElse(new BoolSetting(true)).getValue() ? ToolType.SHEARS : ToolType.HOE)) {
            return AIWorkerState.START_WORKING;
        }
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    private IAIState waitBeforeCheckingAgain() {
        this.pathResult = null;
        if (this.hasNotDelayed(400)) {
            return this.getState();
        }
        this.resetGatheringItems();
        return AIWorkerState.LUMBERJACK_GATHERING_2;
    }

    private IAIState gathering2() {
        if (((BuildingLumberjack)this.building).shouldRestrict()) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.gathering")});
            if (this.getItemsForPickUp() == null) {
                this.searchForItems(new AABB(((BuildingLumberjack)this.building).getStartRestriction(), ((BuildingLumberjack)this.building).getEndRestriction()).m_82377_(5.0, 2.0, 5.0));
            }
            if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
                this.gatherItems();
                return this.getState();
            }
        }
        this.resetGatheringItems();
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected boolean isItemWorthPickingUp(ItemStack stack) {
        if (this.getState() == AIWorkerState.LUMBERJACK_GATHERING_2) {
            return stack.m_204117_(ItemTags.f_13180_) || stack.m_204117_(ModTags.fungi);
        }
        return super.isItemWorthPickingUp(stack);
    }

    private IAIState findTrees() {
        if (((JobLumberjack)this.job).getTree() == null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.searchingtree")});
            return this.findTree();
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.LUMBERJACK_CHOP_TREE;
    }

    private IAIState findTree() {
        this.worker.getCitizenData().setVisibleStatus(SEARCH);
        if (this.pathResult != null && this.pathResult.isComputing()) {
            return this.getState();
        }
        if (this.pathResult == null) {
            if (((BuildingLumberjack)this.building).shouldRestrict()) {
                BlockPos startPos = ((BuildingLumberjack)this.building).getStartRestriction();
                BlockPos endPos = ((BuildingLumberjack)this.building).getEndRestriction();
                this.pathResult = this.worker.getNavigation().moveToTree(startPos, endPos, 1.0, (List<ItemStorage>)((BuildingLumberjack)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST)).getList(), ((BuildingLumberjack)this.building).getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColony());
            } else {
                this.pathResult = this.worker.getNavigation().moveToTree(50 + this.searchIncrement, 1.0, (List<ItemStorage>)((BuildingLumberjack)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals(SAPLINGS_LIST)).getList(), ((BuildingLumberjack)this.building).getSetting(BuildingLumberjack.DYNAMIC_TREES_SIZE).getValue(), this.worker.getCitizenColonyHandler().getColony());
            }
            return this.getState();
        }
        if (this.pathResult.isDone()) {
            return this.setNewTree((BuildingLumberjack)this.building);
        }
        return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState setNewTree(BuildingLumberjack building) {
        if (this.pathResult.treeLocation == null) {
            if (building.shouldRestrict() || this.searchIncrement + 50 > 150) return AIWorkerState.LUMBERJACK_NO_TREES_FOUND;
            this.searchIncrement += 5;
            this.setDelay(20);
        } else {
            ((JobLumberjack)this.job).setTree(new Tree(this.world, this.pathResult.treeLocation, building.shouldRestrict() ? null : building.getColony()));
            if (((JobLumberjack)this.job).getTree().isTree()) {
                ((JobLumberjack)this.job).getTree().findLogs(this.world, building.shouldRestrict() ? null : building.getColony());
                return AIWorkerState.LUMBERJACK_CHOP_TREE;
            }
            ((JobLumberjack)this.job).setTree(null);
        }
        this.pathResult = null;
        return this.getState();
    }

    private IAIState chopWood() {
        if (this.checkForToolOrWeapon(ToolType.AXE)) {
            return AIWorkerState.IDLE;
        }
        if (((JobLumberjack)this.job).getTree() == null) {
            return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
        }
        return this.chopTree();
    }

    private IAIState chopTree() {
        BlockPos spawnPoint;
        boolean shouldBreakLeaves;
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.chopping")});
        boolean bl = shouldBreakLeaves = ((BuildingLumberjack)this.building).shouldDefoliate() || ((JobLumberjack)this.job).getTree().isNetherTree();
        if (((BuildingLumberjack)this.building).shouldRestrict() && !BlockPosUtil.isInArea(((BuildingLumberjack)this.building).getStartRestriction(), ((BuildingLumberjack)this.building).getEndRestriction(), ((JobLumberjack)this.job).getTree().getLocation())) {
            ((JobLumberjack)this.job).setTree(null);
            return AIWorkerState.START_WORKING;
        }
        if ((((JobLumberjack)this.job).getTree().hasLogs() || shouldBreakLeaves && ((JobLumberjack)this.job).getTree().hasLeaves() || this.checkedInHut) && !this.walkToTree(((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty() ? ((JobLumberjack)this.job).getTree().getLocation() : ((JobLumberjack)this.job).getTree().getStumpLocations().get(0))) {
            if (this.checkIfStuck()) {
                this.tryUnstuck();
            }
            return this.getState();
        }
        if (!(((JobLumberjack)this.job).getTree().hasLogs() || shouldBreakLeaves && ((JobLumberjack)this.job).getTree().hasLeaves())) {
            if (this.hasNotDelayed(50)) {
                return this.getState();
            }
            if (((BuildingLumberjack)this.building).shouldReplant()) {
                this.plantSapling();
            } else {
                ((JobLumberjack)this.job).setTree(null);
                this.checkedInHut = false;
            }
            ((BuildingLumberjack)this.building).getColony().getStatisticsManager().increment("trees_cut");
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            this.incrementActionsDoneAndDecSaturation();
            this.workFrom = null;
            this.setDelay(60);
            return AIWorkerState.LUMBERJACK_GATHERING;
        }
        if (this.isOnSapling() && (spawnPoint = EntityUtils.getSpawnPoint(this.world, this.workFrom)) != null) {
            WorkerUtil.setSpawnPoint(spawnPoint, this.worker);
        }
        if (((JobLumberjack)this.job).getTree().hasLogs()) {
            BlockPos log = ((JobLumberjack)this.job).getTree().peekNextLog();
            if (((JobLumberjack)this.job).getTree().isDynamicTree()) {
                if (!this.mineBlock(log, this.workFrom, false, false, Compatibility.getDynamicTreeBreakAction(this.world, log, this.worker.m_21120_(InteractionHand.MAIN_HAND), this.worker.m_20183_()))) {
                    return this.getState();
                }
                for (int i = 0; i < 6; ++i) {
                    this.incrementActionsDone();
                }
                this.setDelay(100);
            } else if (!this.mineBlock(log, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLog();
            this.worker.decreaseSaturationForContinuousAction();
        } else if (((JobLumberjack)this.job).getTree().hasLeaves() && shouldBreakLeaves) {
            BlockPos leaf = ((JobLumberjack)this.job).getTree().peekNextLeaf();
            if (!this.mineBlock(leaf, this.workFrom)) {
                return this.getState();
            }
            ((JobLumberjack)this.job).getTree().pollNextLeaf();
        }
        return this.getState();
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            if (this.world.m_213780_().m_188503_(100) <= 95) continue;
            if (stack.m_41720_() == Items.f_42259_) {
                newDrops.add(new ItemStack((ItemLike)Items.f_41954_, 1));
                continue;
            }
            if (stack.m_41720_() != Items.f_42260_) continue;
            newDrops.add(new ItemStack((ItemLike)Items.f_41955_, 1));
        }
        if (newDrops.isEmpty()) {
            return drops;
        }
        return newDrops;
    }

    public boolean walkToTree(BlockPos workAt) {
        if (this.workFrom == null || this.world.m_8055_(this.workFrom.m_7494_()).m_204336_(BlockTags.f_13104_) || this.world.m_8055_(this.workFrom).m_204336_(BlockTags.f_13104_)) {
            this.workFrom = this.getWorkingPosition(workAt);
        }
        if (MathUtils.twoDimDistance(this.worker.m_20183_(), this.workFrom) <= 2.0) {
            return true;
        }
        if (this.pathToTree == null || !this.pathToTree.isInProgress()) {
            this.pathToTree = ((MinecoloniesAdvancedPathNavigate)this.worker.getNavigation()).setPathJob(new PathJobMoveToWithPassable(this.world, AbstractPathJob.prepareStart((LivingEntity)this.worker), workAt, 50, (LivingEntity)this.worker, this::isPassable), workAt, 1.0, true);
        }
        return false;
    }

    private Boolean isPassable(BlockState blockState) {
        return blockState.m_60767_() == Material.f_76274_;
    }

    private boolean checkIfStuck() {
        if (!this.worker.getNavigation().m_26571_()) {
            Path path = this.worker.getNavigation().m_26570_();
            if (path != null) {
                if (path.m_77398_() > path.m_77399_()) {
                    return true;
                }
                return path.m_77398_() == 0;
            }
            return true;
        }
        return false;
    }

    private void tryUnstuck() {
        Path path;
        if (!this.worker.getNavigation().m_26571_() && (path = this.worker.getNavigation().m_26570_()) != null) {
            int i;
            ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
            Node next = path.m_77375_(Math.min(path.m_77399_() + 1, path.m_77398_() - 1));
            for (i = 0; i < 2; ++i) {
                checkPositions.add(new BlockPos(next.f_77271_, next.f_77272_ + i, next.f_77273_));
            }
            if (next.f_77278_ != null) {
                next = next.f_77278_;
                for (i = 0; i < 2; ++i) {
                    checkPositions.add(new BlockPos(next.f_77271_, next.f_77272_ + i, next.f_77273_));
                }
                if (next.f_77278_ != null) {
                    next = next.f_77278_;
                    for (i = 0; i < 2; ++i) {
                        checkPositions.add(new BlockPos(next.f_77271_, next.f_77272_ + i, next.f_77273_));
                    }
                }
            }
            this.mineIfEqualsBlockTag(checkPositions, (TagKey<Block>)BlockTags.f_13035_);
            return;
        }
        ArrayList<BlockPos> checkPositions = new ArrayList<BlockPos>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            checkPositions.add(new BlockPos(this.worker.m_20183_().m_123341_(), this.worker.m_20183_().m_123342_(), this.worker.m_20183_().m_123343_()).m_121945_(direction));
            checkPositions.add(new BlockPos(this.worker.m_20183_().m_123341_(), this.worker.m_20183_().m_123342_() + 1, this.worker.m_20183_().m_123343_()).m_121945_(direction));
        }
        this.mineIfEqualsBlockTag(checkPositions, (TagKey<Block>)BlockTags.f_13035_);
    }

    private boolean mineIfEqualsBlockTag(List<BlockPos> blockPositions, TagKey<Block> tag) {
        for (BlockPos currentPos : blockPositions) {
            if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
                Log.getLogger().info(String.format("Check Leaves Pos(%d, %d, %d) is %s: %s", currentPos.m_123341_(), currentPos.m_123342_(), currentPos.m_123343_(), tag.toString(), this.world.m_8055_(currentPos).m_204336_(tag)));
            }
            if (!this.world.m_8055_(currentPos).m_204336_(tag)) continue;
            this.mineBlock(currentPos);
            return true;
        }
        return false;
    }

    private void plantSapling() {
        if (this.plantSapling(((JobLumberjack)this.job).getTree().getLocation())) {
            ((JobLumberjack)this.job).setTree(null);
            this.checkedInHut = false;
        }
    }

    private boolean isOnSapling() {
        return this.world.m_8055_(this.worker.m_20183_()).m_204336_(BlockTags.f_13104_) || this.world.m_8055_(this.worker.m_20183_().m_7494_()).m_204336_(BlockTags.f_13104_) || this.world.m_8055_(this.worker.m_20183_().m_7495_()).m_204336_(BlockTags.f_13104_);
    }

    private boolean plantSapling(@NotNull BlockPos location) {
        BlockState worldState = this.world.m_8055_(location);
        Block worldBlock = worldState.m_60734_();
        if (!(worldBlock instanceof AirBlock) && !worldState.m_204336_(BlockTags.f_13104_) && worldBlock != Blocks.f_50125_) {
            return true;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.planting")});
        int saplingSlot = this.findSaplingSlot();
        if (saplingSlot != -1) {
            ItemStack stack = this.getInventory().getStackInSlot(saplingSlot);
            this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, saplingSlot);
            if (((JobLumberjack)this.job).getTree().isDynamicTree() && Compatibility.isDynamicTreeSapling(stack)) {
                Compatibility.plantDynamicSapling(this.world, location, stack);
                this.getInventory().extractItem(saplingSlot, 1, false);
                this.worker.m_6674_(this.worker.m_7655_());
                this.timeWaited = 0;
                this.incrementActionsDoneAndDecSaturation();
                this.setDelay(10);
                return true;
            }
            Block block = ((BlockItem)stack.m_41720_()).m_40614_();
            this.placeSaplings(saplingSlot, stack, block);
            SoundType soundType = block.getSoundType(this.world.m_8055_(location), (LevelReader)this.world, location, (Entity)this.worker);
            this.world.m_5594_(null, this.worker.m_20183_(), soundType.m_56777_(), SoundSource.BLOCKS, soundType.m_56773_(), soundType.m_56774_());
            this.worker.m_6674_(this.worker.m_7655_());
        }
        if (this.timeWaited >= 25 && !this.checkedInHut && !this.walkToBuilding()) {
            this.checkAndTransferFromHut(((JobLumberjack)this.job).getTree().getSapling());
            this.checkedInHut = true;
        }
        if (((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty() || this.timeWaited >= 50) {
            this.timeWaited = 0;
            this.incrementActionsDoneAndDecSaturation();
            this.setDelay(10);
            return true;
        }
        this.timeWaited += 10;
        return false;
    }

    @Override
    public void fillItemsList() {
        if (((JobLumberjack)this.job).getTree() != null) {
            this.searchForItems(new AABB(((JobLumberjack)this.job).getTree().getLocation()).m_82363_(5.0, 2.0, 5.0).m_82363_(-5.0, -2.0, -5.0));
        } else {
            this.searchForItems(this.worker.m_20191_().m_82363_(5.0, 2.0, 5.0).m_82363_(-5.0, -2.0, -5.0));
        }
    }

    private int findSaplingSlot() {
        for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
            ItemStack stack = this.getInventory().getStackInSlot(slot);
            if (!this.isCorrectSapling(stack)) continue;
            return slot;
        }
        return -1;
    }

    private void placeSaplings(int saplingSlot, @NotNull ItemStack stack, @NotNull Block block) {
        while (!((JobLumberjack)this.job).getTree().getStumpLocations().isEmpty()) {
            BlockPos pos = ((JobLumberjack)this.job).getTree().getStumpLocations().get(0);
            ItemStack sapling = this.getInventory().getStackInSlot(saplingSlot);
            if (sapling.m_204117_(ModTags.fungi)) {
                Block new_block = sapling.m_41720_() == Items.f_41955_ ? Blocks.f_50690_ : Blocks.f_50699_;
                if (this.world.m_8055_(pos.m_7495_()).m_60734_() instanceof NetherrackBlock) {
                    this.world.m_46597_(pos.m_7495_(), new_block.m_49966_());
                    ((BuildingLumberjack)this.building).addNetherTree(pos);
                }
            }
            if (!(block instanceof IPlantable) || !block.canSustainPlant(this.world.m_8055_(pos.m_7495_()), (BlockGetter)this.world, pos.m_7495_(), Direction.UP, (IPlantable)block) || Objects.equals(this.world.m_8055_(pos), block.m_49966_())) {
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            if (this.world.m_46597_(pos, block.m_49966_()) && !ItemStackUtils.isEmpty(this.getInventory().getStackInSlot(saplingSlot)).booleanValue()) {
                this.getInventory().extractItem(saplingSlot, 1, false);
                ((JobLumberjack)this.job).getTree().removeStump(pos);
                continue;
            }
            return;
        }
    }

    private boolean isCorrectSapling(ItemStack stack) {
        if (!ItemStackUtils.isStackSapling(stack)) {
            return false;
        }
        if (ItemStackUtils.isEmpty(((JobLumberjack)this.job).getTree().getSapling()).booleanValue()) {
            return false;
        }
        return ((JobLumberjack)this.job).getTree().getSapling().m_41656_(stack);
    }

    private IAIState gathering() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.gathering")});
        if (this.getItemsForPickUp() == null) {
            this.fillItemsList();
        }
        if (this.getItemsForPickUp() != null && !this.getItemsForPickUp().isEmpty()) {
            this.gatherItems();
            return this.getState();
        }
        this.resetGatheringItems();
        return AIWorkerState.LUMBERJACK_SEARCHING_TREE;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 32;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.hasLogs() ? RENDER_META_LOGS : "");
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getWorkingPosition(2, targetPosition, 0);
    }

    private boolean hasLogs() {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)this.getInventory(), this::isStackLog);
    }
}

