/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.minimal;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.GraveyardManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingGraveyard;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;

public class EntityAIMournCitizen
extends Goal {
    private final TickRateStateMachine<MourningState> stateMachine;
    private final EntityCitizen citizen;
    private final double speed;
    private Entity closestEntity;
    private static final int MIN_DESTINATION_TO_LOCATION = 225;
    private static final int AVERAGE_MOURN_TIME = 300;
    private static final int AVERAGE_STARE_TIME = 200;
    private BlockPos graveyard;
    private BlockPos gravePos;

    public EntityAIMournCitizen(EntityCitizen citizen, double speed) {
        this.citizen = citizen;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.stateMachine = new TickRateStateMachine<MourningState>(MourningState.IDLE, e -> Log.getLogger().warn("Mourning AI threw exception:", (Throwable)e));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.IDLE, () -> true, () -> MourningState.DECIDE, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.DECIDE, () -> true, this::decide, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_TOWNHALL, () -> true, this::walkToTownHall, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDERING, () -> true, this::wander, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.STARING, () -> true, this::stare, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALKING_TO_GRAVEYARD, () -> true, this::walkToGraveyard, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WANDER_AT_GRAVEYARD, () -> true, this::wanderAtGraveyard, 20));
        this.stateMachine.addTransition(new TickingTransition<MourningState>(MourningState.WALK_TO_GRAVE, () -> true, this::walkToGrave, 20));
    }

    private boolean shouldMourn() {
        boolean shouldMourn;
        boolean bl = shouldMourn = this.citizen.getDesiredActivity() == DesiredActivity.MOURN;
        if (shouldMourn && this.citizen.m_217043_().m_188503_(300) < 1) {
            this.citizen.getCitizenData().getCitizenMournHandler().clearDeceasedCitizen();
            this.citizen.getCitizenData().getCitizenMournHandler().setMourning(false);
            this.citizen.getCitizenData().setVisibleStatus(null);
        }
        return shouldMourn;
    }

    private MourningState walkToTownHall() {
        BlockPos pos = this.getMournLocation();
        this.citizen.getNavigation().moveToXYZ(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.speed);
        return MourningState.IDLE;
    }

    private MourningState walkToGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.graveyard, 3)) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        return MourningState.WANDER_AT_GRAVEYARD;
    }

    private MourningState wanderAtGraveyard() {
        if (this.graveyard == null) {
            return MourningState.DECIDE;
        }
        if (!this.shouldMourn()) {
            return MourningState.IDLE;
        }
        IBuilding graveyardBuilding = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getBuilding(this.graveyard);
        if (!(graveyardBuilding instanceof BuildingGraveyard)) {
            this.graveyard = null;
            return MourningState.DECIDE;
        }
        if (!this.citizen.getNavigation().m_26571_()) {
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        if (MathUtils.RANDOM.nextInt(100) < 90) {
            this.citizen.getNavigation().moveToRandomPos(10, 0.6, graveyardBuilding.getCorners(), AbstractAdvancedPathNavigate.RestrictionType.XYZ);
            return MourningState.WANDER_AT_GRAVEYARD;
        }
        Set<Tuple<BlockPos, Direction>> gravePositions = ((BuildingGraveyard)graveyardBuilding).getGravePositions();
        for (Tuple<BlockPos, Direction> gravePos : gravePositions) {
            Iterator<String> iterator;
            BlockEntity blockEntity;
            if (!WorldUtil.isBlockLoaded((LevelAccessor)this.citizen.f_19853_, gravePos.getA()) || !((blockEntity = this.citizen.f_19853_.m_7702_(gravePos.getA())) instanceof TileEntityNamedGrave) || !(iterator = this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens().iterator()).hasNext()) continue;
            String deathBud = iterator.next();
            String firstName = StringUtils.split((String)deathBud)[0];
            String lastName = deathBud.replaceFirst(firstName, "");
            ArrayList<String> graveNameList = ((TileEntityNamedGrave)blockEntity).getTextLines();
            if (graveNameList.isEmpty() || !graveNameList.contains(firstName) || !graveNameList.contains(lastName)) continue;
            this.gravePos = gravePos.getA();
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private MourningState walkToGrave() {
        if (this.gravePos == null) {
            return MourningState.DECIDE;
        }
        if (!this.shouldMourn()) {
            return MourningState.IDLE;
        }
        if (!this.citizen.isWorkerAtSiteWithMove(this.gravePos, 3)) {
            return MourningState.WALK_TO_GRAVE;
        }
        return MourningState.DECIDE;
    }

    private MourningState wander() {
        this.citizen.getNavigation().moveToRandomPos(10.0, this.speed);
        return MourningState.IDLE;
    }

    private MourningState stare() {
        if (this.citizen.m_217043_().m_188503_(200) < 1) {
            this.closestEntity = null;
            return MourningState.IDLE;
        }
        if (this.closestEntity == null) {
            this.closestEntity = this.citizen.f_19853_.m_45963_(EntityCitizen.class, TargetingConditions.f_26872_, (LivingEntity)this.citizen, this.citizen.m_20185_(), this.citizen.m_20186_(), this.citizen.m_20189_(), this.citizen.m_20191_().m_82377_(3.0, 3.0, 3.0));
            if (this.closestEntity == null) {
                return MourningState.IDLE;
            }
        }
        this.citizen.m_21563_().m_24950_(this.closestEntity.m_20185_(), this.closestEntity.m_20186_() + (double)this.closestEntity.m_20192_(), this.closestEntity.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        return MourningState.STARING;
    }

    private MourningState decide() {
        if (this.citizen.getDesiredActivity() != DesiredActivity.MOURN) {
            return MourningState.IDLE;
        }
        if (!this.citizen.getNavigation().m_26571_()) {
            return MourningState.IDLE;
        }
        if (this.citizen.getCitizenStatusHandler().getStatus() != Status.MOURN) {
            this.citizen.getCitizenItemHandler().removeHeldItem();
            this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.MOURNING);
            this.citizen.getCitizenStatusHandler().setStatus(Status.MOURN);
        }
        if (this.citizen.m_217043_().m_188499_()) {
            return MourningState.STARING;
        }
        if (this.graveyard == null) {
            this.graveyard = this.citizen.getCitizenColonyHandler().getColony().getBuildingManager().getFirstBuildingMatching(b -> b instanceof BuildingGraveyard && b.getFirstModuleOccurance(GraveyardManagementModule.class).hasRestingCitizen(this.citizen.getCitizenData().getCitizenMournHandler().getDeceasedCitizens()));
        }
        if (this.graveyard != null) {
            return MourningState.WALKING_TO_GRAVEYARD;
        }
        this.citizen.m_21563_().m_24950_(this.citizen.m_20185_(), this.citizen.m_20186_() - 10.0, this.citizen.m_20189_(), (float)this.citizen.m_8085_(), (float)this.citizen.m_8132_());
        if (BlockPosUtil.getDistance2D(this.citizen.m_20183_(), this.getMournLocation()) > 225L) {
            return MourningState.WALKING_TO_TOWNHALL;
        }
        return MourningState.WANDERING;
    }

    public boolean m_8036_() {
        if (this.citizen.getDesiredActivity() == DesiredActivity.MOURN && MathUtils.RANDOM.nextInt(20) < 1) {
            return this.shouldMourn();
        }
        return this.citizen.getDesiredActivity() == DesiredActivity.MOURN;
    }

    public void m_8037_() {
        this.stateMachine.tick();
    }

    public void m_8041_() {
        this.stateMachine.reset();
        this.citizen.getCitizenData().setVisibleStatus(null);
        this.graveyard = null;
        this.gravePos = null;
    }

    protected BlockPos getMournLocation() {
        IColony colony = this.citizen.getCitizenColonyHandler().getColony();
        if (colony == null || !colony.getBuildingManager().hasTownHall()) {
            return this.citizen.m_21534_();
        }
        return colony.getBuildingManager().getTownHall().getPosition();
    }

    public static enum MourningState implements IState
    {
        IDLE,
        DECIDE,
        WALKING_TO_TOWNHALL,
        WANDERING,
        STARING,
        WALKING_TO_GRAVEYARD,
        WANDER_AT_GRAVEYARD,
        WALK_TO_GRAVE;

    }
}

