/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.CustomGoalSelector;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.Status;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.combat.threat.ThreatTable;
import com.minecolonies.api.entity.pathfinding.PathResult;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.colonyEvents.citizenEvents.CitizenDiedEvent;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobKnight;
import com.minecolonies.coremod.colony.jobs.JobNetherWorker;
import com.minecolonies.coremod.colony.jobs.JobPupil;
import com.minecolonies.coremod.colony.jobs.JobRanger;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenAvoidEntity;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenChild;
import com.minecolonies.coremod.entity.ai.minimal.EntityAICitizenWander;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIEatTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIMournCitizen;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISickTask;
import com.minecolonies.coremod.entity.ai.minimal.EntityAISleep;
import com.minecolonies.coremod.entity.citizen.CitizenColonyHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenChatHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenDiseaseHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenItemHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.coremod.entity.citizen.citizenhandlers.CitizenStatusHandler;
import com.minecolonies.coremod.entity.pathfinding.EntityCitizenWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MovementHandler;
import com.minecolonies.coremod.event.EventHandler;
import com.minecolonies.coremod.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.coremod.network.messages.client.VanillaParticleMessage;
import com.minecolonies.coremod.network.messages.client.colony.PlaySoundForCitizenMessage;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.time.Clock;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCitizen
extends AbstractEntityCitizen
implements IThreatTableEntity {
    private static final int CALL_HELP_CD = 100;
    private static final float GUARD_BLOCK_DAMAGE = 0.5f;
    private static final double MAX_SPEED_FACTOR = 0.5;
    private static final int CALL_TO_HELP_AMOUNT = 2;
    private final ICitizenStatusHandler citizenStatusHandler;
    private int citizenId = 0;
    private IWalkToProxy proxy;
    private ICitizenData citizenData;
    private ICitizenExperienceHandler citizenExperienceHandler;
    private ICitizenChatHandler citizenChatHandler;
    private ICitizenItemHandler citizenItemHandler;
    private ICitizenInventoryHandler citizenInventoryHandler;
    private ICitizenColonyHandler citizenColonyHandler;
    private ICitizenJobHandler citizenJobHandler;
    private ICitizenSleepHandler citizenSleepHandler;
    private ICitizenDiseaseHandler citizenDiseaseHandler;
    private PathResult moveAwayPath;
    private boolean child = false;
    private boolean currentlyFleeing = false;
    private int callForHelpCooldown = 0;
    private float lastDistanceWalked = 0.0f;
    private ICitizenDataView citizenDataView;
    private ILocation location = null;
    private String cachedTeamName;
    private ChunkPos lastChunk;
    private final ThreatTable threatTable = new ThreatTable<EntityCitizen>(this);
    private int interactionCooldown = 0;
    private Team cachedTeam;
    private ITickRateStateMachine<EntityState> entityStatemachine = new TickRateStateMachine<EntityState>(EntityState.INIT, e -> Log.getLogger().warn(e));
    private DesiredActivity desiredActivity = DesiredActivity.IDLE;

    public EntityCitizen(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
        this.f_21345_ = new CustomGoalSelector(this.f_21345_);
        this.f_21346_ = new CustomGoalSelector(this.f_21346_);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.citizenChatHandler = new CitizenChatHandler(this);
        this.citizenStatusHandler = new CitizenStatusHandler(this);
        this.citizenItemHandler = new CitizenItemHandler(this);
        this.citizenInventoryHandler = new CitizenInventoryHandler(this);
        this.citizenColonyHandler = new CitizenColonyHandler(this);
        this.citizenJobHandler = new CitizenJobHandler(this);
        this.citizenSleepHandler = new CitizenSleepHandler(this);
        this.citizenDiseaseHandler = new CitizenDiseaseHandler(this);
        this.f_21342_ = new MovementHandler((Mob)this);
        this.m_21530_();
        this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INIT, () -> true, this::initialize, 40));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, () -> {
            this.citizenColonyHandler.updateColonyClient();
            return false;
        }, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_CLIENT, this::refreshCitizenDataView, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateSaturation, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::updateVisualData, () -> null, 200));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onServerUpdateHandlers, () -> null, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::onTickDecrements, () -> null, 1));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::shouldBeInactive, () -> EntityState.INACTIVE, 20));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.ACTIVE_SERVER, this::determineDesiredActivity, () -> null, 100));
        this.entityStatemachine.addTransition(new TickingTransition<EntityState>(EntityState.INACTIVE, () -> ((EntityCitizen)this).m_6084_(), () -> EntityState.INIT, 100));
    }

    private boolean shouldBeInactive() {
        if (this.citizenData == null && this.citizenDataView == null) {
            return true;
        }
        return !this.m_6084_();
    }

    private EntityState initialize() {
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.cachedTeamName = colonyView.getTeamName();
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                if (this.citizenDataView != null) {
                    this.initTasks();
                    return EntityState.ACTIVE_CLIENT;
                }
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.citizenData != null && this.m_6084_() && this.citizenColonyHandler.getColony() != null) {
                this.initTasks();
                return EntityState.ACTIVE_SERVER;
            }
        }
        return null;
    }

    private void initTasks() {
        int priority = 0;
        this.f_21345_.m_25352_(priority, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAICitizenAvoidEntity(this, Monster.class, 5.0f, 0.8, 1.1));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAIEatTask(this));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAISickTask(this));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAISleep(this));
        this.f_21345_.m_25352_(priority, (Goal)new EntityAIInteractToggleAble((Mob)this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.f_21345_.m_25352_(++priority, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(++priority, (Goal)new InteractGoal((Mob)this, EntityCitizen.class, 5.0f, 0.02f));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAIMournCitizen(this, 0.6));
        this.f_21345_.m_25352_(++priority, (Goal)new EntityAICitizenWander(this, 0.6));
        this.f_21345_.m_25352_(++priority, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 6.0f));
    }

    @NotNull
    public InteractionResult m_21499_(Player player, @NotNull InteractionHand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)player.f_19853_.m_46472_());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.m_21120_(hand)).booleanValue() && player.m_21120_(hand).m_41720_() instanceof NameTagItem) {
            return super.m_21499_(player, hand);
        }
        InteractionResult result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_ && iColonyView != null) {
            if (player.m_6144_() && !this.m_20145_()) {
                Network.getNetwork().sendToServer(new OpenInventoryMessage(iColonyView, this.m_7755_().getString(), this.m_19879_()));
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null && !this.m_20145_()) {
                    MineColonies.proxy.showCitizenWindow(citizenDataView);
                }
            }
        }
        if (this.citizenData != null && this.citizenData.getJob() != null) {
            ((AbstractEntityAIBasic)((Object)this.citizenData.getJob().getWorkerAI())).setDelay(60);
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult directPlayerInteraction(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            return null;
        }
        ItemStack usedStack = player.m_21120_(hand);
        if (((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue() && usedStack.m_41720_() instanceof BlockItem && ((BlockItem)usedStack.m_41720_()).m_40614_() instanceof AbstractBlockHut) {
            BuildingEntry entry = ((AbstractBlockHut)((BlockItem)usedStack.m_41720_()).m_40614_()).getBuildingEntry();
            for (Supplier<IBuildingModule> module : entry.getModuleProducers()) {
                if (!(module.get() instanceof WorkerBuildingModule)) continue;
                this.getCitizenJobHandler().setModelDependingOnJob(((WorkerBuildingModule)module.get()).getJobEntry().produceJob(null));
                return InteractionResult.SUCCESS;
            }
        }
        if (this.isInteractionItem(usedStack) && this.interactionCooldown > 0) {
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_(SoundEvents.f_12507_, 0.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                MessageUtils.format("com.minecolonies.coremod.interaction.notnow", this.getCitizenData().getName()).with(ChatFormatting.RED).sendTo(player);
            }
            return null;
        }
        if (usedStack.m_41720_() == Items.f_42436_ && this.getCitizenDiseaseHandler().isSick()) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_() && this.m_217043_().m_188503_(3) == 0) {
                this.getCitizenDiseaseHandler().cure();
                this.m_5496_(SoundEvents.f_12275_, 1.0f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                Network.getNetwork().sendToTrackingEntity(new VanillaParticleMessage(this.m_20185_(), this.m_20186_(), this.m_20189_(), ParticleTypes.f_123748_), (Entity)this);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (this.getCitizenDiseaseHandler().isSick()) {
            return null;
        }
        if (ItemStackUtils.ISFOOD.test(usedStack) && usedStack.m_41720_() != Items.f_42436_) {
            if (this.m_6162_()) {
                this.childFoodInteraction(usedStack, player, hand);
            } else {
                this.eatFoodInteraction(usedStack, player, hand);
            }
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_42517_ && this.m_6162_()) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                this.getCitizenData().getCitizenSkillHandler().addXpToSkill(Skill.Intelligence, 50.0, this.getCitizenData());
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_41982_) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                MessageUtils.format("com.minecolonies.coremod.interaction.ouch", this.getCitizenData().getName()).sendTo(player);
                this.getNavigation().moveAwayFromLivingEntity((Entity)player, 5.0, 1.0);
                this.m_6862_(true);
            }
            this.interactionCooldown = 6000;
            return InteractionResult.CONSUME;
        }
        if (usedStack.m_41720_() == Items.f_42525_) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            if (!this.f_19853_.m_5776_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 3600));
            }
            this.interactionCooldown = 3600;
            return InteractionResult.CONSUME;
        }
        return null;
    }

    public boolean isInteractionItem(ItemStack stack) {
        return ItemStackUtils.ISFOOD.test(stack) || stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42436_ || stack.m_41720_() == Items.f_41982_ || stack.m_41720_() == Items.f_42525_;
    }

    private void childFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        if (usedStack.m_41611_().getString().toLowerCase(Locale.ENGLISH).contains("cookie")) {
            usedStack.m_41774_(1);
            player.m_21008_(hand, usedStack);
            this.interactionCooldown = 100;
            if (!this.f_19853_.m_5776_()) {
                double satIncrease = (double)usedStack.m_41720_().getFoodProperties(usedStack, (LivingEntity)this).m_38744_() * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
                this.citizenData.increaseSaturation(satIncrease / 2.0);
                this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 300));
                this.m_5496_(SoundEvents.f_11912_, 1.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_20192_()), (Entity)this);
            }
        } else {
            player.m_150109_().m_36057_(usedStack);
            player.m_7197_(usedStack, true, true);
            if (!this.f_19853_.m_5776_()) {
                this.m_5496_(SoundEvents.f_12507_, 1.0f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
                MessageUtils.format("com.minecolonies.coremod.interaction.nocookie", this.getCitizenData().getName()).with(ChatFormatting.RED).sendTo(player);
            }
        }
    }

    private void eatFoodInteraction(ItemStack usedStack, Player player, InteractionHand hand) {
        usedStack.m_41774_(1);
        player.m_21008_(hand, usedStack);
        this.interactionCooldown = 100;
        if (!this.f_19853_.m_5776_()) {
            double satIncrease = (double)usedStack.m_41720_().getFoodProperties(usedStack, (LivingEntity)this).m_38744_() * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATURATION));
            this.citizenData.increaseSaturation(satIncrease / 2.0);
            this.m_5496_(SoundEvents.f_11912_, 1.5f, (float)SoundUtils.getRandomPitch(this.m_217043_()));
            Network.getNetwork().sendToTrackingEntity(new ItemParticleEffectMessage(usedStack, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_20192_()), (Entity)this);
        }
    }

    public String m_6302_() {
        return this.m_7755_().getString() + " (" + this.getCivilianID() + ")";
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.citizenDataView = colonyView.getCitizen(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("status", this.citizenStatusHandler.getStatus().ordinal());
        if (this.citizenColonyHandler.getColony() != null && this.citizenData != null) {
            compound.m_128405_("colony", this.citizenColonyHandler.getColony().getID());
            compound.m_128405_("citizen", this.citizenData.getId());
        }
        this.citizenDiseaseHandler.write(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.citizenStatusHandler.setStatus(Status.values()[compound.m_128451_("status")]);
        this.citizenColonyHandler.setColonyId(compound.m_128451_("colony"));
        this.citizenId = compound.m_128451_("citizen");
        this.citizenDiseaseHandler.read(compound);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        this.entityStatemachine.tick();
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
    }

    public boolean refreshCitizenDataView() {
        IColonyView colonyView;
        if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
            this.citizenDataView = colonyView.getCitizen(this.citizenId);
            this.getNavigation().getPathingOptions().setCanUseRails(this.canPathOnRails());
            this.getNavigation().getPathingOptions().setCanClimbVines(this.canClimbVines());
        }
        return false;
    }

    private boolean onTickDecrements() {
        this.decrementCallForHelpCooldown();
        this.decreaseWalkingSaturation();
        return false;
    }

    private boolean onServerUpdateHandlers() {
        this.citizenExperienceHandler.gatherXp();
        this.citizenItemHandler.pickupItems();
        this.citizenData.setLastPosition(this.m_20183_());
        this.citizenDiseaseHandler.tick();
        this.onLivingSoundUpdate();
        ChunkPos currentChunk = this.m_146902_();
        if (!Objects.equals(currentChunk, this.lastChunk)) {
            this.lastChunk = currentChunk;
            EventHandler.onEnteringChunkEntity(this, currentChunk);
        }
        if (!this.getEyeInFluidType().isAir() && !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60713_(Blocks.f_50628_)) {
            this.m_20219_(this.m_20182_().m_82520_(this.f_19796_.m_188499_() ? 1.0 : 0.0, 0.0, this.f_19796_.m_188499_() ? 1.0 : 0.0));
        }
        return false;
    }

    public int m_6062_() {
        if (this.getCitizenColonyHandler() != null && this.getCitizenColonyHandler().getColony() != null && this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MORE_AIR) > 0.0) {
            return super.m_6062_() * 2;
        }
        return super.m_6062_();
    }

    private boolean updateVisualData() {
        ItemStack hat = this.m_6844_(EquipmentSlot.HEAD);
        if (LocalDate.now(Clock.systemDefaultZone()).getMonth() == Month.DECEMBER && ((Boolean)MineColonies.getConfig().getServer().holidayFeatures.get()).booleanValue()) {
            if (hat.m_41619_()) {
                this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.santaHat));
            }
        } else if (!hat.m_41619_() && hat.m_41720_() == ModItems.santaHat) {
            this.m_8061_(EquipmentSlot.HEAD, ItemStackUtils.EMPTY);
        }
        this.m_20340_((Boolean)MineColonies.getConfig().getServer().alwaysRenderNameTag.get());
        if (!this.citizenColonyHandler.getColony().getTextureStyleId().equals(this.m_20088_().m_135370_(DATA_STYLE))) {
            this.m_20088_().m_135381_(DATA_STYLE, (Object)this.citizenColonyHandler.getColony().getTextureStyleId());
        }
        if (!this.citizenData.getTextureSuffix().equals(this.m_20088_().m_135370_(DATA_TEXTURE_SUFFIX))) {
            this.m_20088_().m_135381_(DATA_TEXTURE_SUFFIX, (Object)this.citizenData.getTextureSuffix());
        }
        return false;
    }

    private boolean updateSaturation() {
        this.checkHeal();
        if (this.citizenData.getSaturation() <= 0.0) {
            if (this.m_21124_(MobEffects.f_19597_) == null) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 600));
            }
        } else {
            this.m_21195_(MobEffects.f_19597_);
        }
        return false;
    }

    private void decrementCallForHelpCooldown() {
        if (this.callForHelpCooldown > 0) {
            --this.callForHelpCooldown;
        }
    }

    public boolean canPathOnRails() {
        if (this.f_19853_.f_46443_) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RAILS) > 0.0;
    }

    public boolean canClimbVines() {
        if (this.f_19853_.f_46443_) {
            IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
            if (colonyView != null) {
                return colonyView.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
            }
            return false;
        }
        return this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.VINES) > 0.0;
    }

    private void decreaseWalkingSaturation() {
        if (this.f_19787_ - this.lastDistanceWalked > 25.0f) {
            this.lastDistanceWalked = this.f_19787_;
            this.decreaseSaturationForContinuousAction();
        }
    }

    private void checkHeal() {
        if (this.m_21223_() < this.m_21233_()) {
            double healAmount;
            double limitDecrease = this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
            if (this.citizenData.getSaturation() >= 20.0 + limitDecrease) {
                healAmount = 2.0 * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            } else {
                if (this.citizenData.getSaturation() < 6.0) {
                    return;
                }
                healAmount = 1.0 * (1.0 + this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            }
            this.m_5634_((float)healAmount);
            if (healAmount > 0.1) {
                this.citizenData.markDirty();
            }
        }
    }

    private void onLivingSoundUpdate() {
        if (WorldUtil.isDayTime(this.f_19853_) && !this.m_20067_()) {
            SoundUtils.playRandomSound(this.f_19853_, this.m_20183_(), this.citizenData);
        }
    }

    public boolean m_6162_() {
        return this.child;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        this.f_19804_.m_135372_(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void setRenderMetadata(String metadata) {
        super.setRenderMetadata(metadata);
        if (this.citizenJobHandler.getColonyJob() != null && ((Boolean)MineColonies.getConfig().getServer().enableInDevelopmentFeatures.get()).booleanValue()) {
            this.m_6593_((Component)Component.m_237113_((String)(this.citizenData.getName() + " (" + this.citizenStatusHandler.getStatus() + ")[" + this.citizenJobHandler.getColonyJob().getNameTagDescription() + "]")));
        }
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public boolean isWorkerAtSiteWithMove(@NotNull BlockPos site, int range) {
        if (this.proxy == null) {
            this.proxy = new EntityCitizenWalkToProxy(this);
        }
        return this.proxy.walkToBlock(site, range, true);
    }

    @Override
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null) {
            this.citizenData = (ICitizenData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty() {
        if (this.citizenData != null) {
            this.citizenData.markDirty();
        }
    }

    @Override
    public void setCitizensize(@NotNull float width, @NotNull float height) {
        this.f_19815_ = new EntityDimensions(width, height, false);
    }

    @Override
    public void setIsChild(boolean isChild) {
        if (isChild && !this.child) {
            this.f_21345_.m_25352_(50, (Goal)new EntityAICitizenChild(this));
            this.setCitizensize(0.3f, 0.9f);
        } else {
            if (!isChild && this.child) {
                this.getCitizenJobHandler().setModelDependingOnJob(this.citizenJobHandler.getColonyJob());
            }
            this.setCitizensize(0.6f, 1.8f);
        }
        this.child = isChild;
        this.m_20088_().m_135381_(DATA_IS_CHILD, (Object)isChild);
        this.markDirty();
    }

    @Override
    public void playMoveAwaySound() {
        if (this.citizenJobHandler.getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(this.f_19853_, this.m_20183_(), EventType.DANGER, this.getCitizenData());
        }
    }

    @Override
    public IWalkToProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost());
            this.citizenData.markDirty();
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() / 100.0);
            this.citizenData.markDirty();
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenChatHandler getCitizenChatHandler() {
        return this.citizenChatHandler;
    }

    @Override
    public ICitizenStatusHandler getCitizenStatusHandler() {
        return this.citizenStatusHandler;
    }

    @Override
    public ICitizenItemHandler getCitizenItemHandler() {
        return this.citizenItemHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public ICitizenDiseaseHandler getCitizenDiseaseHandler() {
        return this.citizenDiseaseHandler;
    }

    @Override
    public void setCitizenDiseaseHandler(ICitizenDiseaseHandler citizenDiseaseHandler) {
        this.citizenDiseaseHandler = citizenDiseaseHandler;
    }

    @Override
    public boolean isOkayToEat() {
        return !this.getCitizenSleepHandler().isAsleep() && this.getDesiredActivity() != DesiredActivity.SLEEP && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().canAIBeInterrupted());
    }

    @Override
    public boolean shouldBeFed() {
        return this.getCitizenData() != null && this.getCitizenData().getSaturation() <= 10.0 && !this.getCitizenData().justAte() && this.isOkayToEat();
    }

    @Override
    public boolean isIdlingAtJob() {
        return this.isOkayToEat() && (this.citizenJobHandler.getColonyJob() == null || this.citizenJobHandler.getColonyJob().isIdling());
    }

    private boolean determineDesiredActivity() {
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        if (this.getCitizenColonyHandler().getColony().getRaiderManager().isRaided()) {
            this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.raid"), ChatPriority.IMPORTANT));
            this.setVisibleStatusIfNone(VisibleCitizenStatus.RAIDED);
            this.desiredActivity = DesiredActivity.SLEEP;
            return false;
        }
        if (!WorldUtil.isPastTime(CompatibilityUtils.getWorldFromCitizen(this), 10600)) {
            if (this.desiredActivity == DesiredActivity.SLEEP) {
                this.setVisibleStatusIfNone(VisibleCitizenStatus.SLEEP);
                return false;
            }
            if (this.citizenSleepHandler.shouldGoSleep()) {
                this.citizenData.onGoSleep();
                this.citizenData.decreaseSaturation(this.citizenColonyHandler.getPerBuildingFoodCost() * 2.0);
                this.citizenData.markDirty();
                this.citizenStatusHandler.setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.sleeping")});
                this.desiredActivity = DesiredActivity.SLEEP;
                return false;
            }
        }
        if (this.citizenData.getCitizenMournHandler().isMourning() && this.citizenData.getCitizenMournHandler().shouldMourn()) {
            if (!this.getCitizenColonyHandler().getColony().getRaiderManager().isRaided()) {
                this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237110_((String)"com.minecolonies.coremod.entity.citizen.mourning", (Object[])new Object[]{this.citizenData.getCitizenMournHandler().getDeceasedCitizens().iterator().next()}), (Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.mourning"), ChatPriority.IMPORTANT));
            }
            this.setVisibleStatusIfNone(VisibleCitizenStatus.MOURNING);
            this.desiredActivity = DesiredActivity.MOURN;
            return false;
        }
        if (this.citizenSleepHandler.isAsleep() && !this.citizenDiseaseHandler.isSick()) {
            this.citizenSleepHandler.onWakeUp();
        }
        if (CompatibilityUtils.getWorldFromCitizen(this).m_46471_() && !this.shouldWorkWhileRaining() && !WorldUtil.isNetherType(this.f_19853_)) {
            this.citizenStatusHandler.setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.waiting"), Component.m_237115_((String)"com.minecolonies.coremod.status.rainStop")});
            this.setVisibleStatusIfNone(VisibleCitizenStatus.BAD_WEATHER);
            if (!this.citizenData.getColony().getRaiderManager().isRaided() && !this.citizenData.getCitizenMournHandler().isMourning()) {
                this.citizenData.triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"com.minecolonies.coremod.entity.citizen.raining"), ChatPriority.HIDDEN));
            }
            this.desiredActivity = DesiredActivity.SLEEP;
            return false;
        }
        if (this.m_6162_() && this.getCitizenJobHandler().getColonyJob() instanceof JobPupil && this.f_19853_.m_46468_() % 24000L > 6000L) {
            this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
            this.desiredActivity = DesiredActivity.IDLE;
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null) {
            this.desiredActivity = DesiredActivity.WORK;
            return false;
        }
        this.setVisibleStatusIfNone(VisibleCitizenStatus.HOUSE);
        this.desiredActivity = DesiredActivity.IDLE;
        return false;
    }

    private void setVisibleStatusIfNone(VisibleCitizenStatus status) {
        if (this.getCitizenData().getStatus() == null) {
            this.getCitizenData().setVisibleStatus(status);
        }
    }

    @Override
    @NotNull
    public DesiredActivity getDesiredActivity() {
        return this.desiredActivity;
    }

    private boolean shouldWorkWhileRaining() {
        return (Boolean)MineColonies.getConfig().getServer().workersAlwaysWorkInRain.get() != false || this.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.WORKING_IN_RAIN) > 0.0 || this.citizenColonyHandler.getWorkBuilding() != null && this.citizenColonyHandler.getWorkBuilding().hasModule(WorkerBuildingModule.class) && this.citizenColonyHandler.getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class).canWorkDuringTheRain();
    }

    @Override
    public float getRotationYaw() {
        return this.m_146908_();
    }

    @Override
    public float getRotationPitch() {
        return this.m_146909_();
    }

    @Override
    public boolean isDead() {
        return !this.m_6084_();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
        this.citizenSleepHandler = citizenSleepHandler;
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenItemHandler(ICitizenItemHandler citizenItemHandler) {
        this.citizenItemHandler = citizenItemHandler;
    }

    @Override
    public void setCitizenChatHandler(ICitizenChatHandler citizenChatHandler) {
        this.citizenChatHandler = citizenChatHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        if (this.handleInWallDamage(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.m_7639_();
        if (!this.checkIfValidDamageSource(damageSource, damage)) {
            return false;
        }
        if (this.getCitizenJobHandler().getColonyJob() != null && this.getCitizenJobHandler().getColonyJob().ignoresDamage(damageSource)) {
            return false;
        }
        return this.handleDamagePerformed(damageSource, damage, sourceEntity);
    }

    private boolean handleInWallDamage(@NotNull DamageSource damageSource) {
        if (damageSource.m_19385_().equals(DamageSource.f_19310_.m_19385_())) {
            TeleportHelper.teleportCitizen(this, this.f_19853_, this.m_20183_().m_7918_(0, 1, 0));
            return true;
        }
        return damageSource.m_19385_().equals(DamageSource.f_19310_.m_19385_()) && this.citizenSleepHandler.isAsleep() || Compatibility.isDynTreePresent() && damageSource.f_19326_.equals(Compatibility.getDynamicTreeDamage()) || this.m_20147_();
    }

    private boolean checkIfValidDamageSource(DamageSource source, float damage) {
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity instanceof EntityCitizen) {
            if (((EntityCitizen)sourceEntity).citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId()) {
                return false;
            }
            IColony attackerColony = ((EntityCitizen)sourceEntity).citizenColonyHandler.getColony();
            if (attackerColony != null && this.citizenColonyHandler.getColony() != null) {
                IPermissions permission = attackerColony.getPermissions();
                this.citizenColonyHandler.getColony().getPermissions().addPlayer(permission.getOwner(), permission.getOwnerName(), permission.getRank(4));
            }
        }
        if (sourceEntity instanceof Player) {
            if (sourceEntity instanceof ServerPlayer) {
                if (this.citizenColonyHandler.getColony().getRaiderManager().isRaided()) {
                    return false;
                }
                if (damage > 1.0f && !this.getCitizenColonyHandler().getColony().getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN)) {
                    return false;
                }
                if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
                    return IGuardBuilding.checkIfGuardShouldTakeDamage(this, (Player)sourceEntity);
                }
            } else {
                IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_());
                return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((Player)sourceEntity, Action.HURT_CITIZEN);
            }
        }
        return true;
    }

    public float m_6113_() {
        return (float)Math.min(0.5, (double)super.m_6113_());
    }

    private boolean handleDamagePerformed(@NotNull DamageSource damageSource, float damage, Entity sourceEntity) {
        boolean result;
        float damageInc = Math.min(damage, this.m_21233_() * 0.2f);
        if (this.citizenJobHandler.getColonyJob() instanceof JobNetherWorker && this.citizenData != null && damageSource.f_19326_ == "nether") {
            damageInc = damage;
        }
        if (!this.f_19853_.f_46443_ && !this.m_20145_()) {
            this.performMoveAway(sourceEntity);
        }
        this.m_21335_(damageSource.m_7639_());
        if (!this.f_19853_.f_46443_ && this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenData != null) {
            if (this.citizenJobHandler.getColonyJob() instanceof JobKnight && this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS) > 0.0 && this.m_217043_().m_188500_() < this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.BLOCK_ATTACKS)) {
                return false;
            }
            if (this.citizenData.getWorkBuilding() instanceof AbstractBuildingGuards && ((AbstractBuildingGuards)this.citizenData.getWorkBuilding()).shallRetrieveOnLowHealth() && (double)this.m_21223_() < (double)((int)this.m_21233_()) * 0.2) {
                damageInc = (float)((double)damageInc * (1.0 - this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_DAMAGE)));
            }
        }
        if ((result = super.m_6469_(damageSource, damageInc)) && damageSource.m_7639_() instanceof LivingEntity) {
            this.threatTable.addThreat((LivingEntity)damageSource.m_7639_(), (int)damageInc);
        }
        if (damageSource.m_19387_() || damageSource.m_19384_()) {
            return result;
        }
        if (!this.f_19853_.f_46443_) {
            this.citizenItemHandler.updateArmorDamage(damageInc);
            if (this.citizenData != null) {
                this.getCitizenData().getCitizenHappinessHandler().getModifier("damage").reset();
            }
        }
        return result;
    }

    private void performMoveAway(@Nullable Entity attacker) {
        this.getCitizenStatusHandler().setLatestStatus(new Component[]{Component.m_237115_((String)"com.minecolonies.coremod.status.avoiding")});
        if (!(attacker instanceof LivingEntity)) {
            if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
                this.moveAwayPath = this.getNavigation().moveAwayFromLivingEntity((Entity)this, 5.0, 1.1);
            }
            return;
        }
        this.currentlyFleeing = true;
        if (this.getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) {
            this.callForHelp(attacker, 900);
            return;
        }
        this.callForHelp(attacker, 90000);
        if (this.moveAwayPath == null || !this.moveAwayPath.isInProgress()) {
            this.moveAwayPath = this.getNavigation().moveAwayFromLivingEntity(attacker, 15.0, 1.1);
        }
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
        if (!(attacker instanceof LivingEntity) || !((Boolean)MineColonies.getConfig().getServer().citizenCallForHelp.get()).booleanValue() || this.callForHelpCooldown != 0) {
            return;
        }
        if (this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard && this.citizenJobHandler.getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return;
        }
        this.callForHelpCooldown = 100;
        ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
        for (ICitizenData entry : this.getCitizenColonyHandler().getColony().getCitizenManager().getCitizens()) {
            if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || entry.getId() == this.citizenData.getId() || BlockPosUtil.getDistanceSquared(entry.getEntity().get().m_20183_(), this.m_20183_()) >= (long)guardHelpRange || entry.getJob().getWorkerAI() == null) continue;
            ThreatTable table = ((EntityCitizen)entry.getEntity().get()).getThreatTable();
            table.addThreat((LivingEntity)attacker, 0);
            if (!((AbstractEntityAIGuard)((Object)entry.getJob().getWorkerAI())).canHelp()) continue;
            possibleGuards.add(entry.getEntity().get());
        }
        Collections.sort(possibleGuards, Comparator.comparingInt(guard -> (int)this.m_20183_().m_123331_((Vec3i)guard.m_20183_())));
        for (int i = 0; i < possibleGuards.size() && i <= 2; ++i) {
            ((AbstractEntityAIGuard)((Object)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getJob().getWorkerAI())).startHelpCitizen((LivingEntity)attacker);
        }
    }

    protected void m_7324_(Entity entity) {
        if (!this.citizenSleepHandler.isAsleep()) {
            super.m_7324_(entity);
        }
        if (!this.f_19853_.f_46443_ && entity instanceof AbstractEntityCitizen) {
            this.getCitizenDiseaseHandler().onCollission((AbstractEntityCitizen)entity);
        }
    }

    @Override
    public void onPlayerCollide(Player player) {
        super.onPlayerCollide(player);
        if (this.citizenJobHandler.getColonyJob() != null && this.citizenJobHandler.getColonyJob().getWorkerAI() instanceof AbstractEntityAIBasic && !this.citizenJobHandler.getColonyJob().isGuard()) {
            ((AbstractEntityAIBasic)((Object)this.citizenJobHandler.getColonyJob().getWorkerAI())).setDelay(60);
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        this.currentlyFleeing = false;
        if (this.citizenColonyHandler.getColony() != null && this.getCitizenData() != null) {
            this.citizenColonyHandler.getColony().getRaiderManager().onLostCitizen(this.getCitizenData());
            this.citizenExperienceHandler.dropExperience();
            this.m_142687_(Entity.RemovalReason.KILLED);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColony().getCitizenManager().updateModifier("death");
            }
            this.triggerDeathAchievement(damageSource, this.citizenJobHandler.getColonyJob());
            this.citizenChatHandler.notifyDeath(damageSource);
            if (!(this.citizenJobHandler.getColonyJob() instanceof AbstractJobGuard)) {
                this.citizenColonyHandler.getColony().getCitizenManager().updateCitizenMourn(this.citizenData, true);
            }
            this.getCitizenColonyHandler().getColony().getStatisticsManager().increment("death");
            if (!this.m_20145_()) {
                if (this.citizenColonyHandler.getColony().isCoordInColony(this.f_19853_, this.m_20183_())) {
                    this.getCitizenColonyHandler().getColony().getGraveManager().createCitizenGrave(this.f_19853_, this.m_20183_(), this.citizenData);
                } else {
                    InventoryUtils.dropItemHandler((IItemHandler)this.citizenData.getInventory(), this.f_19853_, (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
                }
            }
            if (this.citizenData.getJob() != null) {
                this.citizenData.getJob().onRemoval();
            }
            this.citizenColonyHandler.getColony().getCitizenManager().removeCivilian(this.getCitizenData());
            String deathCause = Component.m_237113_((String)damageSource.m_6157_((LivingEntity)this).getString()).getString().replaceFirst(this.m_5446_().getString(), "Citizen");
            this.citizenColonyHandler.getColony().getEventDescriptionManager().addEventDescription(new CitizenDiedEvent(this.m_20183_(), this.citizenData.getName(), deathCause));
        }
        super.m_6667_(damageSource);
    }

    private void triggerDeathAchievement(DamageSource source, IJob<?> job) {
        if (job != null) {
            job.triggerDeathAchievement(source, this);
        }
    }

    protected void m_5907_() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            this.citizenItemHandler.entityDropItem(itemstack);
        }
    }

    public int m_21230_() {
        if (this.citizenJobHandler.getColonyJob() instanceof JobKnight) {
            return (int)((double)super.m_21230_() * (1.0 + this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MELEE_ARMOR)));
        }
        if (this.citizenJobHandler.getColonyJob() instanceof JobRanger) {
            return (int)((double)super.m_21230_() * (1.0 + this.citizenColonyHandler.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.ARCHER_ARMOR)));
        }
        return super.m_21230_();
    }

    protected void m_7909_(float damage) {
        if (this.m_21120_(this.m_7655_()).m_41720_() instanceof ShieldItem) {
            if (this.m_21223_() > damage * 0.5f) {
                float blockDamage = CombatRules.m_19272_((float)(damage * 0.5f), (float)this.m_21230_(), (float)((float)this.m_21051_(Attributes.f_22285_).m_22135_()));
                this.m_21153_(this.m_21223_() - Math.max(0.5f, blockDamage));
            }
            this.citizenItemHandler.damageItemInHand(this.m_7655_(), (int)(damage * 0.5f));
        }
        super.m_7909_(damage);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            ICitizenData data = this.getCitizenData();
            if (data == null) {
                return super.getCapability(capability, facing);
            }
            InventoryCitizen inv = data.getInventory();
            return LazyOptional.of(() -> inv);
        }
        return super.getCapability(capability, facing);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EntityCitizen) {
            EntityCitizen citizen = (EntityCitizen)obj;
            return citizen.citizenColonyHandler.getColonyId() == this.citizenColonyHandler.getColonyId() && citizen.citizenId == this.citizenId;
        }
        return false;
    }

    public int hashCode() {
        if (this.citizenColonyHandler == null) {
            return super.hashCode();
        }
        return Objects.hash(this.citizenId, this.citizenColonyHandler.getColonyId());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.citizenColonyHandler.onCitizenRemoved();
        super.m_142687_(reason);
    }

    public Team m_5647_() {
        if (this.f_19853_ == null || this.f_19853_.f_46443_ && this.cachedTeamName == null) {
            return null;
        }
        if (this.cachedTeam != null) {
            return this.cachedTeam;
        }
        this.cachedTeam = this.f_19853_.f_46443_ ? this.f_19853_.m_6188_().m_83489_(this.cachedTeamName) : this.f_19853_.m_6188_().m_83489_(this.m_6302_());
        return this.cachedTeam;
    }

    public void m_6593_(@Nullable Component name) {
        if (this.citizenData != null && this.citizenColonyHandler.getColony() != null && name != null) {
            if (!name.getString().contains(this.citizenData.getName()) && (Integer)MineColonies.getConfig().getServer().allowGlobalNameChanges.get() >= 0) {
                if ((Integer)MineColonies.getConfig().getServer().allowGlobalNameChanges.get() == 0 && ((List)MineColonies.getConfig().getServer().specialPermGroup.get()).stream().noneMatch(owner -> owner.equals(this.citizenColonyHandler.getColony().getPermissions().getOwnerName()))) {
                    MessageUtils.format("com.minecolonies.coremod.citizen.rename.notallowed", new Object[0]).sendTo(this.citizenColonyHandler.getColony()).forAllPlayers();
                    return;
                }
                if (this.citizenColonyHandler.getColony() != null) {
                    for (ICitizenData citizen : this.citizenColonyHandler.getColony().getCitizenManager().getCitizens()) {
                        if (!citizen.getName().equals(name.getString())) continue;
                        MessageUtils.format("com.minecolonies.coremod.citizen.rename.same", new Object[0]).sendTo(this.citizenColonyHandler.getColony()).forAllPlayers();
                        return;
                    }
                    this.citizenData.setName(name.getString());
                    this.citizenData.markDirty();
                    super.m_6593_(name);
                }
                return;
            }
            super.m_6593_(name);
        }
    }

    public void m_21373_() {
        super.m_21373_();
    }

    protected void m_7581_(ItemEntity itemEntity) {
    }

    public boolean m_8023_() {
        return true;
    }

    @NotNull
    public BlockPos m_21534_() {
        @Nullable IBuilding homeBuilding = this.citizenColonyHandler.getHomeBuilding();
        if (homeBuilding != null) {
            return homeBuilding.getPosition();
        }
        if (this.citizenColonyHandler.getColony() != null && this.citizenColonyHandler.getColony().getBuildingManager().getTownHall() != null) {
            return this.citizenColonyHandler.getColony().getBuildingManager().getTownHall().getPosition();
        }
        return super.m_21534_();
    }

    public boolean m_7998_(Entity entity, boolean force) {
        if (entity instanceof SittingEntity || force) {
            return super.m_7998_(entity, force);
        }
        return false;
    }

    @Override
    public boolean isCurrentlyFleeing() {
        return this.currentlyFleeing;
    }

    @Override
    public void setFleeingState(boolean fleeing) {
        this.currentlyFleeing = fleeing;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
        return new ContainerCitizenInventory(id, inv, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    @Override
    public void setTexture() {
        super.setTexture();
    }

    public void m_6210_() {
        EntityDimensions afterEventSize;
        EntityDimensions oldSize = this.f_19815_;
        Pose pose = this.m_20089_();
        EntityDimensions newSize = this.m_6972_(pose);
        EntityEvent.Size sizeEvent = ForgeEventFactory.getEntitySizeForge((Entity)this, (Pose)pose, (EntityDimensions)newSize, (float)this.m_6380_(pose, newSize));
        this.f_19815_ = afterEventSize = sizeEvent.getNewSize();
        this.f_19816_ = sizeEvent.getNewEyeHeight();
        if (afterEventSize.f_20377_ < oldSize.f_20377_) {
            double d0 = (double)afterEventSize.f_20377_ / 2.0;
            this.m_20011_(new AABB(this.m_20185_() - d0, this.m_20186_(), this.m_20189_() - d0, this.m_20185_() + d0, this.m_20186_() + (double)afterEventSize.f_20378_, this.m_20189_() + d0));
        } else {
            AABB axisalignedbb = this.m_20191_();
            this.m_20011_(new AABB(axisalignedbb.f_82288_, axisalignedbb.f_82289_, axisalignedbb.f_82290_, axisalignedbb.f_82288_ + (double)afterEventSize.f_20377_, axisalignedbb.f_82289_ + (double)afterEventSize.f_20378_, axisalignedbb.f_82290_ + (double)afterEventSize.f_20377_));
            if (afterEventSize.f_20377_ > oldSize.f_20377_ && !this.f_19803_ && !this.f_19853_.f_46443_) {
                float f = oldSize.f_20377_ - afterEventSize.f_20377_;
                this.m_6478_(MoverType.SELF, new Vec3((double)f, 0.0, (double)f));
            }
        }
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions) {
        Network.getNetwork().sendToTrackingEntity(new PlaySoundForCitizenMessage(this.m_19879_(), soundEvent, this.m_5720_(), pos, this.f_19853_, length, repetitions), (Entity)this);
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions, float volume, float pitch) {
        Network.getNetwork().sendToTrackingEntity(new PlaySoundForCitizenMessage(this.m_19879_(), soundEvent, this.m_5720_(), pos, this.f_19853_, volume, pitch, length, repetitions), (Entity)this);
    }

    public boolean isActive() {
        return this.f_19853_.f_46443_ ? this.entityStatemachine.getState() == EntityState.ACTIVE_CLIENT : this.entityStatemachine.getState() == EntityState.ACTIVE_SERVER;
    }

    @Override
    public ThreatTable getThreatTable() {
        return this.threatTable;
    }

    private static enum EntityState implements IState
    {
        INIT,
        ACTIVE_SERVER,
        ACTIVE_CLIENT,
        INACTIVE;

    }
}

