/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.pathfinding.pathjobs;

import com.minecolonies.api.entity.pathfinding.WaterPathResult;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.entity.pathfinding.MNode;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.AbstractPathJob;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob {
    private static final int MIN_DISTANCE = 40;
    private static final int MAX_RANGE = 250;
    private final BlockPos hutLocation;
    @NotNull
    private final ArrayList<Tuple<BlockPos, BlockPos>> ponds;

    public PathJobFindWater(Level world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<Tuple<BlockPos, BlockPos>> ponds, LivingEntity entity) {
        super(world, start, start, range, new WaterPathResult(), entity);
        this.ponds = new ArrayList<Tuple<BlockPos, BlockPos>>(ponds);
        this.hutLocation = home;
    }

    private static double squareDistance(@NotNull BlockPos currentPond, @NotNull BlockPos nextPond) {
        return currentPond.m_123331_((Vec3i)nextPond);
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(@NotNull BlockPos pos) {
        int dx = pos.m_123341_() - this.hutLocation.m_123341_();
        int dy = pos.m_123342_() - this.hutLocation.m_123342_();
        int dz = pos.m_123343_() - this.hutLocation.m_123343_();
        return (double)(Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) * 0.501;
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (PathJobFindWater.squareDistance(this.hutLocation, n.pos) > 250.0) {
            return false;
        }
        if (this.isWater(n)) {
            this.getResult().parent = n.pos;
            this.getResult().isEmpty = this.ponds.isEmpty();
            return true;
        }
        return false;
    }

    private boolean isWater(@NotNull MNode n) {
        if (n.parent == null) {
            return false;
        }
        if (this.world.m_8055_(n.pos).m_60734_() != Blocks.f_49990_ && this.world.m_8055_(n.pos.m_7495_()).m_60734_() != Blocks.f_49990_) {
            if (n.pos.m_123341_() == n.parent.pos.m_123341_()) {
                int dz = n.pos.m_123343_() > n.parent.pos.m_123343_() ? 1 : -1;
                return Pond.checkWater(this.world, n.pos.m_7918_(0, -1, dz), this.getResult()) || Pond.checkWater(this.world, n.pos.m_7918_(-1, -1, 0), this.getResult()) || Pond.checkWater(this.world, n.pos.m_7918_(1, -1, 0), this.getResult());
            }
            int dx = n.pos.m_123341_() > n.parent.pos.m_123341_() ? 1 : -1;
            return Pond.checkWater(this.world, n.pos.m_7918_(dx, -1, 0), this.getResult()) || Pond.checkWater(this.world, n.pos.m_7918_(0, -1, -1), this.getResult()) || Pond.checkWater(this.world, n.pos.m_7918_(0, -1, 1), this.getResult());
        }
        return this.getResult().pond != null && !this.ponds.contains(new Tuple<BlockPos, BlockPos>(n.pos, n.parent.pos)) && !PathJobFindWater.pondsAreNear(this.ponds, n.pos);
    }

    private static Predicate<BlockPos> generateDistanceFrom(int range, @NotNull BlockPos newPond) {
        return pond -> PathJobFindWater.squareDistance(pond, newPond) < (double)range;
    }

    private static boolean pondsAreNear(@NotNull ArrayList<Tuple<BlockPos, BlockPos>> ponds, @NotNull BlockPos newPond) {
        if (ponds.isEmpty()) {
            return false;
        }
        @NotNull Predicate<BlockPos> compare = PathJobFindWater.generateDistanceFrom(40, newPond);
        return ponds.stream().anyMatch(p -> compare.test((BlockPos)p.getB()));
    }

    @Override
    protected double getNodeResultScore(MNode n) {
        return 0.0;
    }
}

