/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final int GREEN_OVERLAY = -16711936;
    private static final String NBT_START_POS = "minecolonies:start_pos";
    private static final String NBT_END_POS = "minecolonies:end_pos";

    public ItemScepterLumberjack(Item.Properties properties) {
        super("scepterlumberjack", properties.m_41487_(1));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.FAIL;
        }
        ItemStack scepter = context.m_43723_().m_21120_(context.m_43724_());
        MessageUtils.format("item.minecolonies.scepterlumberjack.usedstart", new Object[0]).sendTo(context.m_43723_());
        if (this.setPosition(scepter.m_41784_(), NBT_START_POS, context.m_8083_(), context.m_43723_())) {
            this.storeRestrictedArea(context.m_43723_(), scepter.m_41784_(), context.m_43725_());
        }
        return InteractionResult.FAIL;
    }

    public boolean m_6777_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player) {
        if (!world.f_46443_) {
            ItemStack tool = player.m_21205_();
            MessageUtils.format("item.minecolonies.scepterlumberjack.usedend", new Object[0]).sendTo(player);
            if (this.setPosition(tool.m_41784_(), NBT_END_POS, pos, player)) {
                this.storeRestrictedArea(player, tool.m_41784_(), world);
            }
        }
        return false;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    private void storeRestrictedArea(Player player, CompoundTag compound, Level worldIn) {
        int maxVolume;
        int maxZ;
        int distZ;
        int maxY;
        int distY;
        BlockPos startRestriction = BlockPosUtil.read(compound, NBT_START_POS);
        BlockPos endRestriction = BlockPosUtil.read(compound, NBT_END_POS);
        int minX = Math.min(startRestriction.m_123341_(), endRestriction.m_123341_());
        int minY = Math.min(startRestriction.m_123342_(), endRestriction.m_123342_());
        int minZ = Math.min(startRestriction.m_123343_(), endRestriction.m_123343_());
        int maxX = Math.max(startRestriction.m_123341_(), endRestriction.m_123341_());
        int distX = maxX - minX;
        int volume = distX * (distY = (maxY = Math.max(startRestriction.m_123342_(), endRestriction.m_123342_())) - minY) * (distZ = (maxZ = Math.max(startRestriction.m_123343_(), endRestriction.m_123343_())) - minZ);
        if (volume > (maxVolume = (int)Math.floor(2.0 * Math.pow(50.0, 3.0)))) {
            MessageUtils.format("item.minecolonies.scepterlumberjack.restrictiontoobig", volume, maxVolume).sendTo(player);
            return;
        }
        MessageUtils.format("item.minecolonies.scepterlumberjack.restrictionset", minX, maxX, minY, maxY, minZ, maxZ, volume, maxVolume).sendTo(player);
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.m_128451_("id"), worldIn);
        BlockPos hutPos = BlockPosUtil.read(compound, "pos");
        BuildingLumberjack hut = colony.getBuildingManager().getBuilding(hutPos, BuildingLumberjack.class);
        if (hut == null) {
            return;
        }
        hut.setRestrictedArea(startRestriction, endRestriction);
    }

    private boolean setPosition(CompoundTag compound, String key, BlockPos pos, Player player) {
        if (compound.m_128441_(key) && BlockPosUtil.read(compound, key).equals((Object)pos)) {
            player.m_150109_().m_8016_(player.m_150109_().f_35977_);
            return false;
        }
        BlockPosUtil.write(compound, key, pos);
        return compound.m_128441_(NBT_END_POS) && compound.m_128441_(NBT_START_POS);
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        IBuildingView iBuildingView;
        CompoundTag compound = stack.m_41784_();
        IColonyView colony = IColonyManager.getInstance().getColonyView(compound.m_128451_("id"), (ResourceKey<Level>)world.m_46472_());
        if (colony != null && (iBuildingView = colony.getBuilding(BlockPosUtil.read(compound, "pos"))) instanceof BuildingLumberjack.View) {
            BuildingLumberjack.View hut = (BuildingLumberjack.View)iBuildingView;
            BlockPos startRestriction = compound.m_128441_(NBT_START_POS) ? BlockPosUtil.read(compound, NBT_START_POS) : hut.getStartRestriction();
            BlockPos endRestriction = compound.m_128441_(NBT_END_POS) ? BlockPosUtil.read(compound, NBT_END_POS) : hut.getEndRestriction();
            AABB bounds = new AABB(startRestriction, endRestriction.m_7918_(1, 1, 1)).m_82400_(1.0);
            return Collections.singletonList(new IBlockOverlayItem.OverlayBox(bounds, -16711936, 0.02f, true));
        }
        return Collections.emptyList();
    }
}

