/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.events.forge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.events.IDropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.IFireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.ILightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.SimpleEvent;
import net.mehvahdjukaar.moonlight.api.events.forge.DropItemOnDeathEvent;
import net.mehvahdjukaar.moonlight.api.events.forge.FireConsumeBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.forge.LightningStruckBlockEvent;
import net.mehvahdjukaar.moonlight.api.events.forge.VillagerBrainEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class MoonlightEventsHelperImpl {
    private static final Map<Class<? extends SimpleEvent>, List<Consumer<? extends SimpleEvent>>> LISTENERS = new ConcurrentHashMap<Class<? extends SimpleEvent>, List<Consumer<? extends SimpleEvent>>>();

    public static <T extends SimpleEvent> void addListener(Consumer<T> listener, Class<T> eventClass) {
        if (eventClass == IVillagerBrainEvent.class) {
            Consumer<VillagerBrainEvent> eventConsumer = e -> listener.accept(e);
            MinecraftForge.EVENT_BUS.addListener(eventConsumer);
        } else if (eventClass == IFireConsumeBlockEvent.class) {
            Consumer<FireConsumeBlockEvent> eventConsumer = e -> listener.accept(e);
            MinecraftForge.EVENT_BUS.addListener(eventConsumer);
        } else if (eventClass == IDropItemOnDeathEvent.class) {
            Consumer<DropItemOnDeathEvent> eventConsumer = e -> listener.accept(e);
            MinecraftForge.EVENT_BUS.addListener(eventConsumer);
        } else if (eventClass == ILightningStruckBlockEvent.class) {
            Consumer<LightningStruckBlockEvent> eventConsumer = e -> listener.accept(e);
            MinecraftForge.EVENT_BUS.addListener(eventConsumer);
        } else {
            LISTENERS.computeIfAbsent(eventClass, ev -> new ArrayList()).add(listener);
        }
    }

    public static <T extends SimpleEvent> void postEvent(T event, Class<T> eventClass) {
        if (event instanceof Event) {
            Event e2 = (Event)event;
            MinecraftForge.EVENT_BUS.post(e2);
        } else {
            List<Consumer<? extends SimpleEvent>> consumers = LISTENERS.get(eventClass);
            if (consumers != null) {
                consumers.forEach(e -> e.accept(event));
            }
        }
    }
}

