/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.network;

import java.util.Objects;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientBoundSpawnCustomEntityMessage
implements Message {
    private final Entity entity;
    private final int typeId;
    private final int entityId;
    private final UUID uuid;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final byte pitch;
    private final byte yaw;
    private final byte headYaw;
    private final int velX;
    private final int velY;
    private final int velZ;
    private final FriendlyByteBuf buf;

    public ClientBoundSpawnCustomEntityMessage(Entity e) {
        this.entity = e;
        this.typeId = Registry.f_122826_.m_7447_((Object)e.m_6095_());
        this.entityId = e.m_19879_();
        this.uuid = e.m_20148_();
        this.posX = e.m_20185_();
        this.posY = e.m_20186_();
        this.posZ = e.m_20189_();
        this.pitch = (byte)Mth.m_14143_((float)(e.m_146909_() * 256.0f / 360.0f));
        this.yaw = (byte)Mth.m_14143_((float)(e.m_146908_() * 256.0f / 360.0f));
        this.headYaw = (byte)(e.m_6080_() * 256.0f / 360.0f);
        Vec3 vec3d = e.m_20184_();
        double d1 = Mth.m_14008_((double)vec3d.f_82479_, (double)-3.9, (double)3.9);
        double d2 = Mth.m_14008_((double)vec3d.f_82480_, (double)-3.9, (double)3.9);
        double d3 = Mth.m_14008_((double)vec3d.f_82481_, (double)-3.9, (double)3.9);
        this.velX = (int)(d1 * 8000.0);
        this.velY = (int)(d2 * 8000.0);
        this.velZ = (int)(d3 * 8000.0);
        this.buf = null;
    }

    public ClientBoundSpawnCustomEntityMessage(FriendlyByteBuf buf) {
        this.entity = null;
        this.typeId = buf.m_130242_();
        this.entityId = buf.readInt();
        this.uuid = new UUID(buf.readLong(), buf.readLong());
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.pitch = buf.readByte();
        this.yaw = buf.readByte();
        this.headYaw = buf.readByte();
        this.velX = buf.readShort();
        this.velY = buf.readShort();
        this.velZ = buf.readShort();
        this.buf = new FriendlyByteBuf(buf.copy());
        buf.clear();
    }

    @Override
    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130130_(this.typeId);
        buf.writeInt(this.entityId);
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeByte((int)this.pitch);
        buf.writeByte((int)this.yaw);
        buf.writeByte((int)this.headYaw);
        buf.writeShort(this.velX);
        buf.writeShort(this.velY);
        buf.writeShort(this.velZ);
        Entity entity = this.entity;
        if (entity instanceof IExtraClientSpawnData) {
            IExtraClientSpawnData spawnData = (IExtraClientSpawnData)entity;
            spawnData.writeSpawnData(buf);
        }
    }

    @Override
    public void handle(ChannelHandler.Context context) {
        Level world;
        Entity e;
        EntityType type = (EntityType)Registry.f_122826_.m_7942_(this.typeId);
        if (type != null && (e = type.m_20615_(world = context.getSender().m_9236_())) != null) {
            e.m_217006_(this.posX, this.posY, this.posZ);
            e.m_19890_(this.posX, this.posY, this.posZ, (float)(this.yaw * 360) / 256.0f, (float)(this.pitch * 360) / 256.0f);
            e.m_5616_((float)(this.headYaw * 360) / 256.0f);
            e.m_5618_((float)(this.headYaw * 360) / 256.0f);
            e.m_20234_(this.entityId);
            e.m_20084_(this.uuid);
            Objects.requireNonNull(ClientLevel.class);
            this.clientSideStuff(world, e);
            e.m_6001_((double)this.velX / 8000.0, (double)this.velY / 8000.0, (double)this.velZ / 8000.0);
            if (e instanceof IExtraClientSpawnData) {
                IExtraClientSpawnData spawnData = (IExtraClientSpawnData)e;
                spawnData.readSpawnData(this.buf);
            }
        }
        this.buf.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientSideStuff(Level world, Entity e) {
        ((ClientLevel)world).m_104627_(this.entityId, e);
    }
}

