/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.plugin.byg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import yamahari.ilikewood.plugin.byg.OhTheBiomesYoullGoWoodTypes;
import yamahari.ilikewood.plugin.byg.util.Util;
import yamahari.ilikewood.plugin.byg.util.resources.WoodenLogResource;
import yamahari.ilikewood.plugin.byg.util.resources.WoodenPlanksResource;
import yamahari.ilikewood.plugin.byg.util.resources.WoodenSlabResource;
import yamahari.ilikewood.plugin.byg.util.resources.WoodenStrippedLogResource;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.resource.IWoodenResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenSlabResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class OhTheBiomesYoullGoWoodenResources {
    public static final Map<IWoodType, IWoodenPlanksResource> PLANKS;
    public static final Map<IWoodType, IWoodenLogResource> LOGS;
    public static final Map<IWoodType, IWoodenStrippedLogResource> STRIPPED_LOGS;
    public static final Map<IWoodType, IWoodenSlabResource> SLABS;
    public static final Map<IWoodType, IWoodenResource> BOOKSHELFS;
    public static final Map<IWoodType, IWoodenResource> CRAFTING_TABLES;

    private OhTheBiomesYoullGoWoodenResources() {
    }

    private static Map<IWoodType, IWoodenResource> getResource(WoodenBlockType blockType) {
        HashMap bookshelfs = new HashMap();
        OhTheBiomesYoullGoWoodTypes.getAll().forEach(woodType -> bookshelfs.put(woodType, () -> new ResourceLocation("byg", Util.toRegistryName(woodType.getName(), blockType.getName()))));
        return Collections.unmodifiableMap(bookshelfs);
    }

    private static String getLogPostFix(IWoodType woodType) {
        if (woodType.equals(OhTheBiomesYoullGoWoodTypes.EMBUR)) {
            return "pedu";
        }
        return Arrays.asList(OhTheBiomesYoullGoWoodTypes.BULBIS, OhTheBiomesYoullGoWoodTypes.IMPARIUS, OhTheBiomesYoullGoWoodTypes.SYTHIAN).contains(woodType) ? "stem" : "log";
    }

    static {
        BOOKSHELFS = OhTheBiomesYoullGoWoodenResources.getResource(WoodenBlockType.BOOKSHELF);
        CRAFTING_TABLES = OhTheBiomesYoullGoWoodenResources.getResource(WoodenBlockType.CRAFTING_TABLE);
        HashMap planks = new HashMap();
        HashMap logs = new HashMap();
        HashMap strippedLogs = new HashMap();
        HashMap slabs = new HashMap();
        OhTheBiomesYoullGoWoodTypes.getAll().forEach(woodType -> {
            String logPostFix = OhTheBiomesYoullGoWoodenResources.getLogPostFix(woodType);
            ResourceLocation planksResource = new ResourceLocation("byg", Util.toRegistryName(woodType.getName(), "planks"));
            ResourceLocation logResource = new ResourceLocation("byg", Util.toRegistryName(woodType.getName(), logPostFix));
            ResourceLocation strippedLogResource = new ResourceLocation("byg", Util.toRegistryName("stripped", woodType.getName(), logPostFix));
            ResourceLocation slabResource = new ResourceLocation("byg", Util.toRegistryName(woodType.getName(), "slab"));
            ResourceLocation planksTexture = new ResourceLocation(planksResource.m_135827_(), Util.toPath("block", woodType.getName(), "planks"));
            planks.put(woodType, new WoodenPlanksResource(planksTexture, planksResource, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76362_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
            if (woodType.equals(OhTheBiomesYoullGoWoodTypes.GREEN_ENCHANTED) || woodType.equals(OhTheBiomesYoullGoWoodTypes.BLUE_ENCHANTED) || woodType.equals(OhTheBiomesYoullGoWoodTypes.EMBUR)) {
                logs.put(woodType, new WoodenLogResource(new ResourceLocation(logResource.m_135827_(), Util.toPath("block", woodType.getName(), "log_top")), new ResourceLocation(logResource.m_135827_(), Util.toPath("block", woodType.getName(), "log")), logResource, new IWoodenLogResource.SideTextureProperties(true, true, 10)));
            } else {
                logs.put(woodType, new WoodenLogResource(new ResourceLocation(logResource.m_135827_(), Util.toPath("block", woodType.getName(), "log_top")), new ResourceLocation(logResource.m_135827_(), Util.toPath("block", woodType.getName(), "log")), logResource));
            }
            if (!woodType.equals(OhTheBiomesYoullGoWoodTypes.IMPARIUS)) {
                strippedLogs.put(woodType, new WoodenStrippedLogResource(new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", woodType.getName(), "stripped_log_top")), new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", woodType.getName(), "stripped_log")), strippedLogResource));
            }
            slabs.put(woodType, new WoodenSlabResource(planksTexture, planksTexture, planksTexture, slabResource));
        });
        PLANKS = Collections.unmodifiableMap(planks);
        LOGS = Collections.unmodifiableMap(logs);
        STRIPPED_LOGS = Collections.unmodifiableMap(strippedLogs);
        SLABS = Collections.unmodifiableMap(slabs);
    }
}

