/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.data.util;

import com.molybdenum.alloyed.Alloyed;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class BlockStateUtils {
    public static <T extends Block> void existingModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(prov.modLoc("block/" + ctx.getName())));
    }

    public static class Unique {
        public static <T extends Block> void steelCatwalkBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            String texture = "alloyed:block/steel_catwalk";
            String lowerParent = "alloyed:block/catwalk_bottom";
            String upperParent = "alloyed:block/catwalk_top";
            String railUpperParent = "alloyed:block/catwalk_rail_upper";
            String railLowerParent = "alloyed:block/catwalk_rail_lower";
            String path = "block/steel_catwalk/";
            BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_bottom", lowerParent)).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_top", upperParent)).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder railUpper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_rail_upper", railUpperParent)).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            BlockModelBuilder railLower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_rail_lower", railLowerParent)).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)lower).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)upper).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).end();
            for (boolean isBottom : Iterate.trueAndFalse) {
                BlockModelBuilder currentModel = isBottom ? railLower : railUpper;
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            }
        }

        public static <T extends Block> void steelVerticalSlabBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            ResourceLocation texture = prov.modLoc("block/steel_sheet_metal");
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", texture);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", texture);
            int y = 0;
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }

        public static <T extends Block> void steelBarsBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            ResourceLocation barTexture = Alloyed.asResource("block/steel_bars/block");
            ResourceLocation postTexture = Alloyed.asResource("block/steel_bars/post");
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
            BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postTexture)).texture("particle", postTexture)).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postTexture)).texture("particle", postTexture)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
        }

        public static <T extends Block> void steelMeshFenceBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
                String suffix;
                String baseDirectory = "block/steel_mesh_fence/";
                boolean north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
                boolean south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
                boolean east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
                boolean west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
                int sides = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
                int rotationY = -1;
                switch (sides) {
                    case 4: {
                        suffix = "four_way";
                        break;
                    }
                    case 3: {
                        suffix = "tri_way";
                        rotationY = north ? (south ? (east ? 90 : -90) : 0) : 180;
                        break;
                    }
                    case 2: {
                        if (north && south || east && west) {
                            suffix = "straight";
                            rotationY = east ? 0 : 90;
                            break;
                        }
                        suffix = "corner";
                        rotationY = north ? (east ? 0 : -90) : (east ? 90 : 180);
                        break;
                    }
                    case 1: {
                        suffix = "end";
                        rotationY = north ? -90 : (south ? 90 : (east ? 0 : 180));
                        break;
                    }
                    case 0: {
                        suffix = "post";
                        break;
                    }
                    default: {
                        suffix = "post";
                    }
                }
                ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)prov.models().getExistingFile(Alloyed.asResource(baseDirectory + suffix)));
                if (rotationY != -1) {
                    builder = builder.rotationY(rotationY);
                }
                return builder.build();
            });
        }
    }
}

