/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.shaded.moonconfig.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hypherionmc.shaded.moonconfig.core.Config;
import me.hypherionmc.shaded.moonconfig.core.ConfigFormat;
import me.hypherionmc.shaded.moonconfig.core.utils.ConfigWrapper;
import me.hypherionmc.shaded.moonconfig.core.utils.TransformingMap;
import me.hypherionmc.shaded.moonconfig.core.utils.TransformingSet;

class CheckedConfig
extends ConfigWrapper<Config> {
    CheckedConfig(Config config) {
        super(config);
        config.valueMap().forEach((k, v) -> this.checkValue(v));
    }

    @Override
    public Config checked() {
        return this;
    }

    @Override
    public <T> T set(List<String> path, Object value) {
        return super.set(path, this.checkedValue(value));
    }

    @Override
    public boolean add(List<String> path, Object value) {
        return super.add(path, this.checkedValue(value));
    }

    @Override
    public Map<String, Object> valueMap() {
        return new TransformingMap<String, Object, Object>(super.valueMap(), v -> v, this::checkedValue, o -> o);
    }

    @Override
    public Set<? extends Config.Entry> entrySet() {
        return new TransformingSet<Config.Entry, Config.Entry>(super.entrySet(), v -> v, this::checkedValue, o -> o);
    }

    @Override
    public String toString() {
        return "checked of " + this.config;
    }

    private void checkValue(Object value) {
        ConfigFormat<?> format = this.configFormat();
        if (value != null && !format.supportsType(value.getClass())) {
            throw new IllegalArgumentException("Unsupported value type: " + value.getClass().getTypeName());
        }
        if (value == null && !format.supportsType(null)) {
            throw new IllegalArgumentException("Null values aren't supported by this configuration.");
        }
        if (value instanceof Config) {
            ((Config)value).valueMap().forEach((k, v) -> this.checkValue(v));
        }
    }

    private <T> T checkedValue(T value) {
        this.checkValue(value);
        return value;
    }
}

