/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus;

import com.google.common.collect.ImmutableList;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.itsmeow.betteranimalsplus.client.dumb.SafeSyncThing;
import dev.itsmeow.betteranimalsplus.common.CommonEventHandler;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityTypeContainerBAPTameable;
import dev.itsmeow.betteranimalsplus.forge.BetterAnimalsPlusModImpl;
import dev.itsmeow.betteranimalsplus.imdlib.IMDLib;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModBlockEntities;
import dev.itsmeow.betteranimalsplus.init.ModBlocks;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import dev.itsmeow.betteranimalsplus.init.ModResources;
import dev.itsmeow.betteranimalsplus.init.ModSoundEvents;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.init.ModWorldGen;
import dev.itsmeow.betteranimalsplus.network.ClientConfigurationPacket;
import dev.itsmeow.betteranimalsplus.network.ClientRequestBAMPacket;
import dev.itsmeow.betteranimalsplus.network.HonkPacket;
import dev.itsmeow.betteranimalsplus.network.ServerNoBAMPacket;
import dev.itsmeow.betteranimalsplus.network.StupidDevPacket;
import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterAnimalsPlusMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final NetworkChannel HANDLER = NetworkChannel.create((ResourceLocation)new ResourceLocation("betteranimalsplus", "main_channel"));
    private static final ImmutableList<UUID> DEVS = ImmutableList.of((Object)UUID.fromString("81d9726a-56d4-4419-9a2a-be1d7f7f7ef1"), (Object)UUID.fromString("403f2fd4-f8a2-4608-a0b8-534da4184735"), (Object)UUID.fromString("4605663e-fb07-4843-98c5-73adbfb2625e"));
    public static final CreativeModeTab TAB = BetterAnimalsPlusMod.getPlatformTab();

    public static void construct() {
        IMDLib.setRegistry("betteranimalsplus");
        ModResources.Tags.Blocks.loadTags();
        ModResources.Tags.Items.loadTags();
        ModSoundEvents.init();
        ModEntities.init();
        ModBlocks.init();
        ModItems.init();
        ModBlockEntities.init();
        ModTriggers.register();
        LOGGER.info("Injecting super coyotes...");
        HANDLER.register(ClientConfigurationPacket.class, ClientConfigurationPacket::encode, ClientConfigurationPacket::decode, ClientConfigurationPacket.Handler::handle);
        HANDLER.register(ServerNoBAMPacket.class, (pkt, buf) -> {}, buf -> new ServerNoBAMPacket(), (pkt, ctx) -> {
            if (((NetworkManager.PacketContext)ctx.get()).getEnvironment() == Env.SERVER) {
                ((NetworkManager.PacketContext)ctx.get()).queue(() -> BetterAnimalsPlusMod.lambda$construct$2((Supplier)ctx));
            }
        });
        HANDLER.register(ClientRequestBAMPacket.class, (pkt, buf) -> {}, buf -> new ClientRequestBAMPacket(), (pkt, ctx) -> {
            if (((NetworkManager.PacketContext)ctx.get()).getEnvironment() == Env.CLIENT) {
                ((NetworkManager.PacketContext)ctx.get()).queue(() -> {
                    if (!ModPlatformEvents.isLoaded("betteranimals")) {
                        HANDLER.sendToServer((Object)new ServerNoBAMPacket());
                    }
                });
            }
        });
        HANDLER.register(StupidDevPacket.class, StupidDevPacket::encode, StupidDevPacket::decode, StupidDevPacket.Handler::handle);
        HANDLER.register(HonkPacket.class, HonkPacket::encode, HonkPacket::decode, HonkPacket.Handler::handle);
        PlayerEvent.PLAYER_JOIN.register(BetterAnimalsPlusMod::onPlayerJoin);
        PlayerEvent.PLAYER_QUIT.register(BetterAnimalsPlusMod::onPlayerLeave);
        CommonEventHandler.init();
    }

    public static void init(Consumer<Runnable> enqueue) {
        ModWorldGen.init(enqueue);
        LOGGER.info("Overspawning lammergeiers...");
    }

    public static boolean isDev(UUID uuid) {
        return DEVS.contains((Object)uuid);
    }

    public static boolean isDev(Player player) {
        return BetterAnimalsPlusMod.isDev(player.m_36316_().getId());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CreativeModeTab getPlatformTab() {
        return BetterAnimalsPlusModImpl.getPlatformTab();
    }

    public static void onPlayerJoin(ServerPlayer player) {
        HANDLER.sendToPlayer(player, (Object)new ClientConfigurationPacket(ModEntities.COYOTE.getCustomConfiguration().getBoolean("hostile_during_daytime"), ModEntities.getEntities().values().stream().filter(c -> c instanceof EntityTypeContainerBAPTameable).map(c -> (EntityTypeContainerBAPTameable)c).collect(Collectors.toMap(EntityTypeContainer::getEntityName, EntityTypeContainerBAPTameable::getTameItems))));
        HANDLER.sendToPlayer(player, (Object)new ClientRequestBAMPacket());
        for (UUID devId : DEVS) {
            HANDLER.sendToPlayer(player, (Object)new StupidDevPacket(SafeSyncThing.get(devId), devId));
        }
    }

    public static void onPlayerLeave(ServerPlayer player) {
        for (UUID devId : DEVS) {
            HANDLER.sendToPlayer(player, (Object)new StupidDevPacket(SafeSyncThing.DumbOptions.OFF, devId));
        }
    }

    private static /* synthetic */ void lambda$construct$2(Supplier ctx) {
        ModTriggers.NO_BAM.trigger((ServerPlayer)((NetworkManager.PacketContext)ctx.get()).getPlayer());
    }
}

