/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registries;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBarracuda;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBear;
import dev.itsmeow.betteranimalsplus.common.entity.EntityBoar;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCoyote;
import dev.itsmeow.betteranimalsplus.common.entity.EntityCrab;
import dev.itsmeow.betteranimalsplus.common.entity.EntityFeralWolf;
import dev.itsmeow.betteranimalsplus.common.entity.EntityLamprey;
import dev.itsmeow.betteranimalsplus.common.entity.EntityOctopus;
import dev.itsmeow.betteranimalsplus.common.entity.EntityPiranha;
import dev.itsmeow.betteranimalsplus.common.entity.EntitySquirrel;
import dev.itsmeow.betteranimalsplus.common.entity.util.IHaveHunger;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntitySharkBase;
import dev.itsmeow.betteranimalsplus.common.forge.CommonEventHandlerImpl;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IBucketable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModLootTables;
import dev.itsmeow.betteranimalsplus.init.ModTriggers;
import dev.itsmeow.betteranimalsplus.mixin.MobAccessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;

public class CommonEventHandler {
    public static final Set<Predicate<Entity>> NO_ATTACKED_DROPS = new HashSet<Predicate<Entity>>();
    public static final Multimap<ResourceLocation, ResourceLocation> LOOT_TABLE_INJECTIONS;

    public static void init() {
        EntityEvent.LIVING_DEATH.register(CommonEventHandler::entityDeath);
        EntityEvent.LIVING_HURT.register(CommonEventHandler::entityAttack);
        EntityEvent.ADD.register(CommonEventHandler::entityAdd);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(CommonEventHandler::rightClickBlock);
        InteractionEvent.RIGHT_CLICK_ITEM.register(CommonEventHandler::rightClickItem);
        CommonEventHandler.registerPlatformEvents();
    }

    public static EventResult entityDeath(LivingEntity entity, DamageSource source) {
        if (source.m_7640_() instanceof EntityBoar && ModEntities.BOAR.getCustomConfiguration().getBoolean("nerf_options/breed_from_kill")) {
            EntityBoar boar = (EntityBoar)source.m_7640_();
            boar.m_27595_(null);
            BlockPos p = boar.m_20183_();
            boar.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, (double)p.m_123341_(), (double)p.m_123342_(), (double)p.m_123343_(), 0.0, (double)0.05f, 0.0);
        } else if (source.m_7640_() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)source.m_7640_();
            if (entity instanceof EntityBear || entity instanceof PolarBear) {
                if (player.m_21205_().m_41619_()) {
                    ModTriggers.PUNCH_BEAR_DEATH.trigger(player);
                }
            } else if (entity instanceof EntitySquirrel && !player.m_8960_().m_135996_(player.f_8924_.m_129889_().m_136041_(new ResourceLocation("betteranimalsplus:squirrel_kill_100"))).m_8193_()) {
                CommonEventHandler.setSquirrelKills((Player)player, oldValue -> {
                    int newValue = oldValue + 1;
                    if (newValue > 100) {
                        newValue = 1;
                    }
                    if (ModTriggers.SQUIRREL_KILL_TRIGGERS.containsKey(newValue)) {
                        ModTriggers.SQUIRREL_KILL_TRIGGERS.get(newValue).trigger(player);
                    }
                    return newValue;
                });
            }
        } else if (source.m_7639_() instanceof EntityOctopus) {
            Player p;
            EntityOctopus octo = (EntityOctopus)source.m_7639_();
            if (octo.friend != null && (p = octo.f_19853_.m_46003_(octo.friend)) instanceof ServerPlayer && p.m_21232_() == entity) {
                ModTriggers.OCTOPUS_SAVE_PLAYER.trigger((ServerPlayer)octo.f_19853_.m_46003_(octo.friend));
            }
        }
        if (source.m_7640_() instanceof IHaveHunger) {
            ((IHaveHunger)source.m_7640_()).resetHunger();
        }
        return EventResult.pass();
    }

    public static EventResult rightClickBlock(Player player, InteractionHand hand, BlockPos pos, Direction direction) {
        BlockEntity te;
        if (player.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50131_ && player instanceof ServerPlayer && (te = player.f_19853_.m_7702_(pos)) instanceof JukeboxBlockEntity) {
            JukeboxBlockEntity box = (JukeboxBlockEntity)te;
            Item held = player.m_21120_(hand).m_41720_();
            Item boxItem = box.m_59524_().m_41720_();
            boolean added = box.m_59524_().m_41619_();
            CommonEventHandler.onDiskUse(added, (ServerPlayer)player, added ? held : boxItem);
        }
        return EventResult.pass();
    }

    public static CompoundEventResult<ItemStack> rightClickItem(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ResourceLocation reg = Registries.get((String)"betteranimalsplus").get(Registry.f_122904_).getId((Object)stack.m_41720_());
        if (reg != null && reg.m_135815_().equals("portable_jukebox") && player instanceof ServerPlayer && stack.m_41737_("Disc") != null) {
            Item item = ItemStack.m_41712_((CompoundTag)stack.m_41737_("Disc")).m_41720_();
            CommonEventHandler.onDiskUse(player.m_6047_(), (ServerPlayer)player, item);
        }
        return CompoundEventResult.pass();
    }

    private static void onDiskUse(boolean added, ServerPlayer player, Item item) {
        block5: {
            if (!(item instanceof RecordItem)) break block5;
            if (added) {
                List crabs = player.m_20193_().m_45976_(EntityCrab.class, player.m_20191_().m_82400_(50.0));
                if (crabs.size() > 0) {
                    ModTriggers.CRAB_DANCE.trigger(player);
                }
                for (EntityCrab crab : crabs) {
                    crab.crabRave();
                }
            } else {
                List crabs = player.m_20193_().m_45976_(EntityCrab.class, player.m_20191_().m_82400_(100.0));
                for (EntityCrab crab : crabs) {
                    crab.unCrabRave();
                }
            }
        }
    }

    public static EventResult entityAttack(LivingEntity entity, DamageSource source, float damage) {
        if (source.m_7639_() instanceof ServerPlayer && (entity instanceof EntityBear || entity instanceof PolarBear) && ((ServerPlayer)source.m_7639_()).m_21205_().m_41619_()) {
            ModTriggers.PUNCH_BEAR.trigger((ServerPlayer)source.m_7639_());
        }
        return EventResult.pass();
    }

    public static void modifyDropsList(Collection<ItemEntity> drops, DamageSource source, LivingEntity entity) {
        if (!(source.m_7639_() == null || entity instanceof Player || !NO_ATTACKED_DROPS.stream().anyMatch(predicate -> predicate.test(source.m_7639_())) || source.m_7639_() instanceof IBucketable && ((IBucketable)source.m_7639_()).isFromContainer())) {
            drops.clear();
        }
    }

    public static EventResult entityAdd(Entity entity, Level level) {
        if (entity instanceof IronGolem) {
            ((MobAccessor)entity).getTargetSelector().m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((IronGolem)entity), EntityFeralWolf.class, 5, false, false, e -> !((EntityFeralWolf)e).m_21824_()));
            ((MobAccessor)entity).getTargetSelector().m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)((IronGolem)entity), EntityCoyote.class, 5, false, false, e -> !((EntityCoyote)e).m_21824_() && !((EntityCoyote)e).isDaytime()));
        }
        return EventResult.pass();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatformEvents() {
        CommonEventHandlerImpl.registerPlatformEvents();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(Player player, int kills) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setSquirrelKills(Player player, Function<Integer, Integer> mutator) {
        void var1_1;
        CommonEventHandlerImpl.setSquirrelKills(player, (Function<Integer, Integer>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static int getSquirrelKills(Player player) {
        return CommonEventHandlerImpl.getSquirrelKills(player);
    }

    static {
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityLamprey);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntitySharkBase);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityBarracuda);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityPiranha);
        NO_ATTACKED_DROPS.add(e -> e instanceof EntityOctopus && ((EntityOctopus)e).friend == null);
        LOOT_TABLE_INJECTIONS = MultimapBuilder.hashKeys().hashSetValues().build();
        IVariant v = ModEntities.FERAL_WOLF.getVariantForName("snowy").orElse(null);
        if (v instanceof EntityFeralWolf.WolfVariant) {
            EntityFeralWolf.WolfVariant variant = (EntityFeralWolf.WolfVariant)v;
            LOOT_TABLE_INJECTIONS.put((Object)EntityType.f_20499_.m_20677_(), (Object)variant.getLootTable());
        }
        LOOT_TABLE_INJECTIONS.put((Object)EntityType.f_20480_.m_20677_(), (Object)ModLootTables.SQUID);
    }
}

