/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.common.entity.EntityPheasant;
import dev.itsmeow.betteranimalsplus.common.entity.projectile.EntityBadgerDirt;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithSelectiveTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityBadger
extends EntityAnimalWithSelectiveTypes
implements Enemy {
    private static final String[] SAVANNA_TYPES = new String[]{"honey"};
    private static final String[] FOREST_TYPES = new String[]{"european"};
    private static final String[] CONIFEROUS_TYPES = new String[]{"american"};
    private static final String[] ALL_TYPES = new String[]{"american", "european", "honey"};

    public EntityBadger(EntityType<? extends EntityBadger> entityType, Level worldIn) {
        super((EntityType<? extends EntityAnimalWithSelectiveTypes>)entityType, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        if (!this.m_6162_() && this.m_20193_().m_46791_() != Difficulty.PEACEFUL) {
            this.f_21345_.m_25352_(1, (Goal)new EntityAIBadgerDigDirtThrow(this));
            this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true));
        }
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        if (!this.m_6162_() && this.m_20193_().m_46791_() != Difficulty.PEACEFUL) {
            this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 90, true, true, in -> in instanceof Chicken || in instanceof EntityPheasant || in instanceof Animal && in.m_6162_() && !(in instanceof EntityBadger)));
        }
    }

    @Override
    protected EntityBadger getBaseChild() {
        return (EntityBadger)this.getContainer().getEntityType().m_20615_(this.f_19853_);
    }

    @Override
    public String[] getTypesFor(ResourceKey<Biome> biomeKey, Biome biome, Set<BiomeTypes.Type> types, MobSpawnType reason) {
        if (types.contains(BiomeTypes.SAVANNA)) {
            return SAVANNA_TYPES;
        }
        if (types.contains(BiomeTypes.FOREST) && !types.contains(BiomeTypes.CONIFEROUS)) {
            return FOREST_TYPES;
        }
        if (types.contains(BiomeTypes.CONIFEROUS)) {
            return CONIFEROUS_TYPES;
        }
        return ALL_TYPES;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    public EntityTypeContainer<EntityBadger> getContainer() {
        return ModEntities.BADGER;
    }

    public static class EntityAIBadgerDigDirtThrow
    extends Goal {
        private final EntityBadger badger;
        public int tick = 0;
        private int stateId = -1;

        public EntityAIBadgerDigDirtThrow(EntityBadger badger) {
            this.badger = badger;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET));
        }

        public boolean m_8036_() {
            this.tick = 0;
            Level world = this.badger.f_19853_;
            BlockPos below = this.badger.m_20183_().m_7495_();
            if (world.m_46749_(below)) {
                BlockState state = world.m_8055_(below);
                double dist = this.badger.m_5448_() == null ? 0.0 : Math.sqrt(this.badger.m_20183_().m_123331_((Vec3i)this.badger.m_5448_().m_20183_()));
                return this.badger.m_5448_() != null && dist < 10.0 && dist > 2.0 && (state.m_60734_() == Blocks.f_50493_ || state.m_60734_() == Blocks.f_50440_ || state.m_60734_() == Blocks.f_49992_ || state.m_60734_() == Blocks.f_49994_ || state.m_60734_() == Blocks.f_50195_);
            }
            return false;
        }

        public boolean m_8045_() {
            BlockState state;
            boolean onDiggable = false;
            Level world = this.badger.f_19853_;
            BlockPos below = this.badger.m_20183_().m_7495_();
            if (world.m_46749_(below) && ((state = world.m_8055_(below)).m_60734_() == Blocks.f_50493_ || state.m_60734_() == Blocks.f_50440_ || state.m_60734_() == Blocks.f_49992_ || state.m_60734_() == Blocks.f_49994_ || state.m_60734_() == Blocks.f_50195_)) {
                if (state.m_60734_() == Blocks.f_50440_) {
                    state = Blocks.f_50493_.m_49966_();
                }
                this.stateId = Block.m_49956_((BlockState)state);
                onDiggable = true;
            }
            double dist = this.badger.m_5448_() == null ? 0.0 : Math.sqrt(this.badger.m_20183_().m_123331_((Vec3i)this.badger.m_5448_().m_20183_()));
            return this.badger.m_5448_() != null && (double)this.tick <= 200.0 + Math.random() * 300.0 && dist < 10.0 && dist > 2.0 && onDiggable;
        }

        public void m_8056_() {
            BlockState state;
            Level world = this.badger.f_19853_;
            BlockPos below = this.badger.m_20183_().m_7495_();
            if (world.m_46749_(below) && ((state = world.m_8055_(below)).m_60734_() == Blocks.f_50493_ || state.m_60734_() == Blocks.f_50440_ || state.m_60734_() == Blocks.f_49992_ || state.m_60734_() == Blocks.f_49994_ || state.m_60734_() == Blocks.f_50195_)) {
                if (state.m_60734_() == Blocks.f_50440_) {
                    state = Blocks.f_50493_.m_49966_();
                }
                this.stateId = Block.m_49956_((BlockState)state);
                this.tick = 1;
            }
        }

        public void m_8037_() {
            ++this.tick;
            if (this.tick % 15 == 0) {
                LivingEntity t = this.badger.m_5448_();
                EntityBadgerDirt proj = new EntityBadgerDirt((EntityType<? extends EntityBadgerDirt>)((EntityType)ModEntities.PROJECTILE_BADGER_DIRT.get()), this.badger.f_19853_, (LivingEntity)this.badger, this.stateId);
                proj.m_7678_(this.badger.m_20185_(), this.badger.m_20186_() + 1.0, this.badger.m_20189_(), 0.0f, 0.0f);
                double d0 = t.m_20186_() + (double)t.m_20192_() - (double)1.1f;
                double d1 = t.m_20185_() - this.badger.m_20185_();
                double d2 = d0 - proj.m_20186_();
                double d3 = t.m_20189_() - this.badger.m_20189_();
                double f = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
                proj.m_6686_(d1, d2 + f, d3, 0.6f, 4.8f);
                this.badger.m_5496_(SoundEvents.f_11988_, 1.0f, 1.0f / (this.badger.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.badger.f_19853_.m_7967_((Entity)proj);
            }
            if (this.tick % 5 == 0) {
                this.badger.m_5496_(SoundEvents.f_11988_, 1.0f, 1.0f / (this.badger.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }

        public void m_8041_() {
            this.tick = 0;
        }
    }
}

