/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity;

import dev.itsmeow.betteranimalsplus.api.ModEventBus;
import dev.itsmeow.betteranimalsplus.common.entity.util.EntityUtil;
import dev.itsmeow.betteranimalsplus.common.entity.util.abstracts.EntityAnimalWithTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class EntityPheasant
extends EntityAnimalWithTypes {
    protected static final EntityDataAccessor<Integer> PECK_TIME = SynchedEntityData.m_135353_(EntityPheasant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public float wingRotation;
    public float destPos;
    public float oFlapSpeed;
    public float oFlap;
    public float wingRotDelta = 0.3f;
    public int timeUntilNextEgg;

    public EntityPheasant(EntityType<? extends EntityPheasant> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.setPeckTime(this.getNewPeck());
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42577_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
    }

    private int getNewPeck() {
        return this.f_19796_.m_188503_(600) + 30;
    }

    public void m_8107_() {
        super.m_8107_();
        this.oFlap = this.wingRotation;
        this.oFlapSpeed = this.destPos;
        this.destPos = (float)((double)this.destPos + (double)(this.f_19861_ ? -1 : 4) * 0.3);
        this.destPos = Mth.m_14036_((float)this.destPos, (float)0.0f, (float)1.0f);
        if (!this.f_19861_ && this.wingRotDelta < 1.0f) {
            this.wingRotDelta = 0.3f;
        }
        this.wingRotDelta = (float)((double)this.wingRotDelta * 0.9);
        if (!this.f_19861_ && this.m_20184_().m_7098_() < 0.0) {
            this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() * 0.6, this.m_20184_().m_7094_());
        }
        this.wingRotation += this.wingRotDelta * 2.0f;
        if ((!this.f_19861_ || this.m_21566_().m_24995_()) && this.getPeckTime() <= 61) {
            this.setPeckTime(80);
        }
        if (!this.f_19853_.f_46443_ && this.setPeckTime(this.getPeckTime() - 1) <= 0) {
            this.setPeckTime(this.getNewPeck());
        }
        if (!this.f_19853_.f_46443_ && !this.m_6162_() && ModEventBus.LayEggTickEvent.emit((LivingEntity)this) && --this.timeUntilNextEgg <= 0) {
            this.m_5496_(SoundEvents.f_11752_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_20000_((ItemLike)ModItems.PHEASANT_EGG.get(), 1);
            this.timeUntilNextEgg = this.f_19796_.m_188503_(6000) + 6000;
        }
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42577_;
    }

    public boolean m_142535_(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11753_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11751_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11754_, 0.15f, 1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PECK_TIME, (Object)0);
    }

    public int getPeckTime() {
        return (Integer)this.f_19804_.m_135370_(PECK_TIME);
    }

    public int setPeckTime(int time) {
        this.f_19804_.m_135381_(PECK_TIME, (Object)time);
        return time;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData livingdata, CompoundTag compound) {
        return EntityUtil.childChance((AgeableMob)this, reason, super.m_6518_(world, difficulty, reason, livingdata, compound), 0.25f);
    }

    @Override
    protected EntityPheasant getBaseChild() {
        return (EntityPheasant)this.getContainer().getEntityType().m_20615_(this.f_19853_);
    }

    @Override
    public EntityTypeContainer<EntityPheasant> getContainer() {
        return ModEntities.PHEASANT;
    }
}

