/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.ai;

import dev.itsmeow.betteranimalsplus.util.ModPlatformEvents;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;

public class EntityAIEatGrassCustom
extends Goal {
    private static final Predicate<BlockState> IS_GRASS = BlockStatePredicate.m_61287_((Block)Blocks.f_50034_);
    protected final Mob eater;
    protected final Level world;
    protected int eatingGrassTimer;
    protected final int childChance;
    protected final int adultChance;
    protected final Function<Mob, BlockPos> getPosition;

    public EntityAIEatGrassCustom(Mob eater, int childChance, int adultChance) {
        this(eater, childChance, adultChance, e -> new BlockPos(e.m_20185_(), e.m_20186_(), e.m_20189_()));
    }

    public EntityAIEatGrassCustom(Mob eater, int childChance, int adultChance, Function<Mob, BlockPos> getPosition) {
        this.eater = eater;
        this.world = eater.f_19853_;
        this.childChance = childChance;
        this.adultChance = adultChance;
        this.getPosition = getPosition;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.eater.m_217043_().m_188503_(this.eater.m_6162_() ? this.childChance : this.adultChance) == 0) {
            BlockPos blockpos = this.getPosition.apply(this.eater);
            return IS_GRASS.test(this.world.m_8055_(blockpos)) || this.world.m_8055_(blockpos.m_7495_()).m_60734_() == Blocks.f_50440_;
        }
        return false;
    }

    public void m_8056_() {
        this.eatingGrassTimer = 40;
        this.world.m_7605_((Entity)this.eater, (byte)10);
        this.eater.m_21573_().m_26573_();
    }

    public void m_8041_() {
        this.eatingGrassTimer = 0;
    }

    public boolean m_8045_() {
        return this.eatingGrassTimer > 0;
    }

    public int getEatingGrassTimer() {
        return this.eatingGrassTimer;
    }

    public void m_8037_() {
        this.eatingGrassTimer = Math.max(0, this.eatingGrassTimer - 1);
        if (this.eatingGrassTimer == 4) {
            BlockPos blockpos = this.getPosition.apply(this.eater);
            if (IS_GRASS.test(this.world.m_8055_(blockpos))) {
                if (ModPlatformEvents.mobGrief(this.world, this.eater)) {
                    this.world.m_46961_(blockpos, false);
                }
                this.eater.m_8035_();
            } else {
                BlockPos blockpos1 = blockpos.m_7495_();
                if (this.world.m_8055_(blockpos1).m_60734_() == Blocks.f_50440_) {
                    if (ModPlatformEvents.mobGrief(this.world, this.eater)) {
                        this.world.m_46796_(2001, blockpos1, Block.m_49956_((BlockState)Blocks.f_50440_.m_49966_()));
                        this.world.m_7731_(blockpos1, Blocks.f_50493_.m_49966_(), 2);
                    }
                    this.eater.m_8035_();
                }
            }
        }
    }
}

