/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.forge;

import dev.itsmeow.betteranimalsplus.common.CommonEventHandler;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class CommonEventHandlerImpl {
    public static void registerPlatformEvents() {
        MinecraftForge.EVENT_BUS.addListener(CommonEventHandlerImpl::lootLoad);
        MinecraftForge.EVENT_BUS.addListener(CommonEventHandlerImpl::livingDrops);
    }

    public static void lootLoad(LootTableLoadEvent event) {
        for (ResourceLocation rl : CommonEventHandler.LOOT_TABLE_INJECTIONS.keys()) {
            if (!event.getName().equals((Object)rl)) continue;
            for (ResourceLocation ref : CommonEventHandler.LOOT_TABLE_INJECTIONS.get((Object)rl)) {
                event.getTable().addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)ref)).m_79082_());
            }
        }
    }

    public static void livingDrops(LivingDropsEvent event) {
        CommonEventHandler.modifyDropsList(event.getDrops(), event.getSource(), event.getEntity());
    }

    public static void setSquirrelKills(Player player, int kills) {
        CompoundTag pTag = player.getPersistentData();
        if (!pTag.m_128425_("betteranimalsplus", 10)) {
            pTag.m_128365_("betteranimalsplus", (Tag)new CompoundTag());
        }
        CompoundTag bTag = pTag.m_128469_("betteranimalsplus");
        bTag.m_128405_("squirrel_kills", kills);
    }

    public static void setSquirrelKills(Player player, Function<Integer, Integer> mutator) {
        CompoundTag bTag;
        CompoundTag pTag = player.getPersistentData();
        if (!pTag.m_128425_("betteranimalsplus", 10)) {
            pTag.m_128365_("betteranimalsplus", (Tag)new CompoundTag());
        }
        bTag.m_128405_("squirrel_kills", mutator.apply((bTag = pTag.m_128469_("betteranimalsplus")).m_128425_("squirrel_kills", 3) ? bTag.m_128451_("squirrel_kills") : 0).intValue());
    }

    public static int getSquirrelKills(Player player) {
        if (player.getPersistentData().m_128425_("betteranimalsplus", 10) && player.getPersistentData().m_128469_("betteranimalsplus").m_128425_("squirrel_kills", 3)) {
            return player.getPersistentData().m_128469_("betteranimalsplus").m_128451_("squirrel_kills");
        }
        return 0;
    }
}

