/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.itsmeow.betteranimalsplus.imdlib.mixin.ModelPartAccessor;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.phys.Vec3;

public class RenderUtil {
    private static final Map<ModelPart, ModelPart.Cube> cubeList = new WeakHashMap<ModelPart, ModelPart.Cube>();

    public static Vec3 partLocation(ModelPart ... parts) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (ModelPart part : parts) {
            x += part.f_104203_ + RenderUtil.xOffset(part);
            y += part.f_104204_ + RenderUtil.yOffset(part);
            z += part.f_104205_ + RenderUtil.zOffset(part);
        }
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static void partTranslateRotate(PoseStack stack, ModelPart ... parts) {
        for (ModelPart part : parts) {
            RenderUtil.pointTranslate(stack, part);
            stack.m_85845_(Vector3f.f_122223_.m_122270_(part.f_104203_));
            stack.m_85845_(Vector3f.f_122225_.m_122270_(part.f_104204_));
            stack.m_85845_(Vector3f.f_122227_.m_122270_(part.f_104205_));
        }
    }

    public static void partTranslateOffsetRotate(PoseStack stack, ModelPart ... parts) {
        for (ModelPart part : parts) {
            RenderUtil.offsetTranslate(stack, part);
            RenderUtil.pointTranslate(stack, part);
            stack.m_85845_(Vector3f.f_122223_.m_122270_(part.f_104203_));
            stack.m_85845_(Vector3f.f_122225_.m_122270_(part.f_104204_));
            stack.m_85845_(Vector3f.f_122227_.m_122270_(part.f_104205_));
        }
    }

    public static void partScaleTranslate(PoseStack stack, ModelPart part, float scale) {
        RenderUtil.offsetTranslate(stack, part);
        RenderUtil.pointTranslate(stack, part);
        RenderUtil.scale(stack, scale);
        RenderUtil.negativeOffsetTranslate(stack, part);
        RenderUtil.negativePointTranslate(stack, part);
    }

    public static void partScaleTranslate(PoseStack stack, ModelPart part, double scale) {
        RenderUtil.partScaleTranslate(stack, part, (float)scale);
    }

    public static void partScaleTranslate(PoseStack stack, ModelPart part, float scaleX, float scaleY, float scaleZ) {
        RenderUtil.offsetTranslate(stack, part);
        RenderUtil.pointTranslate(stack, part);
        stack.m_85841_(scaleX, scaleY, scaleZ);
        RenderUtil.negativeOffsetTranslate(stack, part);
        RenderUtil.negativePointTranslate(stack, part);
    }

    public static void partScaleTranslate(PoseStack stack, ModelPart part, double scaleX, double scaleY, double scaleZ) {
        RenderUtil.partScaleTranslate(stack, part, (float)scaleX, (float)scaleY, (float)scaleZ);
    }

    public static void offsetTranslate(PoseStack stack, ModelPart part) {
        stack.m_85837_((double)RenderUtil.xOffset(part), (double)RenderUtil.yOffset(part), (double)RenderUtil.zOffset(part));
    }

    public static void negativeOffsetTranslate(PoseStack stack, ModelPart part) {
        stack.m_85837_((double)(-RenderUtil.xOffset(part)), (double)(-RenderUtil.yOffset(part)), (double)(-RenderUtil.zOffset(part)));
    }

    public static void pointTranslate(PoseStack stack, ModelPart part) {
        stack.m_85837_((double)(part.f_104200_ / 16.0f), (double)(part.f_104201_ / 16.0f), (double)(part.f_104202_ / 16.0f));
    }

    public static void negativePointTranslate(PoseStack stack, ModelPart part) {
        stack.m_85837_((double)(-part.f_104200_ / 16.0f), (double)(-part.f_104201_ / 16.0f), (double)(-part.f_104202_ / 16.0f));
    }

    public static void scale(PoseStack stack, float scale) {
        stack.m_85841_(scale, scale, scale);
    }

    public static void scale(PoseStack stack, double scale) {
        RenderUtil.scale(stack, (float)scale);
    }

    public static float xOffset(ModelPart part) {
        return RenderUtil.getPartBox((ModelPart)part).f_104335_ / 16.0f;
    }

    public static float yOffset(ModelPart part) {
        return RenderUtil.getPartBox((ModelPart)part).f_104336_ / 16.0f;
    }

    public static float zOffset(ModelPart part) {
        return RenderUtil.getPartBox((ModelPart)part).f_104337_ / 16.0f;
    }

    private static ModelPart.Cube getPartBox(ModelPart part) {
        ModelPart.Cube res = cubeList.get(part);
        if (res == null) {
            res = ((ModelPartAccessor)part).cubes().get(0);
            cubeList.put(part, res);
        }
        return res;
    }
}

