/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.Registrar;
import dev.itsmeow.betteranimalsplus.imdlib.IMDLib;
import dev.itsmeow.betteranimalsplus.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder.IEntityBuilder;
import dev.itsmeow.betteranimalsplus.imdlib.item.ItemModFishBucket;
import dev.itsmeow.betteranimalsplus.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.betteranimalsplus.imdlib.mixin.SpawnSettingsAccessor;
import dev.itsmeow.betteranimalsplus.imdlib.util.HeadType;
import dev.itsmeow.betteranimalsplus.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.betteranimalsplus.imdlib.util.config.ConfigBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class EntityRegistrarHandler {
    public final String modid;
    public final LinkedHashMap<String, EntityTypeContainer<? extends Mob>> ENTITIES = new LinkedHashMap();

    public EntityRegistrarHandler(String modid) {
        this.modid = modid;
    }

    public void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(state -> IMDLib.setStaticServerInstance(state));
        LifecycleEvent.SERVER_STOPPED.register(state -> IMDLib.setStaticServerInstance(null));
        BiomeTypes.init();
        for (HeadType headType : HeadType.values()) {
            headType.register(IMDLib.getRegistries().get());
        }
        Registrar items = IMDLib.getRegistry(Registry.f_122904_);
        for (EntityTypeContainer<? extends Mob> entityTypeContainer : this.ENTITIES.values()) {
            if (entityTypeContainer instanceof EntityTypeContainerContainable) {
                ResourceLocation emptyContainerKey;
                EntityTypeContainerContainable c = (EntityTypeContainerContainable)entityTypeContainer;
                ResourceLocation containerKey = new ResourceLocation(this.modid, c.getContainerItemName());
                if (!items.contains(containerKey)) {
                    items.register(containerKey, c::getContainerItem);
                }
                if (!(emptyContainerKey = new ResourceLocation(this.modid, c.getEmptyContainerItemName())).m_135815_().isEmpty() && !items.contains(emptyContainerKey)) {
                    items.register(emptyContainerKey, c::getEmptyContainerItem);
                }
            }
            if (!entityTypeContainer.hasEgg()) continue;
            entityTypeContainer.egg = items.register(new ResourceLocation(entityTypeContainer.getModId(), entityTypeContainer.getEntityName().toLowerCase() + "_spawn_egg"), () -> new ModSpawnEggItem(container));
        }
        Registrar registrar = IMDLib.getRegistry(Registry.f_122907_);
        registrar.register(new ResourceLocation(this.modid, "head"), () -> HeadBlockEntity.HEAD_TYPE.m_13971_());
        Registrar registrar2 = IMDLib.getRegistry(Registry.f_122903_);
        for (EntityTypeContainer<? extends Mob> container : this.ENTITIES.values()) {
            ResourceLocation rl = new ResourceLocation(this.modid, container.getEntityName());
            registrar2.register(rl, container::getEntityType);
            EntityAttributeRegistry.register(container::getEntityType, container.getAttributeBuilder());
        }
        CommonConfigAPI.createServerConfig(builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.createConfiguration((ConfigBuilder)builder));
            builder.pop();
        }, server -> {
            this.ENTITIES.values().forEach(e -> e.getConfiguration().load());
            Registry biomeRegistrar = server.m_206579_().m_175515_(Registry.f_122885_);
            for (ResourceLocation key : biomeRegistrar.m_6566_()) {
                Biome biome = (Biome)biomeRegistrar.m_7745_(key);
                MobSpawnSettings spawnInfo = biome.m_47518_();
                SpawnSettingsAccessor spawnInfoA = (SpawnSettingsAccessor)spawnInfo;
                spawnInfoA.setSpawners(new HashMap<MobCategory, List<MobSpawnSettings.SpawnerData>>(spawnInfoA.getSpawners()));
                for (MobCategory category : MobCategory.values()) {
                    if (!(spawnInfoA.getSpawners().get(category) instanceof List)) continue;
                    spawnInfoA.getSpawners().put(category, new ArrayList(spawnInfoA.getSpawners().get(category)));
                }
                spawnInfoA.setMobSpawnCosts(new HashMap(spawnInfoA.getMobSpawnCosts()));
                for (EntityTypeContainer entityTypeContainer : this.ENTITIES.values()) {
                    EntityTypeContainer.EntityConfiguration config = entityTypeContainer.getConfiguration();
                    if (!entityTypeContainer.getDefinition().hasSpawns() || !config.doSpawning.get().booleanValue() || config.spawnWeight.get() <= 0 || !entityTypeContainer.getBiomeIDs().contains(key.toString())) continue;
                    entityTypeContainer.registerPlacement();
                    List<MobSpawnSettings.SpawnerData> list = spawnInfoA.getSpawners().get(entityTypeContainer.getDefinition().getSpawnClassification());
                    if (list != null) {
                        if (list instanceof WeightedRandomList) {
                            WeightedRandomList w = (WeightedRandomList)list;
                            ArrayList<MobSpawnSettings.SpawnerData> l = new ArrayList<MobSpawnSettings.SpawnerData>(w.m_146338_());
                            l.add(entityTypeContainer.getSpawnEntry());
                            spawnInfoA.getSpawners().put(entityTypeContainer.getDefinition().getSpawnClassification(), (List<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146328_(l));
                        } else if (list instanceof ArrayList) {
                            ArrayList l = (ArrayList)list;
                            l.add(entityTypeContainer.getSpawnEntry());
                        }
                    }
                    if (config.spawnCostPer.get() == 0.0 || config.spawnMaxCost.get() == 0.0 || !entityTypeContainer.getSpawnCostBiomeIDs().contains(key.toString())) continue;
                    MobSpawnSettings.MobSpawnCost costs = ((SpawnSettingsAccessor)new MobSpawnSettings.Builder().m_48370_(entityTypeContainer.getEntityType(), config.spawnCostPer.get().doubleValue(), config.spawnMaxCost.get().doubleValue()).m_48381_()).getMobSpawnCosts().get(entityTypeContainer.getEntityType());
                    spawnInfoA.getMobSpawnCosts().put(entityTypeContainer.getEntityType(), costs);
                }
            }
        });
        CommonConfigAPI.createConfig(CommonConfigAPI.ConfigType.CLIENT, builder -> {
            builder.push("entities");
            this.ENTITIES.values().forEach(c -> c.clientCustomConfigurationInit((ConfigBuilder)builder));
            builder.pop();
        }, () -> this.ENTITIES.values().forEach(EntityTypeContainer::clientCustomConfigurationLoad));
    }

    public <T extends Mob> EntityTypeContainer<T> getEntityTypeContainer(String name) {
        return this.ENTITIES.get(name);
    }

    public <T extends Mob> EntityType<T> getEntityType(String name) {
        return this.ENTITIES.get(name).getEntityType();
    }

    public <T extends Mob> EntityTypeContainer<T> add(Class<T> entityClass, EntityType.EntityFactory<T> factory, String name, Supplier<AttributeSupplier.Builder> attributeMap, Function<EntityTypeContainer.Builder<T>, EntityTypeContainer.Builder<T>> transformer) {
        return this.add((IEntityBuilder)transformer.apply(EntityTypeContainer.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends Mob, I extends Item> EntityTypeContainerContainable<T, I> addContainable(Class<T> entityClass, EntityType.EntityFactory<T> factory, String name, Supplier<AttributeSupplier.Builder> attributeMap, Function<EntityTypeContainerContainable.Builder<T, I>, EntityTypeContainerContainable.Builder<T, I>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends Mob> EntityTypeContainerContainable<T, ItemModFishBucket<T>> addContainableB(Class<T> entityClass, EntityType.EntityFactory<T> factory, String name, Supplier<AttributeSupplier.Builder> attributeMap, Function<EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>, EntityTypeContainerContainable.Builder<T, ItemModFishBucket<T>>> transformer) {
        return (EntityTypeContainerContainable)this.add((IEntityBuilder)transformer.apply(EntityTypeContainerContainable.Builder.create(entityClass, factory, name, attributeMap, this.modid)));
    }

    public <T extends Mob, C extends EntityTypeContainer<T>> C add(IEntityBuilder<T, C, ?> builder) {
        Object c = builder.build();
        ((EntityTypeContainer)c).entityType = new LazyLoadedValue(() -> this.createEntityType((EntityTypeContainer)c));
        ((EntityTypeContainer)c).onTypeAdded();
        this.ENTITIES.put(((EntityTypeContainer)c).getEntityName(), (EntityTypeContainer<? extends Mob>)c);
        return c;
    }

    public <T extends Mob> EntityType<T> createEntityType(EntityTypeContainer<T> container) {
        return this.createEntityType(container.getDefinition().getEntityFactory(), container.getEntityName(), container.getDefinition().getSpawnClassification(), 64, 1, true, container.getWidth(), container.getHeight());
    }

    public <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> factory, String entityNameIn, MobCategory classification, int trackingRange, int updateInterval, boolean velUpdates, float width, float height) {
        return EntityType.Builder.m_20704_(factory, (MobCategory)classification).m_20702_(trackingRange).m_20717_(updateInterval).m_20699_(width, height).m_20712_(this.modid + ":" + entityNameIn.toLowerCase());
    }
}

