/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.entity.util.builder;

import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public interface IEntityTypeDefinition<T extends Mob> {
    public String getModId();

    public Class<T> getEntityClass();

    public EntityType.EntityFactory<T> getEntityFactory();

    public String getEntityName();

    public MobCategory getSpawnClassification();

    public boolean hasEgg();

    public int getEggSolidColor();

    public int getEggSpotColor();

    public boolean hasSpawns();

    public int getSpawnWeight();

    public int getSpawnMinGroup();

    public int getSpawnMaxGroup();

    public boolean useSpawnCosts();

    public double getSpawnCostPer();

    public double getSpawnMaxCost();

    public float getWidth();

    public float getHeight();

    public boolean despawns();

    public int getVariantAmount();

    public IVariant[] getVariants();

    @Nullable
    public EntityTypeContainer.CustomConfigurationLoad getCustomConfigLoad();

    @Nullable
    public EntityTypeContainer.CustomConfigurationInit getCustomConfigInit();

    @Nullable
    public EntityTypeContainer.CustomConfigurationLoad getCustomClientConfigLoad();

    @Nullable
    public EntityTypeContainer.CustomConfigurationInit getCustomClientConfigInit();

    public Supplier<Set<ResourceKey<Biome>>> getDefaultSpawnBiomes();

    public SpawnPlacements.Type getPlacementType();

    public Heightmap.Types getPlacementHeightMapType();

    public SpawnPlacements.SpawnPredicate<T> getPlacementPredicate();

    public Supplier<AttributeSupplier.Builder> getAttributeMap();
}

