/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.utils.PlatformExpectedError;
import dev.itsmeow.betteranimalsplus.imdlib.entity.EntityTypeContainer;
import dev.itsmeow.betteranimalsplus.imdlib.entity.interfaces.IContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.EntityTypeContainerContainable;
import dev.itsmeow.betteranimalsplus.imdlib.entity.util.variant.IVariant;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface IContainerItem<T extends Mob> {
    public static final ITooltipFunction VARIANT_TOOLTIP = (container, stack, world, tooltip) -> {
        String id;
        Optional<IVariant> variant;
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("BucketVariantTag", 8) && (variant = container.getVariantForName(id = compoundnbt.m_128461_("BucketVariantTag"))).isPresent()) {
            tooltip.add(Component.m_237115_((String)("entity." + container.getModId() + "." + container.getEntityName().toLowerCase() + ".type." + variant.get().getName())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    };

    public static String getVariantIfPresent(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        if (compoundnbt != null && compoundnbt.m_128425_("BucketVariantTag", 8)) {
            return compoundnbt.m_128461_("BucketVariantTag");
        }
        return "";
    }

    @OnlyIn(value=Dist.CLIENT)
    @ExpectPlatform
    default public <A extends Item> void addPropertyOverrides(A item) {
        throw new PlatformExpectedError();
    }

    public EntityTypeContainer<T> getContainer();

    default public EntityType<T> getEntityType() {
        return this.getContainer().getEntityType();
    }

    default public void placeEntity(ServerLevel worldIn, ItemStack stack, BlockPos pos) {
        Mob entity = (Mob)this.getEntityType().m_20600_(worldIn, stack.m_41783_(), stack.m_41788_() ? stack.m_41611_() : null, null, pos, MobSpawnType.BUCKET, true, false);
        if (entity != null) {
            ((IContainable)entity).setFromContainer(true);
            ((IContainable)entity).readFromContainer(stack);
            if (stack.m_41783_() != null) {
                ((IContainable)entity).readFromContainerTag(stack.m_41783_());
            }
        }
    }

    @FunctionalInterface
    public static interface ITooltipFunction {
        public void addInformation(EntityTypeContainerContainable<? extends Mob, ?> var1, ItemStack var2, @Nullable Level var3, List<Component> var4);
    }
}

