/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.imdlib.util.config;

import dev.itsmeow.betteranimalsplus.imdlib.IMDLib;
import dev.itsmeow.betteranimalsplus.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.betteranimalsplus.imdlib.util.config.ConfigBuilder;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class ConfigBuilderForge
extends ConfigBuilder {
    private ForgeConfigSpec.Builder builder;
    private ForgeConfigSpec spec;
    private CommonConfigAPI.ConfigType type;

    public ConfigBuilderForge(CommonConfigAPI.ConfigType type, Consumer<ConfigBuilder> init, Runnable onLoad) {
        this(type, init, onLoad, true);
    }

    public ConfigBuilderForge(CommonConfigAPI.ConfigType type, Consumer<ConfigBuilder> init, Runnable onLoad, boolean includeComment) {
        super(type, init, onLoad);
        this.type = type;
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            this.builder = builder;
            if (includeComment) {
                builder.comment("This is a " + type.name().toLowerCase() + " configuration file. Configurations with further options are located in: .minecraft/saves/(your world)/serverconfig/. Placing a server configuration in .minecraft/defaultconfigs/ will copy it to newly created worlds automatically.");
            }
            init.accept(this);
            return this;
        });
        this.spec = (ForgeConfigSpec)specPair.getRight();
        ModLoadingContext.get().registerConfig(type == CommonConfigAPI.ConfigType.CLIENT ? ModConfig.Type.CLIENT : (type == CommonConfigAPI.ConfigType.COMMON ? ModConfig.Type.COMMON : ModConfig.Type.SERVER), (IConfigSpec)specPair.getRight());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadForge);
    }

    public ConfigBuilderForge(Consumer<ConfigBuilder> init, Consumer<MinecraftServer> onLoad) {
        super(init, onLoad);
        this.type = CommonConfigAPI.ConfigType.SERVER;
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            this.builder = builder;
            init.accept(this);
            return this;
        });
        this.spec = (ForgeConfigSpec)specPair.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)specPair.getRight());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadForge);
    }

    private void onLoadForge(ModConfigEvent.Loading configEvent) {
        LogManager.getLogger().debug("Loading {}", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getSpec() == this.spec) {
            this.onLoad((MinecraftServer)(this.type == CommonConfigAPI.ConfigType.SERVER ? IMDLib.getStaticServerInstance() : null));
        }
    }

    @Override
    public <T> Supplier<T> define(String path, T defaultValue) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.worldRestart().define(path, defaultValue)).get();
    }

    @Override
    public Supplier<Double> defineInRange(String path, double defaultValue, double min, double max) {
        return () -> ((ForgeConfigSpec.DoubleValue)this.builder.worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public Supplier<Integer> defineInRange(String path, int defaultValue, int min, int max) {
        return () -> ((ForgeConfigSpec.IntValue)this.builder.worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public Supplier<Long> defineInRange(String path, long defaultValue, long min, long max) {
        return () -> ((ForgeConfigSpec.LongValue)this.builder.worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, List<? extends T> defaultValue, T baseTypeValue, Predicate<Object> elementValidator) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.worldRestart().defineList(path, defaultValue, elementValidator)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, Supplier<List<? extends T>> defaultSupplier, T baseTypeValue, Predicate<Object> elementValidator) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.worldRestart().defineList(path, defaultSupplier, elementValidator)).get();
    }

    @Override
    public <T> Supplier<T> define(String path, String comment, T defaultValue) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.comment(comment).worldRestart().define(path, defaultValue)).get();
    }

    @Override
    public Supplier<Double> defineInRange(String path, String comment, double defaultValue, double min, double max) {
        return () -> ((ForgeConfigSpec.DoubleValue)this.builder.comment(comment).worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public Supplier<Integer> defineInRange(String path, String comment, int defaultValue, int min, int max) {
        return () -> ((ForgeConfigSpec.IntValue)this.builder.comment(comment).worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public Supplier<Long> defineInRange(String path, String comment, long defaultValue, long min, long max) {
        return () -> ((ForgeConfigSpec.LongValue)this.builder.comment(comment).worldRestart().defineInRange(path, defaultValue, min, max)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, String comment, List<? extends T> defaultValue, T baseTypeValue, Predicate<Object> elementValidator) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.comment(comment).worldRestart().defineList(path, defaultValue, elementValidator)).get();
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, String comment, Supplier<List<? extends T>> defaultSupplier, T baseTypeValue, Predicate<Object> elementValidator) {
        return () -> ((ForgeConfigSpec.ConfigValue)this.builder.comment(comment).worldRestart().defineList(path, defaultSupplier, elementValidator)).get();
    }

    @Override
    public void push(String path) {
        this.builder.push(path);
    }

    @Override
    public void pop() {
        this.builder.pop();
    }
}

