/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.util;

import dev.itsmeow.betteranimalsplus.imdlib.entity.util.BiomeTypes;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class OceanBiomeHelper {
    public static boolean isColdOrFrozenOcean(ResourceKey<Biome> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == Biomes.f_48168_ || biome == Biomes.f_48171_ || biome == Biomes.f_48172_ || biome == Biomes.f_48211_ || types.contains(BiomeTypes.COLD) && types.contains(BiomeTypes.OCEAN));
    }

    public static boolean isDeepOcean(ResourceKey<Biome> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == Biomes.f_48172_ || biome == Biomes.f_48171_ || biome == Biomes.f_48170_ || biome == Biomes.f_48225_ || biome.m_135782_().m_135815_().contains("deep"));
    }

    public static boolean isFrozenOcean(ResourceKey<Biome> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == Biomes.f_48172_ || biome == Biomes.f_48211_ || biome.m_135782_().m_135815_().contains("frozen"));
    }

    public static boolean isWarmOcean(ResourceKey<Biome> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == Biomes.f_48166_ || biome.m_135782_().m_135815_().contains("warm") && !biome.m_135782_().m_135815_().contains("lukewarm"));
    }

    public static boolean isLukewarmOcean(ResourceKey<Biome> biome) {
        Set<BiomeTypes.Type> types = BiomeTypes.getTypes(biome);
        return types.contains(BiomeTypes.OCEAN) && (biome == Biomes.f_48170_ || biome == Biomes.f_48167_ || biome.m_135782_().m_135815_().contains("lukewarm"));
    }

    public static ResourceKey<Biome>[] subtropicalOcean() {
        return OceanBiomeHelper.removeIf(biome -> !OceanBiomeHelper.isWarmOcean((ResourceKey<Biome>)biome) && !OceanBiomeHelper.isLukewarmOcean((ResourceKey<Biome>)biome) || OceanBiomeHelper.isDeepOcean((ResourceKey<Biome>)biome));
    }

    public static ResourceKey<Biome>[] returnIf(Predicate<ResourceKey<Biome>> filter) {
        HashSet<ResourceKey<Biome>> oceans = new HashSet<ResourceKey<Biome>>();
        for (ResourceKey<Biome> b : BiomeTypes.getBiomes(BiomeTypes.OCEAN)) {
            if (!filter.test(b)) continue;
            oceans.add(b);
        }
        return oceans.toArray(new ResourceKey[0]);
    }

    public static ResourceKey<Biome>[] removeIf(Predicate<ResourceKey<Biome>> filter) {
        HashSet<ResourceKey<Biome>> oceans = new HashSet<ResourceKey<Biome>>(BiomeTypes.getBiomes(BiomeTypes.OCEAN));
        oceans.removeIf(filter);
        return oceans.toArray(new ResourceKey[0]);
    }

    public static class Wrapper {
        private final boolean coldOrFrozen;
        private final boolean deep;
        private final boolean frozen;
        private final boolean warm;
        private final boolean lukewarm;

        public Wrapper(ResourceKey<Biome> biome) {
            this.coldOrFrozen = OceanBiomeHelper.isColdOrFrozenOcean(biome);
            this.deep = OceanBiomeHelper.isDeepOcean(biome);
            this.frozen = OceanBiomeHelper.isFrozenOcean(biome);
            this.warm = OceanBiomeHelper.isWarmOcean(biome);
            this.lukewarm = OceanBiomeHelper.isLukewarmOcean(biome);
        }

        public boolean isLukewarm() {
            return this.lukewarm;
        }

        public boolean isWarm() {
            return this.warm;
        }

        public boolean isFrozen() {
            return this.frozen;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public boolean isColdOrFrozen() {
            return this.coldOrFrozen;
        }
    }
}

