/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.plugin.biomesoplenty;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import yamahari.ilikewood.plugin.biomesoplenty.BiomesOPlentyWoodTypes;
import yamahari.ilikewood.plugin.biomesoplenty.util.Util;
import yamahari.ilikewood.plugin.biomesoplenty.util.resources.WoodenLogResource;
import yamahari.ilikewood.plugin.biomesoplenty.util.resources.WoodenPlanksResource;
import yamahari.ilikewood.plugin.biomesoplenty.util.resources.WoodenSlabResource;
import yamahari.ilikewood.plugin.biomesoplenty.util.resources.WoodenStrippedLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenLogResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenSlabResource;
import yamahari.ilikewood.registry.resource.resources.IWoodenStrippedLogResource;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class BiomesOPlentyWoodenResources {
    public static final Map<IWoodType, IWoodenPlanksResource> PLANKS;
    public static final Map<IWoodType, IWoodenLogResource> LOGS;
    public static final Map<IWoodType, IWoodenStrippedLogResource> STRIPPED_LOGS;
    public static final Map<IWoodType, IWoodenSlabResource> SLABS;
    private static final Map<IWoodType, BlockBehaviour.Properties> PLANKS_PROPERTIES;

    private BiomesOPlentyWoodenResources() {
    }

    static {
        PLANKS_PROPERTIES = new ImmutableMap.Builder().put((Object)BiomesOPlentyWoodTypes.CHERRY, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.DEAD, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76409_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.FIR, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76372_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.HELLBARK, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76379_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.JACARANDA, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76372_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.MAGIC, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76361_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.MAHOGANY, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76378_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.PALM, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76376_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.REDWOOD, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76373_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.UMBRAN, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76383_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).put((Object)BiomesOPlentyWoodTypes.WILLOW, (Object)BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76377_).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_)).build();
        HashMap planks = new HashMap();
        HashMap logs = new HashMap();
        HashMap strippedLogs = new HashMap();
        HashMap slabs = new HashMap();
        BiomesOPlentyWoodTypes.get().forEach(woodType -> {
            ResourceLocation planksResource = new ResourceLocation("biomesoplenty", Util.toRegistryName(woodType.getName(), "planks"));
            ResourceLocation logResource = new ResourceLocation("biomesoplenty", Util.toRegistryName(woodType.getName(), "log"));
            ResourceLocation strippedLogResource = new ResourceLocation("biomesoplenty", Util.toRegistryName("stripped", woodType.getName(), "log"));
            ResourceLocation slabResource = new ResourceLocation("biomesoplenty", Util.toRegistryName(woodType.getName(), "slab"));
            ResourceLocation planksTexture = new ResourceLocation(planksResource.m_135827_(), Util.toPath("block", planksResource.m_135815_()));
            planks.put(woodType, new WoodenPlanksResource(planksTexture, planksResource, PLANKS_PROPERTIES.get(woodType)));
            logs.put(woodType, new WoodenLogResource(new ResourceLocation(logResource.m_135827_(), Util.toPath("block", Util.toRegistryName(logResource.m_135815_(), "top"))), new ResourceLocation(logResource.m_135827_(), Util.toPath("block", logResource.m_135815_())), logResource));
            strippedLogs.put(woodType, new WoodenStrippedLogResource(new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", Util.toRegistryName(strippedLogResource.m_135815_(), "top"))), new ResourceLocation(strippedLogResource.m_135827_(), Util.toPath("block", strippedLogResource.m_135815_())), strippedLogResource));
            slabs.put(woodType, new WoodenSlabResource(planksTexture, planksTexture, planksTexture, slabResource));
        });
        PLANKS = Collections.unmodifiableMap(planks);
        LOGS = Collections.unmodifiableMap(logs);
        STRIPPED_LOGS = Collections.unmodifiableMap(strippedLogs);
        SLABS = Collections.unmodifiableMap(slabs);
    }
}

