/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import yamahari.ilikewood.client.blockentity.WoodenCampfireBlockEntity;
import yamahari.ilikewood.registry.WoodenBlockEntityTypes;
import yamahari.ilikewood.registry.WoodenParticleTypes;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public class WoodenCampfireBlock
extends CampfireBlock
implements IWooden {
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.m_61587_((String)"color", DyeColor.class);
    public static final BooleanProperty COLORED = BooleanProperty.m_61465_((String)"colored");
    private final IWoodType woodType;
    private final boolean isSoul;

    private WoodenCampfireBlock(boolean spawnParticles, int fireDamage, BlockBehaviour.Properties properties, IWoodType woodType) {
        super(spawnParticles, fireDamage, properties);
        this.woodType = woodType;
        this.isSoul = !spawnParticles;
        ((BlockState)this.m_49966_().m_61124_((Property)COLORED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)DyeColor.WHITE);
    }

    public static WoodenCampfireBlock campfire(IWoodType woodType) {
        return new WoodenCampfireBlock(true, 1, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50683_), woodType);
    }

    public static WoodenCampfireBlock soulCampfire(IWoodType woodType) {
        return new WoodenCampfireBlock(false, 2, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50684_), woodType);
    }

    public static void makeParticles(Level level, BlockPos pos, boolean isSignalFire, boolean isCooking) {
        BlockState state = level.m_8055_(pos);
        RandomSource random = level.m_213780_();
        Block block = state.m_60734_();
        if (block instanceof WoodenCampfireBlock) {
            WoodenCampfireBlock campfireBlock = (WoodenCampfireBlock)block;
            SimpleParticleType particleType = campfireBlock.isSoul || (Boolean)state.m_61143_((Property)COLORED) == false ? (isSignalFire ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_) : (isSignalFire ? (SimpleParticleType)WoodenParticleTypes.COLORED_CAMPFIRE_SIGNAL_SMOKE.get(state.m_61143_(COLOR)).get() : (SimpleParticleType)WoodenParticleTypes.COLORED_CAMPFIRE_COSY_SMOKE.get(state.m_61143_(COLOR)).get());
            level.m_6485_((ParticleOptions)particleType, true, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + random.m_188500_() + random.m_188500_(), (double)pos.m_123343_() + 0.5 + random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
            if (isCooking) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.4, (double)pos.m_123343_() + 0.5 + random.m_188500_() / 4.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.005, 0.0);
            }
        }
    }

    public void m_214162_(BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        if (((Boolean)state.m_61143_((Property)f_51227_)).booleanValue()) {
            if (random.m_188503_(10) == 0) {
                level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.1f + random.m_188501_() * 0.4f, random.m_188501_() * 0.7f + 0.6f, false);
            }
            if (!this.isSoul && random.m_188503_(5) == 0) {
                for (int i = 0; i < random.m_188503_(1) + 1; ++i) {
                    if (!((Boolean)state.m_61143_((Property)COLORED)).booleanValue()) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
                        continue;
                    }
                    level.m_7106_((ParticleOptions)WoodenParticleTypes.COLORED_LAVA.get(state.m_61143_(COLOR)).get(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
                }
            }
        }
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new WoodenCampfireBlockEntity(pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CampfireBlockEntity) {
            CampfireBlockEntity campfireBlockEntity = (CampfireBlockEntity)blockEntity;
            ItemStack itemStack = player.m_21120_(hand);
            Optional optional = campfireBlockEntity.m_59051_(itemStack);
            if (optional.isPresent()) {
                if (!level.f_46443_ && campfireBlockEntity.m_238284_((Entity)player, player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack, ((CampfireCookingRecipe)optional.get()).m_43753_())) {
                    player.m_36220_(Stats.f_12975_);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            Item item = itemStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                if (!level.f_46443_) {
                    BlockState newBlockState;
                    level.m_7731_(pos, newBlockState, state != (newBlockState = (BlockState)((BlockState)state.m_61124_((Property)COLORED, (Comparable)Boolean.valueOf(true))).m_61124_(COLOR, (Comparable)dyeItem.m_41089_())) ? 1 : 0);
                    if (!player.m_150110_().f_35937_) {
                        itemStack.m_41774_(1);
                    }
                }
            } else if (item instanceof BoneMealItem && !level.f_46443_) {
                BlockState newBlockState;
                level.m_7731_(pos, newBlockState, state != (newBlockState = (BlockState)state.m_61124_((Property)COLORED, (Comparable)Boolean.valueOf(false))) ? 1 : 0);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{COLOR, COLORED});
    }

    @Nullable
    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_(COLOR, (Comparable)DyeColor.WHITE)).m_61124_((Property)COLORED, (Comparable)Boolean.valueOf(false));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return (Boolean)state.m_61143_((Property)f_51227_) != false ? WoodenCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)WoodenBlockEntityTypes.WOODEN_CAMPFIRE.get()), WoodenCampfireBlockEntity::particleTick2) : null;
        }
        return (Boolean)state.m_61143_((Property)f_51227_) != false ? WoodenCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)WoodenBlockEntityTypes.WOODEN_CAMPFIRE.get()), CampfireBlockEntity::m_155306_) : WoodenCampfireBlock.m_152132_(blockEntityType, (BlockEntityType)BlockEntityType.f_58911_, CampfireBlockEntity::m_155313_);
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }
}

