/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.client.blockentity.WoodenCrateBlockEntity;
import yamahari.ilikewood.registry.WoodenBlockEntityTypes;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public final class WoodenCrateBlock
extends BaseEntityBlock
implements IWooden {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final ResourceLocation CONTENTS = new ResourceLocation("ilikewood", "contents");
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.m_49796_((double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0, (double)14.0), Block.m_49796_((double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)2.0, (double)14.0), Block.m_49796_((double)14.0, (double)14.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)14.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)2.0, (double)16.0), Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private final IWoodType woodType;

    public WoodenCrateBlock(IWoodType woodType) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_));
        this.woodType = woodType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WoodenCrateBlockEntity) {
            WoodenCrateBlockEntity woodenCrateBlockEntity = (WoodenCrateBlockEntity)blockEntity;
            player.m_5893_((MenuProvider)woodenCrateBlockEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5707_(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WoodenCrateBlockEntity) {
            WoodenCrateBlockEntity woodenCrateBlockEntity = (WoodenCrateBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !woodenCrateBlockEntity.m_7983_()) {
                ItemStack stack = new ItemStack((ItemLike)ILikeWood.BLOCK_REGISTRY.getObject(this.getWoodType(), WoodenBlockType.CRATE));
                blockEntity.m_187476_(stack);
                if (woodenCrateBlockEntity.m_8077_()) {
                    stack.m_41714_(woodenCrateBlockEntity.m_7770_());
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            } else {
                woodenCrateBlockEntity.m_59640_(player);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState blockState, @Nonnull LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof WoodenCrateBlockEntity) {
            WoodenCrateBlockEntity woodenCrateBlockEntity = (WoodenCrateBlockEntity)blockentity;
            builder = builder.m_78979_(CONTENTS, (p_56218_, p_56219_) -> {
                for (int i = 0; i < woodenCrateBlockEntity.m_6643_(); ++i) {
                    p_56219_.accept(woodenCrateBlockEntity.m_8020_(i));
                }
            });
        }
        return super.m_7381_(blockState, builder);
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (stack.m_41788_() && (blockEntity = level.m_7702_(pos)) instanceof WoodenCrateBlockEntity) {
            WoodenCrateBlockEntity woodenCrateBlockEntity = (WoodenCrateBlockEntity)blockEntity;
            woodenCrateBlockEntity.m_58638_(stack.m_41786_());
        }
    }

    public void m_6810_(BlockState stateOld, @Nonnull Level level, @Nonnull BlockPos pos, BlockState stateNew, boolean isMoving) {
        if (!stateOld.m_60713_(stateNew.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof WoodenCrateBlockEntity) {
                level.m_46717_(pos, stateOld.m_60734_());
            }
            super.m_6810_(stateOld, level, pos, stateNew, isMoving);
        }
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter blockGetter, @Nonnull List<Component> components, @Nonnull TooltipFlag tooltipFlag) {
        super.m_5871_(stack, blockGetter, components, tooltipFlag);
        CompoundTag compoundTag = BlockItem.m_186336_((ItemStack)stack);
        if (compoundTag != null) {
            if (compoundTag.m_128425_("LootTable", 8)) {
                components.add((Component)Component.m_237113_((String)"???????"));
            }
            if (compoundTag.m_128425_("Items", 9)) {
                NonNullList stacks = NonNullList.m_122780_((int)15, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)stacks);
                int i = 0;
                int j = 0;
                for (ItemStack stack1 : stacks) {
                    if (stack1.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent hoverName = stack1.m_41786_().m_6881_();
                    hoverName.m_130946_(" x").m_130946_(String.valueOf(stack1.m_41613_()));
                    components.add((Component)hoverName);
                }
                if (j - i > 0) {
                    components.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        }
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter blockGetter, @Nonnull BlockPos blockPos, @Nonnull CollisionContext collisionContext) {
        return SHAPE;
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter blockGetter, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        ItemStack stack = super.m_7397_(blockGetter, pos, state);
        blockGetter.m_141902_(pos, (BlockEntityType)WoodenBlockEntityTypes.WOODEN_CRATE.get()).ifPresent(blockEntity -> blockEntity.m_187476_(stack));
        return stack;
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new WoodenCrateBlockEntity(pos, state);
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }
}

