/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import yamahari.ilikewood.block.WoodenBlock;
import yamahari.ilikewood.menu.WoodenSawmillMenu;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

public final class WoodenSawmillBlock
extends WoodenBlock {
    public static final EnumProperty<WoodenSawmillModel> MODEL = EnumProperty.m_61587_((String)"model", WoodenSawmillModel.class);
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.f_61374_;
    private static final Map<WoodenSawmillModel, Map<Direction, VoxelShape>> SHAPES;
    private final Component containerName;

    public WoodenSawmillBlock(IWoodType woodType) {
        super(woodType, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(MODEL, (Comparable)((Object)WoodenSawmillModel.BOTTOM_LEFT))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
        this.containerName = Component.m_237115_((String)StringUtils.joinWith((String)".", (Object[])new Object[]{"container", "ilikewood", Util.toRegistryName(this.getWoodType().getName(), WoodenBlockType.SAWMILL.getName())}));
    }

    private static Direction getDirectionToNext(WoodenSawmillModel model, Direction facing) {
        return switch (model) {
            default -> throw new IncompatibleClassChangeError();
            case WoodenSawmillModel.BOTTOM_LEFT -> facing.m_122427_();
            case WoodenSawmillModel.BOTTOM_RIGHT -> Direction.UP;
            case WoodenSawmillModel.TOP_LEFT -> Direction.DOWN;
            case WoodenSawmillModel.TOP_RIGHT -> facing.m_122428_();
        };
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor world, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        WoodenSawmillModel model = (WoodenSawmillModel)((Object)state.m_61143_(MODEL));
        if (facing == WoodenSawmillBlock.getDirectionToNext((WoodenSawmillModel)((Object)state.m_61143_(MODEL)), (Direction)state.m_61143_((Property)HORIZONTAL_FACING))) {
            return facingState.m_60713_((Block)this) && model != facingState.m_61143_(MODEL) ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPES.get(state.m_61143_(MODEL)).get(state.m_61143_((Property)HORIZONTAL_FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODEL, HORIZONTAL_FACING});
    }

    public void m_6402_(Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState state, LivingEntity placer, @Nonnull ItemStack stack) {
        if (!worldIn.f_46443_) {
            Direction direction = (Direction)state.m_61143_((Property)HORIZONTAL_FACING);
            BlockPos bottomRight = pos.m_121945_(direction.m_122427_());
            BlockPos topLeft = pos.m_7494_();
            BlockPos topRight = bottomRight.m_7494_();
            worldIn.m_7731_(bottomRight, (BlockState)state.m_61124_(MODEL, (Comparable)((Object)WoodenSawmillModel.BOTTOM_RIGHT)), 3);
            worldIn.m_7731_(topLeft, (BlockState)state.m_61124_(MODEL, (Comparable)((Object)WoodenSawmillModel.TOP_LEFT)), 3);
            worldIn.m_7731_(topRight, (BlockState)state.m_61124_(MODEL, (Comparable)((Object)WoodenSawmillModel.TOP_RIGHT)), 3);
            worldIn.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)worldIn, pos, 3);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_();
        BlockPos bottomLeft = context.m_8083_();
        BlockPos bottomRight = bottomLeft.m_121945_(direction.m_122427_());
        BlockPos topLeft = bottomLeft.m_7494_();
        BlockPos topRight = bottomRight.m_7494_();
        return Stream.of(bottomRight, topLeft, topRight).allMatch(blockPos -> context.m_43725_().m_8055_(blockPos).m_60629_(context)) ? (BlockState)((BlockState)this.m_49966_().m_61124_(MODEL, (Comparable)((Object)WoodenSawmillModel.BOTTOM_LEFT))).m_61124_((Property)HORIZONTAL_FACING, (Comparable)direction) : null;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        player.m_5893_(state.m_60750_(world, pos));
        return InteractionResult.CONSUME;
    }

    public MenuProvider m_7246_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos) {
        return new SimpleMenuProvider((id, inventory, player) -> new WoodenSawmillMenu(id, inventory, ContainerLevelAccess.m_39289_((Level)world, (BlockPos)pos)), this.containerName);
    }

    static {
        EnumMap shapes = new EnumMap(WoodenSawmillModel.class);
        EnumMap bottomLeftShapes = new EnumMap(Direction.class);
        EnumMap bottomRightShapes = new EnumMap(Direction.class);
        EnumMap topLeftShapes = new EnumMap(Direction.class);
        EnumMap topRightShapes = new EnumMap(Direction.class);
        VoxelShape tableTop = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape legNW = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)13.0, (double)3.0);
        VoxelShape legSw = Block.m_49796_((double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)13.0, (double)15.0);
        VoxelShape legNe = Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)3.0);
        VoxelShape legSe = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)15.0, (double)13.0, (double)15.0);
        VoxelShape crossBeamLeftN = Block.m_49796_((double)3.0, (double)10.0, (double)1.5, (double)16.0, (double)12.0, (double)2.5);
        VoxelShape crossBeamLeftS = Block.m_49796_((double)3.0, (double)10.0, (double)13.5, (double)16.0, (double)12.0, (double)14.5);
        VoxelShape crossBeamLeftW = Block.m_49796_((double)1.5, (double)2.0, (double)3.0, (double)2.5, (double)4.0, (double)13.0);
        VoxelShape crossBeamRightN = Block.m_49796_((double)0.0, (double)10.0, (double)1.5, (double)13.0, (double)12.0, (double)2.5);
        VoxelShape crossBeamRightS = Block.m_49796_((double)0.0, (double)10.0, (double)13.5, (double)13.0, (double)12.0, (double)14.5);
        VoxelShape crossBeamRightE = Block.m_49796_((double)13.5, (double)2.0, (double)3.0, (double)14.5, (double)4.0, (double)13.0);
        VoxelShape logPile0Left = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)4.0, (double)16.0);
        VoxelShape logPile1Left = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
        VoxelShape logPile2Left = Block.m_49796_((double)4.0, (double)3.0, (double)10.0, (double)16.0, (double)7.0, (double)14.0);
        VoxelShape logPile3Left = Block.m_49796_((double)4.0, (double)3.0, (double)2.0, (double)16.0, (double)7.0, (double)6.0);
        VoxelShape logPile0Right = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)4.0, (double)16.0);
        VoxelShape logPile1Right = Block.m_49796_((double)0.0, (double)3.0, (double)10.0, (double)4.0, (double)7.0, (double)14.0);
        VoxelShape logPile2Right = Block.m_49796_((double)0.0, (double)3.0, (double)2.0, (double)4.0, (double)7.0, (double)6.0);
        VoxelShape logPileLeft = Shapes.m_83124_((VoxelShape)logPile0Left, (VoxelShape[])new VoxelShape[]{logPile1Left, logPile2Left, logPile3Left});
        VoxelShape logPileRight = Shapes.m_83124_((VoxelShape)logPile0Right, (VoxelShape[])new VoxelShape[]{logPile1Right, logPile2Right});
        VoxelShape bottomLeft = Shapes.m_83124_((VoxelShape)tableTop, (VoxelShape[])new VoxelShape[]{legNW, legSw, crossBeamLeftN, crossBeamLeftS, crossBeamLeftW, logPileLeft});
        VoxelShape bottomRight = Shapes.m_83124_((VoxelShape)tableTop, (VoxelShape[])new VoxelShape[]{legNe, legSe, crossBeamRightN, crossBeamRightS, crossBeamRightE, logPileRight});
        VoxelShape topLeft = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape topRight = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)5.0, (double)8.0);
        Direction.Plane.HORIZONTAL.m_122557_().forEach(direction -> {
            bottomLeftShapes.put((Direction)direction, Util.rotateShape(Direction.NORTH, direction, bottomLeft));
            bottomRightShapes.put((Direction)direction, Util.rotateShape(Direction.NORTH, direction, bottomRight));
            topLeftShapes.put((Direction)direction, Util.rotateShape(Direction.NORTH, direction, topLeft));
            topRightShapes.put((Direction)direction, Util.rotateShape(Direction.NORTH, direction, topRight));
        });
        shapes.put(WoodenSawmillModel.BOTTOM_LEFT, bottomLeftShapes);
        shapes.put(WoodenSawmillModel.BOTTOM_RIGHT, bottomRightShapes);
        shapes.put(WoodenSawmillModel.TOP_LEFT, topLeftShapes);
        shapes.put(WoodenSawmillModel.TOP_RIGHT, topRightShapes);
        SHAPES = Collections.unmodifiableMap(shapes);
    }

    public static enum WoodenSawmillModel implements StringRepresentable
    {
        BOTTOM_LEFT("bottom_left"),
        BOTTOM_RIGHT("bottom_right"),
        TOP_LEFT("top_left"),
        TOP_RIGHT("top_right");

        private final String name;

        private WoodenSawmillModel(String name) {
            this.name = name;
        }

        @Nonnull
        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

