/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import yamahari.ilikewood.data.tag.ILikeWoodItemTags;
import yamahari.ilikewood.item.WoodenScaffoldingItem;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public final class WoodenScaffoldingBlock
extends ScaffoldingBlock
implements IWooden {
    final IWoodType woodType;

    public WoodenScaffoldingBlock(IWoodType woodType) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50616_));
        this.woodType = woodType;
    }

    public static int getDistance(BlockGetter reader, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()).m_122173_(Direction.DOWN);
        BlockState state = reader.m_8055_((BlockPos)mutable);
        int distance = 7;
        if (state.m_60734_() instanceof ScaffoldingBlock) {
            distance = (Integer)state.m_61143_((Property)f_56012_);
        } else if (state.m_60783_(reader, (BlockPos)mutable, Direction.UP)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState translatedState = reader.m_8055_((BlockPos)mutable.m_122190_((Vec3i)pos).m_122173_(direction));
            if (!(translatedState.m_60734_() instanceof ScaffoldingBlock) || (distance = Math.min(distance, (Integer)translatedState.m_61143_((Property)f_56012_) + 1)) != 1) continue;
            break;
        }
        return distance;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter reader, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entityCollisionContext = (EntityCollisionContext)context;
            if (entityCollisionContext.f_82868_.m_204117_(ILikeWoodItemTags.SCAFFOLDINGS)) {
                return Shapes.m_83144_();
            }
        }
        return (Boolean)state.m_61143_((Property)f_56014_) != false ? f_56016_ : f_56015_;
    }

    public void m_213897_(BlockState state, @Nonnull ServerLevel world, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        int distance = WoodenScaffoldingBlock.getDistance((BlockGetter)world, pos);
        BlockState blockState = (BlockState)((BlockState)state.m_61124_((Property)f_56012_, (Comparable)Integer.valueOf(distance))).m_61124_((Property)f_56014_, (Comparable)Boolean.valueOf(this.m_56027_((BlockGetter)world, pos, distance)));
        if ((Integer)blockState.m_61143_((Property)f_56012_) == 7) {
            if ((Integer)state.m_61143_((Property)f_56012_) == 7) {
                FallingBlockEntity.m_201971_((Level)world, (BlockPos)pos, (BlockState)blockState);
            } else {
                world.m_46961_(pos, true);
            }
        } else if (state != blockState) {
            world.m_7731_(pos, blockState, 3);
        }
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos) {
        return WoodenScaffoldingBlock.getDistance((BlockGetter)world, pos) < 7;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        int distance = WoodenScaffoldingBlock.getDistance((BlockGetter)world, blockpos);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56013_, (Comparable)Boolean.valueOf(world.m_6425_(blockpos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_56012_, (Comparable)Integer.valueOf(distance))).m_61124_((Property)f_56014_, (Comparable)Boolean.valueOf(this.m_56027_((BlockGetter)world, blockpos, distance)));
    }

    public boolean isScaffolding(BlockState state, LevelReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    protected boolean m_56027_(@Nonnull BlockGetter getter, @Nonnull BlockPos pos, int distance) {
        return distance > 0 && !(getter.m_8055_(pos.m_7495_()).m_60734_() instanceof WoodenScaffoldingBlock);
    }

    public boolean m_6864_(@Nonnull BlockState blockState, @Nonnull BlockPlaceContext context) {
        return context.m_43722_().m_41720_() instanceof WoodenScaffoldingItem;
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }
}

