/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenBlock;
import yamahari.ilikewood.entity.WoodenChairEntity;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class WoodenStoolBlock
extends WoodenBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE;

    public WoodenStoolBlock(IWoodType woodType) {
        super(woodType, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.0f));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        List entities = level.m_45976_(WoodenChairEntity.class, new AABB(pos));
        if (entities.isEmpty()) {
            WoodenChairEntity entity = new WoodenChairEntity((EntityType)ILikeWood.ENTITY_TYPE_REGISTRY.getObject(this.getWoodType(), WoodenEntityType.CHAIR), level);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 0.5);
            level.m_7967_((Entity)entity);
            player.m_20329_((Entity)entity);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static {
        VoxelShape seat = Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
        VoxelShape frontLeftLeg = Block.m_49796_((double)11.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)5.0);
        VoxelShape frontRightLeg = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)5.0, (double)6.0, (double)5.0);
        VoxelShape rearLeftLeg = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)13.0, (double)6.0, (double)13.0);
        VoxelShape rearRightLeg = Block.m_49796_((double)3.0, (double)0.0, (double)11.0, (double)5.0, (double)6.0, (double)13.0);
        VoxelShape westCrossBeam = Block.m_49796_((double)11.5, (double)1.0, (double)5.0, (double)12.5, (double)3.0, (double)11.0);
        VoxelShape eastCrossBeam = Block.m_49796_((double)3.5, (double)1.0, (double)5.0, (double)4.5, (double)3.0, (double)11.0);
        VoxelShape southCrossBeam = Block.m_49796_((double)5.0, (double)1.0, (double)3.5, (double)11.0, (double)3.0, (double)4.5);
        VoxelShape northCrossBeam = Block.m_49796_((double)5.0, (double)1.0, (double)11.5, (double)11.0, (double)3.0, (double)12.5);
        SHAPE = Shapes.m_83124_((VoxelShape)seat, (VoxelShape[])new VoxelShape[]{frontLeftLeg, frontRightLeg, rearLeftLeg, rearRightLeg, westCrossBeam, eastCrossBeam, southCrossBeam, northCrossBeam});
    }
}

