/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.block.post;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public class WoodenStrippedPostBlock
extends RotatedPillarBlock
implements IWooden,
SimpleWaterloggedBlock {
    public static final BooleanProperty NORTH;
    public static final BooleanProperty EAST;
    public static final BooleanProperty SOUTH;
    public static final BooleanProperty WEST;
    public static final BooleanProperty UP;
    public static final BooleanProperty DOWN;
    public static final BooleanProperty WATERLOGGED;
    private static final Direction[] FACING_VALUES;
    private static final VoxelShape[] VERTICAL_AABBS;
    private static final VoxelShape[] NS_AABBS;
    private static final VoxelShape[] EW_AABBS;
    private final IWoodType woodType;

    public WoodenStrippedPostBlock(IWoodType woodType) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        this.woodType = woodType;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)Direction.Axis.Y)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] createShapes(VoxelShape post, VoxelShape[] sides, Direction.Axis axis) {
        VoxelShape[] shapes = new VoxelShape[16];
        for (int i = 0; i < shapes.length; ++i) {
            int offset = 0;
            VoxelShape shape = post;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if (FACING_VALUES[j].m_122434_() == axis) continue;
                if ((i & 1 << offset) != 0) {
                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)sides[j]);
                }
                ++offset;
            }
            shapes[i] = shape;
        }
        return shapes;
    }

    private static VoxelShape getVoxelShape(BlockState blockState) {
        int i = 0;
        int offset = 0;
        Direction.Axis axis = (Direction.Axis)blockState.m_61143_((Property)f_55923_);
        for (Direction direction : FACING_VALUES) {
            if (axis == direction.m_122434_()) continue;
            if (((Boolean)blockState.m_61143_((Property)PipeBlock.f_55154_.get(direction))).booleanValue()) {
                i |= 1 << offset;
            }
            ++offset;
        }
        switch (axis) {
            default: {
                return EW_AABBS[i];
            }
            case Z: {
                return NS_AABBS[i];
            }
            case Y: 
        }
        return VERTICAL_AABBS[i];
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, WATERLOGGED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos blockPos, @Nonnull CollisionContext selectionContext) {
        return WoodenStrippedPostBlock.getVoxelShape(blockState);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState blockState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos blockPos, @Nonnull CollisionContext selectionContext) {
        return WoodenStrippedPostBlock.getVoxelShape(blockState);
    }

    public BlockState m_5573_(BlockPlaceContext blockItemUseContext) {
        Level blockReader = blockItemUseContext.m_43725_();
        BlockPos blockPos = blockItemUseContext.m_8083_();
        Block down = blockReader.m_8055_(blockPos.m_7495_()).m_60734_();
        Block up = blockReader.m_8055_(blockPos.m_7494_()).m_60734_();
        Block north = blockReader.m_8055_(blockPos.m_122012_()).m_60734_();
        Block east = blockReader.m_8055_(blockPos.m_122029_()).m_60734_();
        Block south = blockReader.m_8055_(blockPos.m_122019_()).m_60734_();
        Block west = blockReader.m_8055_(blockPos.m_122024_()).m_60734_();
        FluidState fluidState = blockItemUseContext.m_43725_().m_6425_(blockItemUseContext.m_8083_());
        Direction.Axis axis = blockItemUseContext.m_43719_().m_122434_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55923_, (Comparable)blockItemUseContext.m_43719_().m_122434_())).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down instanceof WoodenStrippedPostBlock && axis != Direction.Axis.Y))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(up instanceof WoodenStrippedPostBlock && axis != Direction.Axis.Y))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north instanceof WoodenStrippedPostBlock && axis != Direction.Axis.Z))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east instanceof WoodenStrippedPostBlock && axis != Direction.Axis.X))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south instanceof WoodenStrippedPostBlock && axis != Direction.Axis.Z))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west instanceof WoodenStrippedPostBlock && axis != Direction.Axis.X))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public BlockState m_7417_(BlockState blockState0, @Nonnull Direction direction, BlockState blockState1, @Nonnull LevelAccessor world, @Nonnull BlockPos blockPos, @Nonnull BlockPos blockPos1) {
        return (BlockState)blockState0.m_61124_((Property)PipeBlock.f_55154_.get(direction), (Comparable)Boolean.valueOf(blockState1.m_60734_() instanceof WoodenStrippedPostBlock && direction.m_122434_() != blockState0.m_61143_((Property)f_55923_)));
    }

    static {
        FACING_VALUES = Direction.values();
        WATERLOGGED = BlockStateProperties.f_61362_;
        NORTH = BlockStateProperties.f_61368_;
        EAST = BlockStateProperties.f_61369_;
        SOUTH = BlockStateProperties.f_61370_;
        WEST = BlockStateProperties.f_61371_;
        UP = BlockStateProperties.f_61366_;
        DOWN = BlockStateProperties.f_61367_;
        VoxelShape verticalPost = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape nsPost = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape ewPost = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        double apothem = 0.25;
        VoxelShape[] sides = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            sides[i] = Shapes.m_83048_((double)(0.5 + Math.min(-0.25, (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.min(-0.25, (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.min(-0.25, (double)direction.m_122431_() * 0.5)), (double)(0.5 + Math.max(0.25, (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.max(0.25, (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.max(0.25, (double)direction.m_122431_() * 0.5)));
        }
        VERTICAL_AABBS = WoodenStrippedPostBlock.createShapes(verticalPost, sides, Direction.Axis.Y);
        NS_AABBS = WoodenStrippedPostBlock.createShapes(nsPost, sides, Direction.Axis.Z);
        EW_AABBS = WoodenStrippedPostBlock.createShapes(ewPost, sides, Direction.Axis.X);
    }
}

