/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.client;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.config.ILikeWoodConfig;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class Atlases {
    private static Map<IWoodType, Map<ChestType, Material>> CHESTS;

    private Atlases() {
    }

    private static Map<ChestType, Material> makeChestMaterials(IWoodType woodType) {
        EnumMap<ChestType, Material> materials = new EnumMap<ChestType, Material>(ChestType.class);
        for (ChestType chestType : ChestType.values()) {
            materials.put(chestType, new Material(Sheets.f_110740_, new ResourceLocation("ilikewood", Util.toPath("entity", "chest", woodType.getModId(), chestType.m_7912_(), woodType.getName()))));
        }
        return materials;
    }

    public static Map<ChestType, Material> getChestMaterials(IWoodType woodType) {
        return CHESTS.get(woodType);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        HashMap chests = new HashMap();
        if (ILikeWoodConfig.CHESTS_CONFIG.isEnabled()) {
            ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getBlockTypes().contains(WoodenBlockType.CHEST)).forEach(woodType -> chests.put(woodType, Atlases.makeChestMaterials(woodType)));
        }
        CHESTS = Collections.unmodifiableMap(chests);
        ResourceLocation atlas = event.getAtlas().m_118330_();
        CHESTS.values().stream().flatMap(materials -> materials.values().stream()).filter(material -> material.m_119193_().equals((Object)atlas)).forEach(material -> event.addSprite(material.m_119203_()));
    }
}

