/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.client;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.config.ILikeWoodConfig;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.Util;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ilikewood", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class SpecialModels {
    public static Map<IWoodType, ResourceLocation> ITEM_FRAME_MODELS;
    public static Map<IWoodType, ResourceLocation> ITEM_FRAME_MAP_MODELS;

    private SpecialModels() {
    }

    @SubscribeEvent
    public static void onRegisterAdditionalModel(ModelEvent.RegisterAdditional event) {
        HashMap itemFrameModels = new HashMap();
        HashMap itemFrameMapModels = new HashMap();
        if (ILikeWoodConfig.ITEM_FRAMES_CONFIG.isEnabled()) {
            ILikeWood.WOOD_TYPE_REGISTRY.getWoodTypes().filter(woodType -> woodType.getItemTypes().contains(WoodenItemType.ITEM_FRAME)).forEach(woodType -> {
                String path = Util.toPath("block", WoodenItemType.ITEM_FRAME.getName());
                itemFrameModels.put(woodType, new ResourceLocation("ilikewood", Util.toPath(path, woodType.getModId(), woodType.getName())));
                itemFrameMapModels.put(woodType, new ResourceLocation("ilikewood", Util.toPath(path, woodType.getModId(), "map", woodType.getName())));
            });
        }
        ITEM_FRAME_MODELS = Collections.unmodifiableMap(itemFrameModels);
        ITEM_FRAME_MAP_MODELS = Collections.unmodifiableMap(itemFrameMapModels);
        Stream.of(ITEM_FRAME_MAP_MODELS.entrySet(), ITEM_FRAME_MODELS.entrySet()).flatMap(Collection::stream).map(Map.Entry::getValue).forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }
}

