/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.client.blockentity;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.block.WoodenCrateBlock;
import yamahari.ilikewood.menu.WoodenCrateMenu;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodTypes;
import yamahari.ilikewood.registry.WoodenBlockEntityTypes;
import yamahari.ilikewood.registry.objecttype.WoodenBlockType;

public class WoodenCrateBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS = IntStream.range(0, 15).toArray();
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            WoodenCrateBlockEntity.this.playSound(state, SoundEvents.f_11725_);
        }

        protected void m_142289_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            WoodenCrateBlockEntity.this.playSound(state, SoundEvents.f_11724_);
        }

        protected void m_142148_(@Nonnull Level level, @Nonnull BlockPos blockPos, @Nonnull BlockState state, int count, int openCount) {
        }

        protected boolean m_142718_(@Nonnull Player player) {
            if (player.f_36096_ instanceof WoodenCrateMenu) {
                Container container = ((WoodenCrateMenu)player.f_36096_).getContainer();
                return container == WoodenCrateBlockEntity.this;
            }
            return false;
        }
    };
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)15, (Object)ItemStack.f_41583_);

    public WoodenCrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)WoodenBlockEntityTypes.WOODEN_CRATE.get(), pos, state);
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    @Nonnull
    protected Component m_6820_() {
        Block block = this.m_58900_().m_60734_();
        String path = block instanceof WoodenCrateBlock ? ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() : ForgeRegistries.BLOCKS.getKey((Object)((Block)ILikeWood.BLOCK_REGISTRY.getObject(VanillaWoodTypes.OAK, WoodenBlockType.CRATE))).m_135815_();
        return Component.m_237115_((String)StringUtils.joinWith((String)".", (Object[])new Object[]{"container", "ilikewood", path}));
    }

    public void m_142466_(@Nonnull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.loadFromTag(compoundTag);
    }

    protected void m_183515_(@Nonnull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        if (!this.m_59634_(compoundTag)) {
            ContainerHelper.m_18976_((CompoundTag)compoundTag, this.stacks, (boolean)false);
        }
    }

    public void loadFromTag(CompoundTag compoundTag) {
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(compoundTag) && compoundTag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)compoundTag, this.stacks);
        }
    }

    @Nonnull
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(@Nonnull NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction direction) {
        return SLOTS;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction direction) {
        return !(Block.m_49814_((Item)stack.m_41720_()) instanceof WoodenCrateBlock) && stack.m_41720_().m_142095_();
    }

    public boolean m_7157_(int slot, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return true;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory inventory) {
        return new WoodenCrateMenu(id, inventory, (Container)this);
    }

    public void m_5856_(@Nonnull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@Nonnull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    @Nonnull
    protected IItemHandler createUnSidedHandler() {
        return new SidedInvWrapper((WorldlyContainer)this, Direction.UP);
    }

    private void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BarrelBlock.f_49042_)).m_122436_();
        double d0 = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double d1 = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double d2 = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d0, d1, d2, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

