/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import yamahari.ilikewood.client.SpecialModels;
import yamahari.ilikewood.entity.WoodenItemFrameEntity;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public class WoodenItemFrameRenderer
extends EntityRenderer<WoodenItemFrameEntity> {
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer;

    public WoodenItemFrameRenderer(EntityRendererProvider.Context context, ItemRenderer itemRendererIn) {
        super(context);
        this.itemRenderer = itemRendererIn;
    }

    public void render(@Nonnull WoodenItemFrameEntity itemFrame, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7392_((Entity)itemFrame, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85836_();
        Direction direction = itemFrame.m_6350_();
        Vec3 renderOffset = this.getRenderOffset(itemFrame, partialTicks);
        matrixStackIn.m_85837_(-renderOffset.m_7096_(), -renderOffset.m_7098_(), -renderOffset.m_7094_());
        double d0 = 0.46875;
        matrixStackIn.m_85837_((double)direction.m_122429_() * 0.46875, (double)direction.m_122430_() * 0.46875, (double)direction.m_122431_() * 0.46875);
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(itemFrame.m_146909_()));
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - itemFrame.m_146908_()));
        boolean invisible = itemFrame.m_20145_();
        ItemStack displayedItem = itemFrame.m_31822_();
        if (!invisible) {
            BlockRenderDispatcher dispatcher = this.mc.m_91289_();
            ModelManager manager = dispatcher.m_110907_().m_110881_();
            IWoodType woodType = itemFrame.getWoodType();
            ResourceLocation location = displayedItem.m_41720_() instanceof MapItem ? SpecialModels.ITEM_FRAME_MAP_MODELS.get(woodType) : SpecialModels.ITEM_FRAME_MODELS.get(woodType);
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
            dispatcher.m_110937_().m_111067_(matrixStackIn.m_85850_(), bufferIn.m_6299_(Sheets.m_110789_()), null, manager.getModel(location), 1.0f, 1.0f, 1.0f, packedLightIn, OverlayTexture.f_118083_);
            matrixStackIn.m_85849_();
        }
        if (!displayedItem.m_41619_()) {
            MapItemSavedData mapdata = MapItem.m_42853_((ItemStack)displayedItem, (Level)itemFrame.f_19853_);
            if (mapdata != null) {
                if (invisible) {
                    matrixStackIn.m_85837_(0.0, 0.0, 0.5);
                } else {
                    matrixStackIn.m_85837_(0.0, 0.0, 0.4375);
                }
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)(itemFrame.m_31823_() % 4 * 2) * 360.0f / 8.0f));
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                float f = 0.0078125f;
                matrixStackIn.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
                matrixStackIn.m_85837_(-64.0, -64.0, 0.0);
                Integer mapId = MapItem.m_151131_((ItemStack)displayedItem);
                matrixStackIn.m_85837_(0.0, 0.0, -1.0);
                this.mc.f_91063_.m_109151_().m_168771_(matrixStackIn, bufferIn, mapId.intValue(), mapdata, true, packedLightIn);
            } else {
                if (direction == Direction.DOWN || direction == Direction.UP) {
                    matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_((float)itemFrame.m_31823_() * 360.0f / 8.0f));
                } else {
                    if (invisible) {
                        matrixStackIn.m_85837_(0.0, 0.0, 0.5);
                    } else {
                        matrixStackIn.m_85837_(0.0, 0.0, 0.4375);
                    }
                    matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_((float)itemFrame.m_31823_() * 360.0f / 8.0f));
                }
                matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
                this.itemRenderer.m_174269_(displayedItem, ItemTransforms.TransformType.FIXED, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, itemFrame.m_19879_());
            }
        }
        matrixStackIn.m_85849_();
    }

    @Nonnull
    public Vec3 getRenderOffset(WoodenItemFrameEntity entityIn, float partialTicks) {
        return new Vec3((double)((float)entityIn.m_6350_().m_122429_() * 0.3f), -0.25, (double)((float)entityIn.m_6350_().m_122431_() * 0.3f));
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull WoodenItemFrameEntity entity) {
        return TextureAtlas.f_118259_;
    }

    protected boolean shouldShowName(@Nonnull WoodenItemFrameEntity entity) {
        if (Minecraft.m_91404_() && !entity.m_31822_().m_41619_() && entity.m_31822_().m_41788_() && this.f_114476_.f_114359_ == entity) {
            double d0 = this.f_114476_.m_114471_((Entity)entity);
            float f = entity.m_20163_() ? 32.0f : 64.0f;
            return d0 < (double)(f * f);
        }
        return false;
    }

    protected void renderNameTag(@Nonnull WoodenItemFrameEntity entityIn, @Nonnull Component displayNameIn, @Nonnull PoseStack matrixStackIn, @Nonnull MultiBufferSource bufferIn, int packedLightIn) {
        super.m_7649_((Entity)entityIn, entityIn.m_31822_().m_41611_(), matrixStackIn, bufferIn, packedLightIn);
    }
}

