/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.entity.WoodenPaintingEntity;
import yamahari.ilikewood.registry.resource.resources.IWoodenPlanksResource;

public final class WoodenPaintingRenderer
extends PaintingRenderer {
    public WoodenPaintingRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void m_7392_(@Nonnull Painting painting, float p_115553_, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource multiBufferSource, int packedLight) {
        WoodenPaintingEntity woodenPaintingEntity;
        IWoodenPlanksResource planks;
        if (painting instanceof WoodenPaintingEntity && (planks = ILikeWood.WOODEN_RESOURCE_REGISTRY.getPlanks((woodenPaintingEntity = (WoodenPaintingEntity)painting).getWoodType())) != null) {
            poseStack.m_85836_();
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - p_115553_));
            PaintingVariant variant = (PaintingVariant)painting.m_218901_().m_203334_();
            poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
            PaintingTextureManager textureManager = Minecraft.m_91087_().m_91305_();
            this.renderWoodenPainting(poseStack, painting, multiBufferSource, variant.m_218908_(), variant.m_218909_(), textureManager.m_235033_(variant), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(planks.getTexture()));
            poseStack.m_85849_();
        }
        RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent((Entity)painting, painting.m_5446_(), (EntityRenderer)this, poseStack, multiBufferSource, packedLight, partialTick);
        MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
        if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Entity)painting))) {
            this.m_7649_((Entity)painting, renderNameTagEvent.getContent(), poseStack, multiBufferSource, packedLight);
        }
    }

    private void renderWoodenPainting(PoseStack poseStack, Painting painting, MultiBufferSource multiBufferSource, int width, int height, TextureAtlasSprite image, TextureAtlasSprite frame) {
        PoseStack.Pose lastPose = poseStack.m_85850_();
        Matrix4f pose = lastPose.m_85861_();
        Matrix3f normal = lastPose.m_85864_();
        float halfWidth = (float)(-width) / 2.0f;
        float halfHeight = (float)(-height) / 2.0f;
        float frameU0 = frame.m_118409_();
        float frameU1 = frame.m_118410_();
        float frameV0 = frame.m_118411_();
        float frameV1 = frame.m_118412_();
        float f10 = frame.m_118393_(1.0);
        float f12 = frame.m_118367_(1.0);
        int stepsX = width / 16;
        int stepsY = height / 16;
        double deltaX = 16.0 / (double)stepsX;
        double deltaY = 16.0 / (double)stepsY;
        for (int stepX = 0; stepX < stepsX; ++stepX) {
            for (int stepY = 0; stepY < stepsY; ++stepY) {
                float x0 = halfWidth + (float)((stepX + 1) * 16);
                float x1 = halfWidth + (float)(stepX * 16);
                float y0 = halfHeight + (float)((stepY + 1) * 16);
                float y1 = halfHeight + (float)(stepY * 16);
                int lightX = painting.m_146903_();
                int lightY = Mth.m_14107_((double)(painting.m_20186_() + (double)((y0 + y1) / 2.0f / 16.0f)));
                int lightZ = painting.m_146907_();
                Direction direction = painting.m_6350_();
                if (direction == Direction.NORTH) {
                    lightX = Mth.m_14107_((double)(painting.m_20185_() + (double)((x0 + x1) / 2.0f / 16.0f)));
                } else if (direction == Direction.WEST) {
                    lightZ = Mth.m_14107_((double)(painting.m_20189_() - (double)((x0 + x1) / 2.0f / 16.0f)));
                } else if (direction == Direction.SOUTH) {
                    lightX = Mth.m_14107_((double)(painting.m_20185_() - (double)((x0 + x1) / 2.0f / 16.0f)));
                } else if (direction == Direction.EAST) {
                    lightZ = Mth.m_14107_((double)(painting.m_20189_() + (double)((x0 + x1) / 2.0f / 16.0f)));
                }
                boolean skipTop = stepY == stepsY - 1;
                boolean skipLeft = stepX == stepsX - 1;
                boolean skipBottom = stepY == 0;
                boolean skipRight = stepX == 0;
                float xx1 = skipRight ? x1 + 1.0f : x1;
                float xx0 = skipLeft ? x0 - 1.0f : x0;
                float yy1 = skipBottom ? y1 + 1.0f : y1;
                float yy0 = skipTop ? y0 - 1.0f : y0;
                int lightColor = LevelRenderer.m_109541_((BlockAndTintGetter)painting.f_19853_, (BlockPos)new BlockPos(lightX, lightY, lightZ));
                float du = (image.m_118410_() - image.m_118409_()) / (float)width;
                float dv = (image.m_118412_() - image.m_118411_()) / (float)height;
                float imageU0 = image.m_118367_(deltaX * (double)(stepsX - stepX));
                float imageU1 = image.m_118367_(deltaX * (double)(stepsX - (stepX + 1)));
                float imageV0 = image.m_118393_(deltaY * (double)(stepsY - stepY));
                float imageV1 = image.m_118393_(deltaY * (double)(stepsY - (stepY + 1)));
                if (skipLeft) {
                    imageU1 += du;
                }
                if (skipRight) {
                    imageU0 -= du;
                }
                if (skipBottom) {
                    imageV0 -= dv;
                }
                if (skipTop) {
                    imageV1 += dv;
                }
                VertexConsumer consumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)this.m_5478_(painting)));
                this.m_115536_(pose, normal, consumer, xx0, yy1, imageU1, imageV0, -0.6f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, xx1, yy1, imageU0, imageV0, -0.6f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, xx1, yy0, imageU0, imageV1, -0.6f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, xx0, yy0, imageU1, imageV1, -0.6f, 0, 0, -1, lightColor);
                consumer = multiBufferSource.m_6299_(RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_));
                this.m_115536_(pose, normal, consumer, x0, y1, frameU0, frameV1, -0.5f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, frameU1, frameV1, -0.5f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, frameU1, frameV0, -0.5f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, frameU0, frameV0, -0.5f, 0, 0, -1, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, frameU1, frameV0, 0.5f, 0, 0, 1, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, frameU0, frameV0, 0.5f, 0, 0, 1, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, frameU0, frameV1, 0.5f, 0, 0, 1, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y1, frameU1, frameV1, 0.5f, 0, 0, 1, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, frameU0, frameV0, -0.5f, 0, 1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, frameU1, frameV0, -0.5f, 0, 1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, frameU1, f10, 0.5f, 0, 1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, frameU0, f10, 0.5f, 0, 1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y1, frameU0, frameV0, 0.5f, 0, -1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, frameU1, frameV0, 0.5f, 0, -1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, frameU1, f10, -0.5f, 0, -1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y1, frameU0, f10, -0.5f, 0, -1, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, f12, frameV0, 0.5f, -1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y1, f12, frameV1, 0.5f, -1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y1, frameU0, frameV1, -0.5f, -1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x0, y0, frameU0, frameV0, -0.5f, -1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, f12, frameV0, -0.5f, 1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, f12, frameV1, -0.5f, 1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y1, frameU0, frameV1, 0.5f, 1, 0, 0, lightColor);
                this.m_115536_(pose, normal, consumer, x1, y0, frameU0, frameV0, 0.5f, 1, 0, 0, lightColor);
            }
        }
    }
}

