/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.config;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.data.loading.DatagenModLoader;
import org.apache.commons.lang3.tuple.Pair;

public record ILikeWoodConfig(String name, Supplier<Boolean> flag) {
    public static final ILikeWoodConfig PANELS_CONFIG = ILikeWoodConfig.make("panels");
    public static final ILikeWoodConfig PANELS_STAIRS_CONFIG = ILikeWoodConfig.make("panels_stairs");
    public static final ILikeWoodConfig PANELS_SLABS_CONFIG = ILikeWoodConfig.make("panels_slabs");
    public static final ILikeWoodConfig BARRELS_CONFIG = ILikeWoodConfig.make("barrels");
    public static final ILikeWoodConfig BEDS_CONFIG = ILikeWoodConfig.make("beds");
    public static final ILikeWoodConfig BOOKSHELVES_CONFIG = ILikeWoodConfig.make("bookshelves");
    public static final ILikeWoodConfig COMPOSTERS_CONFIG = ILikeWoodConfig.make("composters");
    public static final ILikeWoodConfig CRAFTING_TABLES_CONFIG = ILikeWoodConfig.make("crafting_tables");
    public static final ILikeWoodConfig CHESTS_CONFIG = ILikeWoodConfig.make("chests");
    public static final ILikeWoodConfig SAWMILLS_CONFIG = ILikeWoodConfig.make("sawmills");
    public static final ILikeWoodConfig LECTERNS_CONFIG = ILikeWoodConfig.make("lecterns");
    public static final ILikeWoodConfig LADDERS_CONFIG = ILikeWoodConfig.make("ladders");
    public static final ILikeWoodConfig SCAFFOLDINGS_CONFIG = ILikeWoodConfig.make("scaffoldings");
    public static final ILikeWoodConfig TORCHES_CONFIG = ILikeWoodConfig.make("torches");
    public static final ILikeWoodConfig LOG_PILE_CONFIG = ILikeWoodConfig.make("log_piles");
    public static final ILikeWoodConfig POSTS_CONFIG = ILikeWoodConfig.make("posts");
    public static final ILikeWoodConfig WALLS_CONFIG = ILikeWoodConfig.make("walls");
    public static final ILikeWoodConfig CHAIRS_CONFIG = ILikeWoodConfig.make("chairs");
    public static final ILikeWoodConfig TABLES_CONFIG = ILikeWoodConfig.make("tables");
    public static final ILikeWoodConfig STOOLS_CONFIG = ILikeWoodConfig.make("stools");
    public static final ILikeWoodConfig SINGLE_DRESSERS_CONFIG = ILikeWoodConfig.make("single_dressers");
    public static final ILikeWoodConfig STICKS_CONFIG = ILikeWoodConfig.make("sticks");
    public static final ILikeWoodConfig BOWS_CONFIG = ILikeWoodConfig.make("bows");
    public static final ILikeWoodConfig CROSSBOWS_CONFIG = ILikeWoodConfig.make("crossbows");
    public static final ILikeWoodConfig FISHING_RODS_CONFIG = ILikeWoodConfig.make("fishing_rods");
    public static final ILikeWoodConfig ITEM_FRAMES_CONFIG = ILikeWoodConfig.make("item_frames");
    public static final ILikeWoodConfig AXES_CONFIG = ILikeWoodConfig.make("axes");
    public static final ILikeWoodConfig HOES_CONFIG = ILikeWoodConfig.make("hoes");
    public static final ILikeWoodConfig PICKAXES_CONFIG = ILikeWoodConfig.make("pickaxes");
    public static final ILikeWoodConfig SHOVELS_CONFIG = ILikeWoodConfig.make("shovels");
    public static final ILikeWoodConfig SWORDS_CONFIG = ILikeWoodConfig.make("swords");
    public static final ILikeWoodConfig CAMPFIRE_CONFIG = ILikeWoodConfig.make("campfires");
    public static final ILikeWoodConfig PAINTING_CONFIG = ILikeWoodConfig.make("paintings");
    public static final ILikeWoodConfig CRATE_CONFIG = ILikeWoodConfig.make("crates");
    public static final Map<String, ILikeWoodConfig> NAME_TO_CONFIG = ILikeWoodConfig.getAll().collect(Collectors.toUnmodifiableMap(ILikeWoodConfig::name, Function.identity()));
    public static final ForgeConfigSpec COMMON_SPEC;
    private static final CommonConfig COMMON_CONFIG;

    public static Stream<ILikeWoodConfig> getAll() {
        return Stream.of(PANELS_CONFIG, PANELS_STAIRS_CONFIG, PANELS_SLABS_CONFIG, BARRELS_CONFIG, BEDS_CONFIG, BOOKSHELVES_CONFIG, COMPOSTERS_CONFIG, CRAFTING_TABLES_CONFIG, CHESTS_CONFIG, SAWMILLS_CONFIG, LECTERNS_CONFIG, LADDERS_CONFIG, SCAFFOLDINGS_CONFIG, TORCHES_CONFIG, LOG_PILE_CONFIG, POSTS_CONFIG, WALLS_CONFIG, CHAIRS_CONFIG, TABLES_CONFIG, STOOLS_CONFIG, SINGLE_DRESSERS_CONFIG, STICKS_CONFIG, BOWS_CONFIG, CROSSBOWS_CONFIG, FISHING_RODS_CONFIG, ITEM_FRAMES_CONFIG, AXES_CONFIG, HOES_CONFIG, PICKAXES_CONFIG, SHOVELS_CONFIG, SWORDS_CONFIG, CAMPFIRE_CONFIG, PAINTING_CONFIG, CRATE_CONFIG);
    }

    private static ILikeWoodConfig make(String name) {
        return new ILikeWoodConfig(name, (Supplier<Boolean>)Suppliers.memoize(() -> COMMON_CONFIG.isEnabled(name) || DatagenModLoader.isRunningDataGen()));
    }

    public boolean isEnabled() {
        return this.flag.get();
    }

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)common.getRight();
        COMMON_CONFIG = (CommonConfig)common.getLeft();
    }

    public static class CommonConfig {
        private final Map<String, ForgeConfigSpec.BooleanValue> values = new HashMap<String, ForgeConfigSpec.BooleanValue>();

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            ILikeWoodConfig.getAll().forEach(config -> this.values.put(config.name(), builder.define(String.format("ilikewood.enable.%s", config.name()), true)));
        }

        public boolean isEnabled(String name) {
            if (!this.values.containsKey(name)) {
                throw new IllegalArgumentException(String.format("Missing option for \"%s\" in common config file.", name));
            }
            return (Boolean)this.values.get(name).get();
        }
    }
}

