/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public class WoodenItemFrameEntity
extends ItemFrame
implements IWooden,
IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(WoodenItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> ROTATION = SynchedEntityData.m_135353_(WoodenItemFrameEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final IWoodType woodType;
    private final LazyLoadedValue<Item> drop;

    public WoodenItemFrameEntity(IWoodType woodType, EntityType<? extends ItemFrame> entityType, Level world) {
        super(entityType, world);
        this.woodType = woodType;
        this.drop = new LazyLoadedValue(ILikeWood.ITEM_REGISTRY.getRegistryObject(woodType, WoodenItemType.ITEM_FRAME));
    }

    public WoodenItemFrameEntity(IWoodType woodType, EntityType<? extends ItemFrame> entityType, Level world, BlockPos blockPos, Direction direction) {
        super(entityType, world);
        this.woodType = woodType;
        this.f_31698_ = blockPos;
        this.drop = new LazyLoadedValue(ILikeWood.ITEM_REGISTRY.getRegistryObject(woodType, WoodenItemType.ITEM_FRAME));
        this.m_6022_(direction);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(ROTATION, (Object)0);
    }

    @Nonnull
    public ItemStack m_31822_() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public void m_31789_(ItemStack stack, boolean b) {
        if (!stack.m_41619_()) {
            stack = stack.m_41777_();
            stack.m_41764_(1);
            stack.m_41636_((Entity)this);
        }
        this.m_20088_().m_135381_(ITEM, (Object)stack);
        if (!stack.m_41619_()) {
            this.m_5496_(SoundEvents.f_12013_, 1.0f, 1.0f);
        }
        if (b && this.f_31698_ != null) {
            this.f_19853_.m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        ItemStack itemstack;
        if (key.equals(ITEM) && !(itemstack = this.m_31822_()).m_41619_() && itemstack.m_41795_() != this) {
            itemstack.m_41636_((Entity)this);
        }
    }

    public void m_31802_(@Nullable Entity entityIn, boolean dropSelf) {
        if (!this.f_31755_) {
            ItemStack itemstack = this.m_31822_();
            this.m_31805_(ItemStack.f_41583_);
            if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                if (entityIn == null) {
                    this.m_31810_(itemstack);
                }
            } else {
                if (entityIn instanceof Player) {
                    Player playerentity = (Player)entityIn;
                    if (playerentity.m_150110_().f_35937_) {
                        this.m_31810_(itemstack);
                        return;
                    }
                }
                if (dropSelf) {
                    this.m_19998_((ItemLike)this.drop.m_13971_());
                }
                if (!itemstack.m_41619_()) {
                    itemstack = itemstack.m_41777_();
                    this.m_31810_(itemstack);
                    if (this.f_19796_.m_188501_() < this.f_31754_) {
                        this.m_19983_(itemstack);
                    }
                }
            }
        }
    }

    public int m_31823_() {
        return (Integer)this.m_20088_().m_135370_(ROTATION);
    }

    public void m_31772_(int rotationIn, boolean p_174865_2_) {
        this.m_20088_().m_135381_(ROTATION, (Object)(rotationIn % 8));
        if (p_174865_2_ && this.f_31698_ != null) {
            this.f_19853_.m_46717_(this.f_31698_, Blocks.f_50016_);
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.f_31698_);
        buffer.writeInt(this.f_31699_.m_122411_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_31698_ = additionalData.m_130135_();
        this.f_31699_ = Direction.m_122376_((int)additionalData.readInt());
        this.m_7087_();
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }
}

