/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.entity;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.item.WoodenPaintingItem;
import yamahari.ilikewood.plugin.vanilla.VanillaWoodTypes;
import yamahari.ilikewood.registry.woodtype.IWoodType;
import yamahari.ilikewood.util.IWooden;

public final class WoodenPaintingEntity
extends Painting
implements IWooden {
    private static final EntityDataAccessor<String> DATA_WOOD_TYPE_RESOURCE_LOCATION = SynchedEntityData.m_135353_(WoodenPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private IWoodType woodType = VanillaWoodTypes.OAK;

    public WoodenPaintingEntity(EntityType<? extends WoodenPaintingEntity> entityType, Level level) {
        super(entityType, level);
    }

    private static int getVariantArea(Holder<PaintingVariant> holder) {
        return ((PaintingVariant)holder.m_203334_()).m_218908_() * ((PaintingVariant)holder.m_203334_()).m_218909_();
    }

    public static Optional<WoodenPaintingEntity> create(Level level, BlockPos blockPos, Direction direction, IWoodType woodType, EntityType<? extends WoodenPaintingEntity> entityType) {
        WoodenPaintingEntity painting = new WoodenPaintingEntity(entityType, level);
        painting.setWoodType(woodType);
        painting.f_31698_ = blockPos;
        ArrayList<Holder> list = new ArrayList<Holder>();
        Registry.f_235728_.m_206058_(PaintingVariantTags.f_215870_).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.m_6022_(direction);
        list.removeIf(holder -> {
            painting.m_218891_((Holder)holder);
            return !painting.m_7088_();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int maxArea = list.stream().mapToInt(WoodenPaintingEntity::getVariantArea).max().orElse(0);
        list.removeIf(p_218883_ -> WoodenPaintingEntity.getVariantArea((Holder<PaintingVariant>)p_218883_) < maxArea);
        Optional optional = Util.m_214676_(list, (RandomSource)painting.f_19796_);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.m_218891_((Holder)optional.get());
        painting.m_6022_(direction);
        return Optional.of(painting);
    }

    @Nonnull
    public InteractionResult m_6096_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack itemInHand;
        if (hand == InteractionHand.MAIN_HAND && !player.m_36341_() && !(itemInHand = player.m_21120_(hand)).m_41619_() && itemInHand.m_41720_() instanceof WoodenPaintingItem) {
            Holder currentVariant = (Holder)this.f_19804_.m_135370_(f_218870_);
            ArrayList list = new ArrayList();
            Registry.f_235728_.m_206058_(PaintingVariantTags.f_215870_).forEach(variant -> {
                if (currentVariant != variant && ((PaintingVariant)variant.get()).m_218908_() == ((PaintingVariant)currentVariant.get()).m_218908_() && ((PaintingVariant)variant.get()).m_218909_() == ((PaintingVariant)currentVariant.get()).m_218909_()) {
                    list.add(variant);
                }
            });
            Level level = player.m_9236_();
            if (!level.m_5776_()) {
                if (list.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                this.f_19804_.m_135381_(f_218870_, (Object)((Holder)Util.m_214621_(list, (RandomSource)this.f_19796_)));
                return InteractionResult.SUCCESS;
            }
            return list.isEmpty() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOD_TYPE_RESOURCE_LOCATION, (Object)new ResourceLocation(VanillaWoodTypes.OAK.getModId(), VanillaWoodTypes.OAK.getName()).toString());
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (DATA_WOOD_TYPE_RESOURCE_LOCATION.equals(dataAccessor)) {
            this.woodType = ILikeWood.WOOD_TYPE_REGISTRY.get(new ResourceLocation((String)this.f_19804_.m_135370_(DATA_WOOD_TYPE_RESOURCE_LOCATION)));
        }
    }

    public void m_7380_(@Nonnull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("wood_type", (String)this.f_19804_.m_135370_(DATA_WOOD_TYPE_RESOURCE_LOCATION));
    }

    public void m_7378_(@Nonnull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        String woodType = compoundTag.m_128461_("wood_type");
        this.f_19804_.m_135381_(DATA_WOOD_TYPE_RESOURCE_LOCATION, (Object)(woodType.isEmpty() ? new ResourceLocation("ilikewood", VanillaWoodTypes.OAK.getName()).toString() : woodType));
    }

    @Override
    public IWoodType getWoodType() {
        return this.woodType;
    }

    public void setWoodType(IWoodType woodType) {
        this.f_19804_.m_135381_(DATA_WOOD_TYPE_RESOURCE_LOCATION, (Object)new ResourceLocation(woodType.getModId(), woodType.getName()).toString());
    }
}

