/*
 * Decompiled with CFR 0.152.
 */
package yamahari.ilikewood.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import yamahari.ilikewood.ILikeWood;
import yamahari.ilikewood.entity.WoodenItemFrameEntity;
import yamahari.ilikewood.item.WoodenItem;
import yamahari.ilikewood.registry.objecttype.WoodenEntityType;
import yamahari.ilikewood.registry.objecttype.WoodenItemType;
import yamahari.ilikewood.registry.woodtype.IWoodType;

public final class WoodenItemFrameItem
extends WoodenItem {
    private final Supplier<EntityType<? extends ItemFrame>> entityType = Suppliers.memoize(() -> (EntityType)ILikeWood.ENTITY_TYPE_REGISTRY.getObject(this.getWoodType(), WoodenEntityType.ITEM_FRAME));

    public WoodenItemFrameItem(IWoodType woodType) {
        super(woodType, WoodenItemType.ITEM_FRAME, new Item.Properties().m_41491_(CreativeModeTab.f_40750_));
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos offsetPos = blockPos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        if (player != null && !this.canPlace(player, direction, itemStack, offsetPos)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        WoodenItemFrameEntity hangingEntity = new WoodenItemFrameEntity(this.getWoodType(), this.entityType.get(), world, offsetPos, direction);
        CompoundTag compoundNBT = itemStack.m_41783_();
        if (compoundNBT != null) {
            EntityType.m_20620_((Level)world, (Player)player, (Entity)hangingEntity, (CompoundTag)compoundNBT);
        }
        if (hangingEntity.m_7088_()) {
            if (!world.f_46443_) {
                hangingEntity.m_7084_();
                world.m_7967_((Entity)hangingEntity);
            }
            itemStack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    private boolean canPlace(Player player, Direction direction, ItemStack itemStack, BlockPos blockPos) {
        return !player.f_19853_.m_151570_(blockPos) && player.m_36204_(blockPos, direction, itemStack);
    }
}

